// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImagesInput
type ListCuratedEnvironmentImagesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListCuratedEnvironmentImagesInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImagesOutput
type ListCuratedEnvironmentImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about supported platforms for Docker images that are managed
	// by AWS CodeBuild.
	Platforms []EnvironmentPlatform `locationName:"platforms" type:"list"`
}

// String returns the string representation
func (s ListCuratedEnvironmentImagesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListCuratedEnvironmentImages = "ListCuratedEnvironmentImages"

// ListCuratedEnvironmentImagesRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Gets information about Docker images that are managed by AWS CodeBuild.
//
//    // Example sending a request using ListCuratedEnvironmentImagesRequest.
//    req := client.ListCuratedEnvironmentImagesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/ListCuratedEnvironmentImages
func (c *Client) ListCuratedEnvironmentImagesRequest(input *ListCuratedEnvironmentImagesInput) ListCuratedEnvironmentImagesRequest {
	op := &aws.Operation{
		Name:       opListCuratedEnvironmentImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCuratedEnvironmentImagesInput{}
	}

	req := c.newRequest(op, input, &ListCuratedEnvironmentImagesOutput{})
	return ListCuratedEnvironmentImagesRequest{Request: req, Input: input, Copy: c.ListCuratedEnvironmentImagesRequest}
}

// ListCuratedEnvironmentImagesRequest is the request type for the
// ListCuratedEnvironmentImages API operation.
type ListCuratedEnvironmentImagesRequest struct {
	*aws.Request
	Input *ListCuratedEnvironmentImagesInput
	Copy  func(*ListCuratedEnvironmentImagesInput) ListCuratedEnvironmentImagesRequest
}

// Send marshals and sends the ListCuratedEnvironmentImages API request.
func (r ListCuratedEnvironmentImagesRequest) Send(ctx context.Context) (*ListCuratedEnvironmentImagesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCuratedEnvironmentImagesResponse{
		ListCuratedEnvironmentImagesOutput: r.Request.Data.(*ListCuratedEnvironmentImagesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListCuratedEnvironmentImagesResponse is the response type for the
// ListCuratedEnvironmentImages API operation.
type ListCuratedEnvironmentImagesResponse struct {
	*ListCuratedEnvironmentImagesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCuratedEnvironmentImages request.
func (r *ListCuratedEnvironmentImagesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
