// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to reset a user's password.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPasswordRequest
type ForgotPasswordInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for ForgotPassword
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The ID of the client associated with the user pool.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true"`

	// A keyed-hash message authentication code (HMAC) calculated using the secret
	// key of a user pool client and username plus the client ID in the message.
	SecretHash *string `min:"1" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`

	// The user name of the user for whom you want to enter a code to reset a forgotten
	// password.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ForgotPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ForgotPasswordInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ForgotPasswordInput"}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}
	if s.SecretHash != nil && len(*s.SecretHash) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretHash", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Respresents the response from the server regarding the request to reset a
// password.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPasswordResponse
type ForgotPasswordOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to reset a password.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s ForgotPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

const opForgotPassword = "ForgotPassword"

// ForgotPasswordRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Calling this API causes a message to be sent to the end user with a confirmation
// code that is required to change the user's password. For the Username parameter,
// you can use the username or user alias. If a verified phone number exists
// for the user, the confirmation code is sent to the phone number. Otherwise,
// if a verified email exists, the confirmation code is sent to the email. If
// neither a verified phone number nor a verified email exists, InvalidParameterException
// is thrown. To use the confirmation code for resetting the password, call .
//
//    // Example sending a request using ForgotPasswordRequest.
//    req := client.ForgotPasswordRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ForgotPassword
func (c *Client) ForgotPasswordRequest(input *ForgotPasswordInput) ForgotPasswordRequest {
	op := &aws.Operation{
		Name:       opForgotPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ForgotPasswordInput{}
	}

	req := c.newRequest(op, input, &ForgotPasswordOutput{})
	req.Config.Credentials = aws.AnonymousCredentials
	return ForgotPasswordRequest{Request: req, Input: input, Copy: c.ForgotPasswordRequest}
}

// ForgotPasswordRequest is the request type for the
// ForgotPassword API operation.
type ForgotPasswordRequest struct {
	*aws.Request
	Input *ForgotPasswordInput
	Copy  func(*ForgotPasswordInput) ForgotPasswordRequest
}

// Send marshals and sends the ForgotPassword API request.
func (r ForgotPasswordRequest) Send(ctx context.Context) (*ForgotPasswordResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ForgotPasswordResponse{
		ForgotPasswordOutput: r.Request.Data.(*ForgotPasswordOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ForgotPasswordResponse is the response type for the
// ForgotPassword API operation.
type ForgotPasswordResponse struct {
	*ForgotPasswordOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ForgotPassword request.
func (r *ForgotPasswordResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
