// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummaryRequest
type GetAggregateConfigRuleComplianceSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the configuration aggregator.
	//
	// ConfigurationAggregatorName is a required field
	ConfigurationAggregatorName *string `min:"1" type:"string" required:"true"`

	// Filters the results based on the ConfigRuleComplianceSummaryFilters object.
	Filters *ConfigRuleComplianceSummaryFilters `type:"structure"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey ConfigRuleComplianceSummaryGroupKey `type:"string" enum:"true"`

	// The maximum number of evaluation results returned on each page. The default
	// is 1000. You cannot specify a number greater than 1000. If you specify 0,
	// AWS Config uses the default.
	Limit *int64 `type:"integer"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAggregateConfigRuleComplianceSummaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAggregateConfigRuleComplianceSummaryInput"}

	if s.ConfigurationAggregatorName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationAggregatorName"))
	}
	if s.ConfigurationAggregatorName != nil && len(*s.ConfigurationAggregatorName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationAggregatorName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummaryResponse
type GetAggregateConfigRuleComplianceSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of AggregateComplianceCounts object.
	AggregateComplianceCounts []AggregateComplianceCount `type:"list"`

	// Groups the result based on ACCOUNT_ID or AWS_REGION.
	GroupByKey *string `min:"1" type:"string"`

	// The nextToken string returned on a previous page that you use to get the
	// next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAggregateConfigRuleComplianceSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAggregateConfigRuleComplianceSummary = "GetAggregateConfigRuleComplianceSummary"

// GetAggregateConfigRuleComplianceSummaryRequest returns a request value for making API operation for
// AWS Config.
//
// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
//
// The results can return an empty result page, but if you have a nextToken,
// the results are displayed on the next page.
//
//    // Example sending a request using GetAggregateConfigRuleComplianceSummaryRequest.
//    req := client.GetAggregateConfigRuleComplianceSummaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetAggregateConfigRuleComplianceSummary
func (c *Client) GetAggregateConfigRuleComplianceSummaryRequest(input *GetAggregateConfigRuleComplianceSummaryInput) GetAggregateConfigRuleComplianceSummaryRequest {
	op := &aws.Operation{
		Name:       opGetAggregateConfigRuleComplianceSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAggregateConfigRuleComplianceSummaryInput{}
	}

	req := c.newRequest(op, input, &GetAggregateConfigRuleComplianceSummaryOutput{})
	return GetAggregateConfigRuleComplianceSummaryRequest{Request: req, Input: input, Copy: c.GetAggregateConfigRuleComplianceSummaryRequest}
}

// GetAggregateConfigRuleComplianceSummaryRequest is the request type for the
// GetAggregateConfigRuleComplianceSummary API operation.
type GetAggregateConfigRuleComplianceSummaryRequest struct {
	*aws.Request
	Input *GetAggregateConfigRuleComplianceSummaryInput
	Copy  func(*GetAggregateConfigRuleComplianceSummaryInput) GetAggregateConfigRuleComplianceSummaryRequest
}

// Send marshals and sends the GetAggregateConfigRuleComplianceSummary API request.
func (r GetAggregateConfigRuleComplianceSummaryRequest) Send(ctx context.Context) (*GetAggregateConfigRuleComplianceSummaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAggregateConfigRuleComplianceSummaryResponse{
		GetAggregateConfigRuleComplianceSummaryOutput: r.Request.Data.(*GetAggregateConfigRuleComplianceSummaryOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAggregateConfigRuleComplianceSummaryResponse is the response type for the
// GetAggregateConfigRuleComplianceSummary API operation.
type GetAggregateConfigRuleComplianceSummaryResponse struct {
	*GetAggregateConfigRuleComplianceSummaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAggregateConfigRuleComplianceSummary request.
func (r *GetAggregateConfigRuleComplianceSummaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
