// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to delete the specified remote access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSessionRequest
type DeleteRemoteAccessSessionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the sesssion for which you want to delete
	// remote access.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRemoteAccessSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRemoteAccessSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRemoteAccessSessionInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response from the server when a request is made to delete the remote
// access session.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSessionResult
type DeleteRemoteAccessSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRemoteAccessSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRemoteAccessSession = "DeleteRemoteAccessSession"

// DeleteRemoteAccessSessionRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Deletes a completed remote access session and its results.
//
//    // Example sending a request using DeleteRemoteAccessSessionRequest.
//    req := client.DeleteRemoteAccessSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/DeleteRemoteAccessSession
func (c *Client) DeleteRemoteAccessSessionRequest(input *DeleteRemoteAccessSessionInput) DeleteRemoteAccessSessionRequest {
	op := &aws.Operation{
		Name:       opDeleteRemoteAccessSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRemoteAccessSessionInput{}
	}

	req := c.newRequest(op, input, &DeleteRemoteAccessSessionOutput{})
	return DeleteRemoteAccessSessionRequest{Request: req, Input: input, Copy: c.DeleteRemoteAccessSessionRequest}
}

// DeleteRemoteAccessSessionRequest is the request type for the
// DeleteRemoteAccessSession API operation.
type DeleteRemoteAccessSessionRequest struct {
	*aws.Request
	Input *DeleteRemoteAccessSessionInput
	Copy  func(*DeleteRemoteAccessSessionInput) DeleteRemoteAccessSessionRequest
}

// Send marshals and sends the DeleteRemoteAccessSession API request.
func (r DeleteRemoteAccessSessionRequest) Send(ctx context.Context) (*DeleteRemoteAccessSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRemoteAccessSessionResponse{
		DeleteRemoteAccessSessionOutput: r.Request.Data.(*DeleteRemoteAccessSessionOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRemoteAccessSessionResponse is the response type for the
// DeleteRemoteAccessSession API operation.
type DeleteRemoteAccessSessionResponse struct {
	*DeleteRemoteAccessSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRemoteAccessSession request.
func (r *DeleteRemoteAccessSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
