// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DeleteNetworkInterfacePermission.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermissionRequest
type DeleteNetworkInterfacePermissionInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// Specify true to remove the permission even if the network interface is attached
	// to an instance.
	Force *bool `type:"boolean"`

	// The ID of the network interface permission.
	//
	// NetworkInterfacePermissionId is a required field
	NetworkInterfacePermissionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNetworkInterfacePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNetworkInterfacePermissionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNetworkInterfacePermissionInput"}

	if s.NetworkInterfacePermissionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkInterfacePermissionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output for DeleteNetworkInterfacePermission.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermissionResult
type DeleteNetworkInterfacePermissionOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds, otherwise returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s DeleteNetworkInterfacePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteNetworkInterfacePermission = "DeleteNetworkInterfacePermission"

// DeleteNetworkInterfacePermissionRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Deletes a permission for a network interface. By default, you cannot delete
// the permission if the account for which you're removing the permission has
// attached the network interface to an instance. However, you can force delete
// the permission, regardless of any attachment.
//
//    // Example sending a request using DeleteNetworkInterfacePermissionRequest.
//    req := client.DeleteNetworkInterfacePermissionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DeleteNetworkInterfacePermission
func (c *Client) DeleteNetworkInterfacePermissionRequest(input *DeleteNetworkInterfacePermissionInput) DeleteNetworkInterfacePermissionRequest {
	op := &aws.Operation{
		Name:       opDeleteNetworkInterfacePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNetworkInterfacePermissionInput{}
	}

	req := c.newRequest(op, input, &DeleteNetworkInterfacePermissionOutput{})
	return DeleteNetworkInterfacePermissionRequest{Request: req, Input: input, Copy: c.DeleteNetworkInterfacePermissionRequest}
}

// DeleteNetworkInterfacePermissionRequest is the request type for the
// DeleteNetworkInterfacePermission API operation.
type DeleteNetworkInterfacePermissionRequest struct {
	*aws.Request
	Input *DeleteNetworkInterfacePermissionInput
	Copy  func(*DeleteNetworkInterfacePermissionInput) DeleteNetworkInterfacePermissionRequest
}

// Send marshals and sends the DeleteNetworkInterfacePermission API request.
func (r DeleteNetworkInterfacePermissionRequest) Send(ctx context.Context) (*DeleteNetworkInterfacePermissionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNetworkInterfacePermissionResponse{
		DeleteNetworkInterfacePermissionOutput: r.Request.Data.(*DeleteNetworkInterfacePermissionOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNetworkInterfacePermissionResponse is the response type for the
// DeleteNetworkInterfacePermission API operation.
type DeleteNetworkInterfacePermissionResponse struct {
	*DeleteNetworkInterfacePermissionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNetworkInterfacePermission request.
func (r *DeleteNetworkInterfacePermissionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
