// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTablesRequest
type DescribeTransitGatewayRouteTablesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters. The possible values are:
	//
	//    * default-association-route-table - Indicates whether this is the default
	//    association route table for the transit gateway (true | false).
	//
	//    * default-propagation-route-table - Indicates whether this is the default
	//    propagation route table for the transit gateway (true | false).
	//
	//    * state - The state of the attachment (available | deleted | deleting
	//    | failed | modifying | pendingAcceptance | pending | rollingBack | rejected
	//    | rejecting).
	//
	//    * transit-gateway-id - The ID of the transit gateway.
	//
	//    * transit-gateway-route-table-id - The ID of the transit gateway route
	//    table.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int64 `min:"5" type:"integer"`

	// The token for the next page of results.
	NextToken *string `type:"string"`

	// The IDs of the transit gateway route tables.
	TransitGatewayRouteTableIds []string `locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewayRouteTablesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTransitGatewayRouteTablesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTransitGatewayRouteTablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTablesResult
type DescribeTransitGatewayRouteTablesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the transit gateway route tables.
	TransitGatewayRouteTables []TransitGatewayRouteTable `locationName:"transitGatewayRouteTables" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeTransitGatewayRouteTablesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTransitGatewayRouteTables = "DescribeTransitGatewayRouteTables"

// DescribeTransitGatewayRouteTablesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more transit gateway route tables. By default, all transit
// gateway route tables are described. Alternatively, you can filter the results.
//
//    // Example sending a request using DescribeTransitGatewayRouteTablesRequest.
//    req := client.DescribeTransitGatewayRouteTablesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeTransitGatewayRouteTables
func (c *Client) DescribeTransitGatewayRouteTablesRequest(input *DescribeTransitGatewayRouteTablesInput) DescribeTransitGatewayRouteTablesRequest {
	op := &aws.Operation{
		Name:       opDescribeTransitGatewayRouteTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTransitGatewayRouteTablesInput{}
	}

	req := c.newRequest(op, input, &DescribeTransitGatewayRouteTablesOutput{})
	return DescribeTransitGatewayRouteTablesRequest{Request: req, Input: input, Copy: c.DescribeTransitGatewayRouteTablesRequest}
}

// DescribeTransitGatewayRouteTablesRequest is the request type for the
// DescribeTransitGatewayRouteTables API operation.
type DescribeTransitGatewayRouteTablesRequest struct {
	*aws.Request
	Input *DescribeTransitGatewayRouteTablesInput
	Copy  func(*DescribeTransitGatewayRouteTablesInput) DescribeTransitGatewayRouteTablesRequest
}

// Send marshals and sends the DescribeTransitGatewayRouteTables API request.
func (r DescribeTransitGatewayRouteTablesRequest) Send(ctx context.Context) (*DescribeTransitGatewayRouteTablesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTransitGatewayRouteTablesResponse{
		DescribeTransitGatewayRouteTablesOutput: r.Request.Data.(*DescribeTransitGatewayRouteTablesOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeTransitGatewayRouteTablesRequestPaginator returns a paginator for DescribeTransitGatewayRouteTables.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeTransitGatewayRouteTablesRequest(input)
//   p := ec2.NewDescribeTransitGatewayRouteTablesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeTransitGatewayRouteTablesPaginator(req DescribeTransitGatewayRouteTablesRequest) DescribeTransitGatewayRouteTablesPaginator {
	return DescribeTransitGatewayRouteTablesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeTransitGatewayRouteTablesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeTransitGatewayRouteTablesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeTransitGatewayRouteTablesPaginator struct {
	aws.Pager
}

func (p *DescribeTransitGatewayRouteTablesPaginator) CurrentPage() *DescribeTransitGatewayRouteTablesOutput {
	return p.Pager.CurrentPage().(*DescribeTransitGatewayRouteTablesOutput)
}

// DescribeTransitGatewayRouteTablesResponse is the response type for the
// DescribeTransitGatewayRouteTables API operation.
type DescribeTransitGatewayRouteTablesResponse struct {
	*DescribeTransitGatewayRouteTablesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTransitGatewayRouteTables request.
func (r *DescribeTransitGatewayRouteTablesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
