// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcPeeringConnectionOptionsRequest
type ModifyVpcPeeringConnectionOptionsInput struct {
	_ struct{} `type:"structure"`

	// The VPC peering connection options for the accepter VPC.
	AccepterPeeringConnectionOptions *PeeringConnectionOptionsRequest `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The VPC peering connection options for the requester VPC.
	RequesterPeeringConnectionOptions *PeeringConnectionOptionsRequest `type:"structure"`

	// The ID of the VPC peering connection.
	//
	// VpcPeeringConnectionId is a required field
	VpcPeeringConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyVpcPeeringConnectionOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyVpcPeeringConnectionOptionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyVpcPeeringConnectionOptionsInput"}

	if s.VpcPeeringConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcPeeringConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcPeeringConnectionOptionsResult
type ModifyVpcPeeringConnectionOptionsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the VPC peering connection options for the accepter VPC.
	AccepterPeeringConnectionOptions *PeeringConnectionOptions `locationName:"accepterPeeringConnectionOptions" type:"structure"`

	// Information about the VPC peering connection options for the requester VPC.
	RequesterPeeringConnectionOptions *PeeringConnectionOptions `locationName:"requesterPeeringConnectionOptions" type:"structure"`
}

// String returns the string representation
func (s ModifyVpcPeeringConnectionOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyVpcPeeringConnectionOptions = "ModifyVpcPeeringConnectionOptions"

// ModifyVpcPeeringConnectionOptionsRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modifies the VPC peering connection options on one side of a VPC peering
// connection. You can do the following:
//
//    * Enable/disable communication over the peering connection between an
//    EC2-Classic instance that's linked to your VPC (using ClassicLink) and
//    instances in the peer VPC.
//
//    * Enable/disable communication over the peering connection between instances
//    in your VPC and an EC2-Classic instance that's linked to the peer VPC.
//
//    * Enable/disable the ability to resolve public DNS hostnames to private
//    IP addresses when queried from instances in the peer VPC.
//
// If the peered VPCs are in the same AWS account, you can enable DNS resolution
// for queries from the local VPC. This ensures that queries from the local
// VPC resolve to private IP addresses in the peer VPC. This option is not available
// if the peered VPCs are in different AWS accounts or different Regions. For
// peered VPCs in different AWS accounts, each AWS account owner must initiate
// a separate request to modify the peering connection options. For inter-region
// peering connections, you must use the Region for the requester VPC to modify
// the requester VPC peering options and the Region for the accepter VPC to
// modify the accepter VPC peering options. To verify which VPCs are the accepter
// and the requester for a VPC peering connection, use the DescribeVpcPeeringConnections
// command.
//
//    // Example sending a request using ModifyVpcPeeringConnectionOptionsRequest.
//    req := client.ModifyVpcPeeringConnectionOptionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVpcPeeringConnectionOptions
func (c *Client) ModifyVpcPeeringConnectionOptionsRequest(input *ModifyVpcPeeringConnectionOptionsInput) ModifyVpcPeeringConnectionOptionsRequest {
	op := &aws.Operation{
		Name:       opModifyVpcPeeringConnectionOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpcPeeringConnectionOptionsInput{}
	}

	req := c.newRequest(op, input, &ModifyVpcPeeringConnectionOptionsOutput{})
	return ModifyVpcPeeringConnectionOptionsRequest{Request: req, Input: input, Copy: c.ModifyVpcPeeringConnectionOptionsRequest}
}

// ModifyVpcPeeringConnectionOptionsRequest is the request type for the
// ModifyVpcPeeringConnectionOptions API operation.
type ModifyVpcPeeringConnectionOptionsRequest struct {
	*aws.Request
	Input *ModifyVpcPeeringConnectionOptionsInput
	Copy  func(*ModifyVpcPeeringConnectionOptionsInput) ModifyVpcPeeringConnectionOptionsRequest
}

// Send marshals and sends the ModifyVpcPeeringConnectionOptions API request.
func (r ModifyVpcPeeringConnectionOptionsRequest) Send(ctx context.Context) (*ModifyVpcPeeringConnectionOptionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyVpcPeeringConnectionOptionsResponse{
		ModifyVpcPeeringConnectionOptionsOutput: r.Request.Data.(*ModifyVpcPeeringConnectionOptionsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyVpcPeeringConnectionOptionsResponse is the response type for the
// ModifyVpcPeeringConnectionOptions API operation.
type ModifyVpcPeeringConnectionOptionsResponse struct {
	*ModifyVpcPeeringConnectionOptionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyVpcPeeringConnectionOptions request.
func (r *ModifyVpcPeeringConnectionOptionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
