// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeClientVpnIngressRequest
type RevokeClientVpnIngressInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Active Directory group for which to revoke access.
	AccessGroupId *string `type:"string"`

	// The ID of the Client VPN endpoint with which the authorization rule is associated.
	//
	// ClientVpnEndpointId is a required field
	ClientVpnEndpointId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// Indicates whether access should be revoked for all clients.
	RevokeAllGroups *bool `type:"boolean"`

	// The IPv4 address range, in CIDR notation, of the network for which access
	// is being removed.
	//
	// TargetNetworkCidr is a required field
	TargetNetworkCidr *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeClientVpnIngressInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeClientVpnIngressInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RevokeClientVpnIngressInput"}

	if s.ClientVpnEndpointId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientVpnEndpointId"))
	}

	if s.TargetNetworkCidr == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetNetworkCidr"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeClientVpnIngressResult
type RevokeClientVpnIngressOutput struct {
	_ struct{} `type:"structure"`

	// The current state of the authorization rule.
	Status *VpnAuthorizationRuleStatus `locationName:"status" type:"structure"`
}

// String returns the string representation
func (s RevokeClientVpnIngressOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeClientVpnIngress = "RevokeClientVpnIngress"

// RevokeClientVpnIngressRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Removes an ingress authorization rule from a Client VPN endpoint.
//
//    // Example sending a request using RevokeClientVpnIngressRequest.
//    req := client.RevokeClientVpnIngressRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RevokeClientVpnIngress
func (c *Client) RevokeClientVpnIngressRequest(input *RevokeClientVpnIngressInput) RevokeClientVpnIngressRequest {
	op := &aws.Operation{
		Name:       opRevokeClientVpnIngress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeClientVpnIngressInput{}
	}

	req := c.newRequest(op, input, &RevokeClientVpnIngressOutput{})
	return RevokeClientVpnIngressRequest{Request: req, Input: input, Copy: c.RevokeClientVpnIngressRequest}
}

// RevokeClientVpnIngressRequest is the request type for the
// RevokeClientVpnIngress API operation.
type RevokeClientVpnIngressRequest struct {
	*aws.Request
	Input *RevokeClientVpnIngressInput
	Copy  func(*RevokeClientVpnIngressInput) RevokeClientVpnIngressRequest
}

// Send marshals and sends the RevokeClientVpnIngress API request.
func (r RevokeClientVpnIngressRequest) Send(ctx context.Context) (*RevokeClientVpnIngressResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeClientVpnIngressResponse{
		RevokeClientVpnIngressOutput: r.Request.Data.(*RevokeClientVpnIngressOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeClientVpnIngressResponse is the response type for the
// RevokeClientVpnIngress API operation.
type RevokeClientVpnIngressResponse struct {
	*RevokeClientVpnIngressOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeClientVpnIngress request.
func (r *RevokeClientVpnIngressResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
