// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAccountSettingRequest
type DeleteAccountSettingInput struct {
	_ struct{} `type:"structure"`

	// The resource name for which to disable the new format. If serviceLongArnFormat
	// is specified, the ARN for your Amazon ECS services is affected. If taskLongArnFormat
	// is specified, the ARN and resource ID for your Amazon ECS tasks is affected.
	// If containerInstanceLongArnFormat is specified, the ARN and resource ID for
	// your Amazon ECS container instances is affected.
	//
	// Name is a required field
	Name SettingName `locationName:"name" type:"string" required:"true" enum:"true"`

	// The ARN of the principal, which can be an IAM user, IAM role, or the root
	// user. If you specify the root user, it modifies the ARN and resource ID format
	// for all IAM users, IAM roles, and the root user of the account unless an
	// IAM user or role explicitly overrides these settings for themselves. If this
	// field is omitted, the setting are changed only for the authenticated user.
	PrincipalArn *string `locationName:"principalArn" type:"string"`
}

// String returns the string representation
func (s DeleteAccountSettingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountSettingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAccountSettingInput"}
	if len(s.Name) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAccountSettingResponse
type DeleteAccountSettingOutput struct {
	_ struct{} `type:"structure"`

	// The account setting for the specified principal ARN.
	Setting *Setting `locationName:"setting" type:"structure"`
}

// String returns the string representation
func (s DeleteAccountSettingOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAccountSetting = "DeleteAccountSetting"

// DeleteAccountSettingRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Modifies the ARN and resource ID format of a resource for a specified IAM
// user, IAM role, or the root user for an account. You can specify whether
// the new ARN and resource ID format are disabled for new resources that are
// created.
//
//    // Example sending a request using DeleteAccountSettingRequest.
//    req := client.DeleteAccountSettingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DeleteAccountSetting
func (c *Client) DeleteAccountSettingRequest(input *DeleteAccountSettingInput) DeleteAccountSettingRequest {
	op := &aws.Operation{
		Name:       opDeleteAccountSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountSettingInput{}
	}

	req := c.newRequest(op, input, &DeleteAccountSettingOutput{})
	return DeleteAccountSettingRequest{Request: req, Input: input, Copy: c.DeleteAccountSettingRequest}
}

// DeleteAccountSettingRequest is the request type for the
// DeleteAccountSetting API operation.
type DeleteAccountSettingRequest struct {
	*aws.Request
	Input *DeleteAccountSettingInput
	Copy  func(*DeleteAccountSettingInput) DeleteAccountSettingRequest
}

// Send marshals and sends the DeleteAccountSetting API request.
func (r DeleteAccountSettingRequest) Send(ctx context.Context) (*DeleteAccountSettingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAccountSettingResponse{
		DeleteAccountSettingOutput: r.Request.Data.(*DeleteAccountSettingOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAccountSettingResponse is the response type for the
// DeleteAccountSetting API operation.
type DeleteAccountSettingResponse struct {
	*DeleteAccountSettingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAccountSetting request.
func (r *DeleteAccountSettingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
