// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeContainerInstancesRequest
type DescribeContainerInstancesInput struct {
	_ struct{} `type:"structure"`

	// The short name or full Amazon Resource Name (ARN) of the cluster that hosts
	// the container instances to describe. If you do not specify a cluster, the
	// default cluster is assumed.
	Cluster *string `locationName:"cluster" type:"string"`

	// A list of up to 100 container instance IDs or full Amazon Resource Name (ARN)
	// entries.
	//
	// ContainerInstances is a required field
	ContainerInstances []string `locationName:"containerInstances" type:"list" required:"true"`

	// Specifies whether you want to see the resource tags for the container instance.
	// If TAGS is specified, the tags are included in the response. If this field
	// is omitted, tags are not included in the response.
	Include []ContainerInstanceField `locationName:"include" type:"list"`
}

// String returns the string representation
func (s DescribeContainerInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContainerInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeContainerInstancesInput"}

	if s.ContainerInstances == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerInstances"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeContainerInstancesResponse
type DescribeContainerInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The list of container instances.
	ContainerInstances []ContainerInstance `locationName:"containerInstances" type:"list"`

	// Any failures associated with the call.
	Failures []Failure `locationName:"failures" type:"list"`
}

// String returns the string representation
func (s DescribeContainerInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeContainerInstances = "DescribeContainerInstances"

// DescribeContainerInstancesRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
// Describes Amazon Elastic Container Service container instances. Returns metadata
// about registered and remaining resources on each container instance requested.
//
//    // Example sending a request using DescribeContainerInstancesRequest.
//    req := client.DescribeContainerInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/DescribeContainerInstances
func (c *Client) DescribeContainerInstancesRequest(input *DescribeContainerInstancesInput) DescribeContainerInstancesRequest {
	op := &aws.Operation{
		Name:       opDescribeContainerInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeContainerInstancesInput{}
	}

	req := c.newRequest(op, input, &DescribeContainerInstancesOutput{})
	return DescribeContainerInstancesRequest{Request: req, Input: input, Copy: c.DescribeContainerInstancesRequest}
}

// DescribeContainerInstancesRequest is the request type for the
// DescribeContainerInstances API operation.
type DescribeContainerInstancesRequest struct {
	*aws.Request
	Input *DescribeContainerInstancesInput
	Copy  func(*DescribeContainerInstancesInput) DescribeContainerInstancesRequest
}

// Send marshals and sends the DescribeContainerInstances API request.
func (r DescribeContainerInstancesRequest) Send(ctx context.Context) (*DescribeContainerInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeContainerInstancesResponse{
		DescribeContainerInstancesOutput: r.Request.Data.(*DescribeContainerInstancesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeContainerInstancesResponse is the response type for the
// DescribeContainerInstances API operation.
type DescribeContainerInstancesResponse struct {
	*DescribeContainerInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeContainerInstances request.
func (r *DescribeContainerInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
