// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScriptsInput
type ListScriptsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListScriptsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScriptsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListScriptsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScriptsOutput
type ListScriptsOutput struct {
	_ struct{} `type:"structure"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// Set of properties describing the requested script.
	Scripts []Script `type:"list"`
}

// String returns the string representation
func (s ListScriptsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListScripts = "ListScripts"

// ListScriptsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves script records for all Realtime scripts that are associated with
// the AWS account in use.
//
// Learn more
//
// Amazon GameLift Realtime Servers (https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html)
//
// Related operations
//
//    * CreateScript
//
//    * ListScripts
//
//    * DescribeScript
//
//    * UpdateScript
//
//    * DeleteScript
//
//    // Example sending a request using ListScriptsRequest.
//    req := client.ListScriptsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts
func (c *Client) ListScriptsRequest(input *ListScriptsInput) ListScriptsRequest {
	op := &aws.Operation{
		Name:       opListScripts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListScriptsInput{}
	}

	req := c.newRequest(op, input, &ListScriptsOutput{})
	return ListScriptsRequest{Request: req, Input: input, Copy: c.ListScriptsRequest}
}

// ListScriptsRequest is the request type for the
// ListScripts API operation.
type ListScriptsRequest struct {
	*aws.Request
	Input *ListScriptsInput
	Copy  func(*ListScriptsInput) ListScriptsRequest
}

// Send marshals and sends the ListScripts API request.
func (r ListScriptsRequest) Send(ctx context.Context) (*ListScriptsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListScriptsResponse{
		ListScriptsOutput: r.Request.Data.(*ListScriptsOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListScriptsResponse is the response type for the
// ListScripts API operation.
type ListScriptsResponse struct {
	*ListScriptsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListScripts request.
func (r *ListScriptsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
