// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// The input values for AddTagsToVault.
type AddTagsToVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The tags to add to the vault. Each tag is composed of a key and a value.
	// The value can be an empty string.
	Tags map[string]string `type:"map"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s AddTagsToVaultInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToVaultInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddTagsToVaultInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddTagsToVaultInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AddTagsToVaultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddTagsToVaultOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opAddTagsToVault = "AddTagsToVault"

// AddTagsToVaultRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation adds the specified tags to a vault. Each tag is composed of
// a key and a value. Each vault can have up to 10 tags. If your request would
// cause the tag limit for the vault to be exceeded, the operation throws the
// LimitExceededException error. If a tag already exists on the vault under
// a specified key, the existing key value will be overwritten. For more information
// about tags, see Tagging Amazon Glacier Resources (http://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
//
//    // Example sending a request using AddTagsToVaultRequest.
//    req := client.AddTagsToVaultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) AddTagsToVaultRequest(input *AddTagsToVaultInput) AddTagsToVaultRequest {
	op := &aws.Operation{
		Name:       opAddTagsToVault,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags?operation=add",
	}

	if input == nil {
		input = &AddTagsToVaultInput{}
	}

	req := c.newRequest(op, input, &AddTagsToVaultOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AddTagsToVaultRequest{Request: req, Input: input, Copy: c.AddTagsToVaultRequest}
}

// AddTagsToVaultRequest is the request type for the
// AddTagsToVault API operation.
type AddTagsToVaultRequest struct {
	*aws.Request
	Input *AddTagsToVaultInput
	Copy  func(*AddTagsToVaultInput) AddTagsToVaultRequest
}

// Send marshals and sends the AddTagsToVault API request.
func (r AddTagsToVaultRequest) Send(ctx context.Context) (*AddTagsToVaultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AddTagsToVaultResponse{
		AddTagsToVaultOutput: r.Request.Data.(*AddTagsToVaultOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AddTagsToVaultResponse is the response type for the
// AddTagsToVault API operation.
type AddTagsToVaultResponse struct {
	*AddTagsToVaultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AddTagsToVault request.
func (r *AddTagsToVaultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
