// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Defines an action to be initiated by a trigger.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Action
type Action struct {
	_ struct{} `type:"structure"`

	// The job arguments used when this trigger fires. For this job run, they replace
	// the default arguments set in the job definition itself.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]string `type:"map"`

	// The name of a job to be executed.
	JobName *string `min:"1" type:"string"`

	// Specifies configuration properties of a job run notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The name of the SecurityConfiguration structure to be used with this action.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The JobRun timeout in minutes. This is the maximum time that a job run can
	// consume resources before it is terminated and enters TIMEOUT status. The
	// default is 2,880 minutes (48 hours). This overrides the timeout value set
	// in the parent job.
	Timeout *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Action"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}
	if s.NotificationProperty != nil {
		if err := s.NotificationProperty.Validate(); err != nil {
			invalidParams.AddNested("NotificationProperty", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Records an error that occurred when attempting to stop a specified job run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRunError
type BatchStopJobRunError struct {
	_ struct{} `type:"structure"`

	// Specifies details about the error that was encountered.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the job definition used in the job run in question.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the job run in question.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchStopJobRunError) String() string {
	return awsutil.Prettify(s)
}

// Records a successful request to stop a specified JobRun.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRunSuccessfulSubmission
type BatchStopJobRunSuccessfulSubmission struct {
	_ struct{} `type:"structure"`

	// The name of the job definition used in the job run that was stopped.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the job run that was stopped.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchStopJobRunSuccessfulSubmission) String() string {
	return awsutil.Prettify(s)
}

// Specifies a table definition in the AWS Glue Data Catalog.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CatalogEntry
type CatalogEntry struct {
	_ struct{} `type:"structure"`

	// The database in which the table metadata resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table in question.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CatalogEntry) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogEntry) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CatalogEntry"}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A structure containing migration status information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CatalogImportStatus
type CatalogImportStatus struct {
	_ struct{} `type:"structure"`

	// True if the migration has completed, or False otherwise.
	ImportCompleted *bool `type:"boolean"`

	// The time that the migration was started.
	ImportTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the person who initiated the migration.
	ImportedBy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CatalogImportStatus) String() string {
	return awsutil.Prettify(s)
}

// Specifies an AWS Glue Data Catalog target.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CatalogTarget
type CatalogTarget struct {
	_ struct{} `type:"structure"`

	// The name of the database to be synchronized.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of the tables to be synchronized.
	//
	// Tables is a required field
	Tables []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CatalogTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CatalogTarget"}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.Tables == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tables"))
	}
	if s.Tables != nil && len(s.Tables) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tables", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Classifiers are triggered during a crawl task. A classifier checks whether
// a given file is in a format it can handle. If it is, the classifier creates
// a schema in the form of a StructType object that matches that data format.
//
// You can use the standard classifiers that AWS Glue provides, or you can write
// your own classifiers to best categorize your data sources and specify the
// appropriate schemas to use for them. A classifier can be a grok classifier,
// an XML classifier, a JSON classifier, or a custom CSV classifier, as specified
// in one of the fields in the Classifier object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Classifier
type Classifier struct {
	_ struct{} `type:"structure"`

	// A classifier for comma-separated values (CSV).
	CsvClassifier *CsvClassifier `type:"structure"`

	// A classifier that uses grok.
	GrokClassifier *GrokClassifier `type:"structure"`

	// A classifier for JSON content.
	JsonClassifier *JsonClassifier `type:"structure"`

	// A classifier for XML content.
	XMLClassifier *XMLClassifier `type:"structure"`
}

// String returns the string representation
func (s Classifier) String() string {
	return awsutil.Prettify(s)
}

// Specifies how CloudWatch data should be encrypted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CloudWatchEncryption
type CloudWatchEncryption struct {
	_ struct{} `type:"structure"`

	// The encryption mode to use for CloudWatch data.
	CloudWatchEncryptionMode CloudWatchEncryptionMode `type:"string" enum:"true"`

	// The AWS ARN of the KMS key to be used to encrypt the data.
	KmsKeyArn *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchEncryption) String() string {
	return awsutil.Prettify(s)
}

// Represents a directional edge in a directed acyclic graph (DAG).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CodeGenEdge
type CodeGenEdge struct {
	_ struct{} `type:"structure"`

	// The ID of the node at which the edge starts.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`

	// The ID of the node at which the edge ends.
	//
	// Target is a required field
	Target *string `min:"1" type:"string" required:"true"`

	// The target of the edge.
	TargetParameter *string `type:"string"`
}

// String returns the string representation
func (s CodeGenEdge) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenEdge) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeGenEdge"}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Source", 1))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a node in a directed acyclic graph (DAG)
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CodeGenNode
type CodeGenNode struct {
	_ struct{} `type:"structure"`

	// Properties of the node, in the form of name-value pairs.
	//
	// Args is a required field
	Args []CodeGenNodeArg `type:"list" required:"true"`

	// A node identifier that is unique within the node's graph.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The line number of the node.
	LineNumber *int64 `type:"integer"`

	// The type of node that this is.
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CodeGenNode) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNode) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeGenNode"}

	if s.Args == nil {
		invalidParams.Add(aws.NewErrParamRequired("Args"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.NodeType == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeType"))
	}
	if s.Args != nil {
		for i, v := range s.Args {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Args", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An argument or property of a node.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CodeGenNodeArg
type CodeGenNodeArg struct {
	_ struct{} `type:"structure"`

	// The name of the argument or property.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// True if the value is used as a parameter.
	Param *bool `type:"boolean"`

	// The value of the argument or property.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CodeGenNodeArg) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNodeArg) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeGenNodeArg"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A column in a Table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Column
type Column struct {
	_ struct{} `type:"structure"`

	// Free-form text comment.
	Comment *string `type:"string"`

	// The name of the Column.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The datatype of data in the Column.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Column) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Column) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Column"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a condition under which a trigger fires.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// The name of the Job to whose JobRuns this condition applies and on which
	// this trigger waits.
	JobName *string `min:"1" type:"string"`

	// A logical operator.
	LogicalOperator LogicalOperator `type:"string" enum:"true"`

	// The condition state. Currently, the values supported are SUCCEEDED, STOPPED,
	// TIMEOUT and FAILED.
	State JobRunState `type:"string" enum:"true"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Condition"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a connection to a data source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Connection
type Connection struct {
	_ struct{} `type:"structure"`

	// These key-value pairs define parameters for the connection:
	//
	//    * HOST - The host URI: either the fully qualified domain name (FQDN) or
	//    the IPv4 address of the database host.
	//
	//    * PORT - The port number, between 1024 and 65535, of the port on which
	//    the database host is listening for database connections.
	//
	//    * USER_NAME - The name under which to log in to the database. The value
	//    string for USER_NAME is "USERNAME".
	//
	//    * PASSWORD - A password, if one is used, for the user name.
	//
	//    * ENCRYPTED_PASSWORD - When you enable connection password protection
	//    by setting ConnectionPasswordEncryption in the Data Catalog encryption
	//    settings, this field stores the encrypted password.
	//
	//    * JDBC_DRIVER_JAR_URI - The Amazon S3 path of the JAR file that contains
	//    the JDBC driver to use.
	//
	//    * JDBC_DRIVER_CLASS_NAME - The class name of the JDBC driver to use.
	//
	//    * JDBC_ENGINE - The name of the JDBC engine to use.
	//
	//    * JDBC_ENGINE_VERSION - The version of the JDBC engine to use.
	//
	//    * CONFIG_FILES - (Reserved for future use).
	//
	//    * INSTANCE_ID - The instance ID to use.
	//
	//    * JDBC_CONNECTION_URL - The URL for the JDBC connection.
	//
	//    * JDBC_ENFORCE_SSL - A Boolean string (true, false) specifying whether
	//    Secure Sockets Layer (SSL) with hostname matching will be enforced for
	//    the JDBC connection on the client. The default is false.
	ConnectionProperties map[string]string `type:"map"`

	// The type of the connection. Currently, only JDBC is supported; SFTP is not
	// supported.
	ConnectionType ConnectionType `type:"string" enum:"true"`

	// The time that this connection definition was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the connection.
	Description *string `type:"string"`

	// The user, group, or role that last updated this connection definition.
	LastUpdatedBy *string `min:"1" type:"string"`

	// The last time that this connection definition was updated.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []string `type:"list"`

	// The name of the connection definition.
	Name *string `min:"1" type:"string"`

	// A map of physical connection requirements, such as virtual private cloud
	// (VPC) and SecurityGroup, that are needed to make this connection successfully.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// A structure that is used to specify a connection to create or update.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ConnectionInput
type ConnectionInput struct {
	_ struct{} `type:"structure"`

	// These key-value pairs define parameters for the connection.
	//
	// ConnectionProperties is a required field
	ConnectionProperties map[string]string `type:"map" required:"true"`

	// The type of the connection. Currently, only JDBC is supported; SFTP is not
	// supported.
	//
	// ConnectionType is a required field
	ConnectionType ConnectionType `type:"string" required:"true" enum:"true"`

	// The description of the connection.
	Description *string `type:"string"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []string `type:"list"`

	// The name of the connection.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A map of physical connection requirements, such as virtual private cloud
	// (VPC) and SecurityGroup, that are needed to successfully make this connection.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation
func (s ConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConnectionInput"}

	if s.ConnectionProperties == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionProperties"))
	}
	if len(s.ConnectionType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionType"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.PhysicalConnectionRequirements != nil {
		if err := s.PhysicalConnectionRequirements.Validate(); err != nil {
			invalidParams.AddNested("PhysicalConnectionRequirements", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The data structure used by the Data Catalog to encrypt the password as part
// of CreateConnection or UpdateConnection and store it in the ENCRYPTED_PASSWORD
// field in the connection properties. You can enable catalog encryption or
// only password encryption.
//
// When a CreationConnection request arrives containing a password, the Data
// Catalog first encrypts the password using your AWS KMS key. It then encrypts
// the whole connection object again if catalog encryption is also enabled.
//
// This encryption requires that you set AWS KMS key permissions to enable or
// restrict access on the password key according to your security requirements.
// For example, you might want only admin users to have decrypt permission on
// the password key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ConnectionPasswordEncryption
type ConnectionPasswordEncryption struct {
	_ struct{} `type:"structure"`

	// An AWS KMS key that is used to encrypt the connection password.
	//
	// If connection password protection is enabled, the caller of CreateConnection
	// and UpdateConnection needs at least kms:Encrypt permission on the specified
	// AWS KMS key, to encrypt passwords before storing them in the Data Catalog.
	//
	// You can set the decrypt permission to enable or restrict access on the password
	// key according to your security requirements.
	AwsKmsKeyId *string `min:"1" type:"string"`

	// When the ReturnConnectionPasswordEncrypted flag is set to "true", passwords
	// remain encrypted in the responses of GetConnection and GetConnections. This
	// encryption takes effect independently from catalog encryption.
	//
	// ReturnConnectionPasswordEncrypted is a required field
	ReturnConnectionPasswordEncrypted *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ConnectionPasswordEncryption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionPasswordEncryption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConnectionPasswordEncryption"}
	if s.AwsKmsKeyId != nil && len(*s.AwsKmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsKmsKeyId", 1))
	}

	if s.ReturnConnectionPasswordEncrypted == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReturnConnectionPasswordEncrypted"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the connections used by a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ConnectionsList
type ConnectionsList struct {
	_ struct{} `type:"structure"`

	// A list of connections used by the job.
	Connections []string `type:"list"`
}

// String returns the string representation
func (s ConnectionsList) String() string {
	return awsutil.Prettify(s)
}

// Specifies a crawler program that examines a data source and uses classifiers
// to try to determine its schema. If successful, the crawler records metadata
// concerning the data source in the AWS Glue Data Catalog.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Crawler
type Crawler struct {
	_ struct{} `type:"structure"`

	// A list of UTF-8 strings that specify the custom classifiers that are associated
	// with the crawler.
	Classifiers []string `type:"list"`

	// Crawler configuration information. This versioned JSON string allows users
	// to specify aspects of a crawler's behavior. For more information, see Configuring
	// a Crawler (http://docs.aws.amazon.com/glue/latest/dg/crawler-configuration.html).
	Configuration *string `type:"string"`

	// If the crawler is running, contains the total time elapsed since the last
	// crawl began.
	CrawlElapsedTime *int64 `type:"long"`

	// The name of the SecurityConfiguration structure to be used by this crawler.
	CrawlerSecurityConfiguration *string `type:"string"`

	// The time that the crawler was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the database in which the crawler's output is stored.
	DatabaseName *string `type:"string"`

	// A description of the crawler.
	Description *string `type:"string"`

	// The status of the last crawl, and potentially error information if an error
	// occurred.
	LastCrawl *LastCrawlInfo `type:"structure"`

	// The time that the crawler was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the crawler.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of an IAM role that's used to access customer
	// resources, such as Amazon Simple Storage Service (Amazon S3) data.
	Role *string `type:"string"`

	// For scheduled crawlers, the schedule when the crawler runs.
	Schedule *Schedule `type:"structure"`

	// The policy that specifies update and delete behaviors for the crawler.
	SchemaChangePolicy *SchemaChangePolicy `type:"structure"`

	// Indicates whether the crawler is running, or whether a run is pending.
	State CrawlerState `type:"string" enum:"true"`

	// The prefix added to the names of tables that are created.
	TablePrefix *string `type:"string"`

	// A collection of targets to crawl.
	Targets *CrawlerTargets `type:"structure"`

	// The version of the crawler.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s Crawler) String() string {
	return awsutil.Prettify(s)
}

// Metrics for a specified crawler.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CrawlerMetrics
type CrawlerMetrics struct {
	_ struct{} `type:"structure"`

	// The name of the crawler.
	CrawlerName *string `min:"1" type:"string"`

	// The duration of the crawler's most recent run, in seconds.
	LastRuntimeSeconds *float64 `type:"double"`

	// The median duration of this crawler's runs, in seconds.
	MedianRuntimeSeconds *float64 `type:"double"`

	// True if the crawler is still estimating how long it will take to complete
	// this run.
	StillEstimating *bool `type:"boolean"`

	// The number of tables created by this crawler.
	TablesCreated *int64 `type:"integer"`

	// The number of tables deleted by this crawler.
	TablesDeleted *int64 `type:"integer"`

	// The number of tables updated by this crawler.
	TablesUpdated *int64 `type:"integer"`

	// The estimated time left to complete a running crawl.
	TimeLeftSeconds *float64 `type:"double"`
}

// String returns the string representation
func (s CrawlerMetrics) String() string {
	return awsutil.Prettify(s)
}

// Specifies data stores to crawl.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CrawlerTargets
type CrawlerTargets struct {
	_ struct{} `type:"structure"`

	// Specifies AWS Glue Data Catalog targets.
	CatalogTargets []CatalogTarget `type:"list"`

	// Specifies Amazon DynamoDB targets.
	DynamoDBTargets []DynamoDBTarget `type:"list"`

	// Specifies JDBC targets.
	JdbcTargets []JdbcTarget `type:"list"`

	// Specifies Amazon Simple Storage Service (Amazon S3) targets.
	S3Targets []S3Target `type:"list"`
}

// String returns the string representation
func (s CrawlerTargets) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrawlerTargets) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CrawlerTargets"}
	if s.CatalogTargets != nil {
		for i, v := range s.CatalogTargets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CatalogTargets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a custom CSV classifier for CreateClassifier to create.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCsvClassifierRequest
type CreateCsvClassifierRequest struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption `type:"string" enum:"true"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []string `type:"list"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// Must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateCsvClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCsvClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCsvClassifierRequest"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Delimiter", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.QuoteSymbol != nil && len(*s.QuoteSymbol) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QuoteSymbol", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a grok classifier for CreateClassifier to create.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateGrokClassifierRequest
type CreateGrokClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string `type:"string"`

	// The grok pattern used by this classifier.
	//
	// GrokPattern is a required field
	GrokPattern *string `min:"1" type:"string" required:"true"`

	// The name of the new classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGrokClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGrokClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGrokClassifierRequest"}

	if s.Classification == nil {
		invalidParams.Add(aws.NewErrParamRequired("Classification"))
	}

	if s.GrokPattern == nil {
		invalidParams.Add(aws.NewErrParamRequired("GrokPattern"))
	}
	if s.GrokPattern != nil && len(*s.GrokPattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GrokPattern", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a JSON classifier for CreateClassifier to create.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJsonClassifierRequest
type CreateJsonClassifierRequest struct {
	_ struct{} `type:"structure"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// JsonPath is a required field
	JsonPath *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateJsonClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJsonClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateJsonClassifierRequest"}

	if s.JsonPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("JsonPath"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an XML classifier for CreateClassifier to create.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateXMLClassifierRequest
type CreateXMLClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This can't identify a self-closing element (closed by />).
	// An empty row element that contains only attributes can be parsed as long
	// as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`
}

// String returns the string representation
func (s CreateXMLClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateXMLClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateXMLClassifierRequest"}

	if s.Classification == nil {
		invalidParams.Add(aws.NewErrParamRequired("Classification"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A classifier for custom CSV content.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CsvClassifier
type CsvClassifier struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption `type:"string" enum:"true"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []string `type:"list"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// It must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s CsvClassifier) String() string {
	return awsutil.Prettify(s)
}

// Contains configuration information for maintaining Data Catalog security.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DataCatalogEncryptionSettings
type DataCatalogEncryptionSettings struct {
	_ struct{} `type:"structure"`

	// When connection password protection is enabled, the Data Catalog uses a customer-provided
	// key to encrypt the password as part of CreateConnection or UpdateConnection
	// and store it in the ENCRYPTED_PASSWORD field in the connection properties.
	// You can enable catalog encryption or only password encryption.
	ConnectionPasswordEncryption *ConnectionPasswordEncryption `type:"structure"`

	// Specifies the encryption-at-rest configuration for the Data Catalog.
	EncryptionAtRest *EncryptionAtRest `type:"structure"`
}

// String returns the string representation
func (s DataCatalogEncryptionSettings) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataCatalogEncryptionSettings) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DataCatalogEncryptionSettings"}
	if s.ConnectionPasswordEncryption != nil {
		if err := s.ConnectionPasswordEncryption.Validate(); err != nil {
			invalidParams.AddNested("ConnectionPasswordEncryption", err.(aws.ErrInvalidParams))
		}
	}
	if s.EncryptionAtRest != nil {
		if err := s.EncryptionAtRest.Validate(); err != nil {
			invalidParams.AddNested("EncryptionAtRest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Database object represents a logical grouping of tables that may reside
// in a Hive metastore or an RDBMS.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Database
type Database struct {
	_ struct{} `type:"structure"`

	// The time at which the metadata database was created in the catalog.
	CreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Description of the database.
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// Name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// These key-value pairs define parameters and properties of the database.
	Parameters map[string]string `type:"map"`
}

// String returns the string representation
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// The structure used to create or update a database.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DatabaseInput
type DatabaseInput struct {
	_ struct{} `type:"structure"`

	// Description of the database
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// Name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Thes key-value pairs define parameters and properties of the database.
	Parameters map[string]string `type:"map"`
}

// String returns the string representation
func (s DatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatabaseInput"}
	if s.LocationUri != nil && len(*s.LocationUri) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LocationUri", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A development endpoint where a developer can remotely debug ETL scripts.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DevEndpoint
type DevEndpoint struct {
	_ struct{} `type:"structure"`

	// A map of arguments used to configure the DevEndpoint.
	//
	// Note that currently, we only support "--enable-glue-datacatalog": "" as a
	// valid argument.
	Arguments map[string]string `type:"map"`

	// The AWS availability zone where this DevEndpoint is located.
	AvailabilityZone *string `type:"string"`

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the DevEndpoint.
	EndpointName *string `type:"string"`

	// Path to one or more Java Jars in an S3 bucket that should be loaded in your
	// DevEndpoint.
	//
	// Please note that only pure Java/Scala libraries can currently be used on
	// a DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that should be loaded
	// in your DevEndpoint. Multiple values must be complete paths separated by
	// a comma.
	//
	// Please note that only pure Python libraries can currently be used on a DevEndpoint.
	// Libraries that rely on C extensions, such as the pandas (http://pandas.pydata.org/)
	// Python data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string `type:"string"`

	// The point in time at which this DevEndpoint was last modified.
	LastModifiedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of the last update.
	LastUpdateStatus *string `type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// A private IP address to access the DevEndpoint within a VPC, if the DevEndpoint
	// is created within one. The PrivateAddress field is present only when you
	// create the DevEndpoint within your virtual private cloud (VPC).
	PrivateAddress *string `type:"string"`

	// The public IP address used by this DevEndpoint. The PublicAddress field is
	// present only when you create a non-VPC (virtual private cloud) DevEndpoint.
	PublicAddress *string `type:"string"`

	// The public key to be used by this DevEndpoint for authentication. This attribute
	// is provided for backward compatibility, as the recommended attribute to use
	// is public keys.
	PublicKey *string `type:"string"`

	// A list of public keys to be used by the DevEndpoints for authentication.
	// The use of this attribute is preferred over a single public key because the
	// public keys allow you to have a different private key per client.
	//
	// If you previously created an endpoint with a public key, you must remove
	// that key to be able to set a list of public keys: call the UpdateDevEndpoint
	// API with the public key content in the deletePublicKeys attribute, and the
	// list of new keys in the addPublicKeys attribute.
	PublicKeys []string `type:"list"`

	// The AWS ARN of the IAM role used in this DevEndpoint.
	RoleArn *string `type:"string"`

	// The name of the SecurityConfiguration structure to be used with this DevEndpoint.
	SecurityConfiguration *string `min:"1" type:"string"`

	// A list of security group identifiers used in this DevEndpoint.
	SecurityGroupIds []string `type:"list"`

	// The current status of this DevEndpoint.
	Status *string `type:"string"`

	// The subnet ID for this DevEndpoint.
	SubnetId *string `type:"string"`

	// The ID of the virtual private cloud (VPC) used by this DevEndpoint.
	VpcId *string `type:"string"`

	// The YARN endpoint address used by this DevEndpoint.
	YarnEndpointAddress *string `type:"string"`

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort *int64 `type:"integer"`
}

// String returns the string representation
func (s DevEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Custom libraries to be loaded into a DevEndpoint.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DevEndpointCustomLibraries
type DevEndpointCustomLibraries struct {
	_ struct{} `type:"structure"`

	// Path to one or more Java Jars in an S3 bucket that should be loaded in your
	// DevEndpoint.
	//
	// Please note that only pure Java/Scala libraries can currently be used on
	// a DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that should be loaded
	// in your DevEndpoint. Multiple values must be complete paths separated by
	// a comma.
	//
	// Please note that only pure Python libraries can currently be used on a DevEndpoint.
	// Libraries that rely on C extensions, such as the pandas (http://pandas.pydata.org/)
	// Python data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`
}

// String returns the string representation
func (s DevEndpointCustomLibraries) String() string {
	return awsutil.Prettify(s)
}

// Specifies an Amazon DynamoDB table to crawl.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DynamoDBTarget
type DynamoDBTarget struct {
	_ struct{} `type:"structure"`

	// The name of the DynamoDB table to crawl.
	Path *string `type:"string"`
}

// String returns the string representation
func (s DynamoDBTarget) String() string {
	return awsutil.Prettify(s)
}

// Specifies the encryption-at-rest configuration for the Data Catalog.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/EncryptionAtRest
type EncryptionAtRest struct {
	_ struct{} `type:"structure"`

	// The encryption-at-rest mode for encrypting Data Catalog data.
	//
	// CatalogEncryptionMode is a required field
	CatalogEncryptionMode CatalogEncryptionMode `type:"string" required:"true" enum:"true"`

	// The ID of the AWS KMS key to use for encryption at rest.
	SseAwsKmsKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptionAtRest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionAtRest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptionAtRest"}
	if len(s.CatalogEncryptionMode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CatalogEncryptionMode"))
	}
	if s.SseAwsKmsKeyId != nil && len(*s.SseAwsKmsKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SseAwsKmsKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an encryption configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/EncryptionConfiguration
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption configuration for CloudWatch.
	CloudWatchEncryption *CloudWatchEncryption `type:"structure"`

	// The encryption configuration for Job Bookmarks.
	JobBookmarksEncryption *JobBookmarksEncryption `type:"structure"`

	// The encryption configuration for S3 data.
	S3Encryption []S3Encryption `type:"list"`
}

// String returns the string representation
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Contains details about an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ErrorDetail
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The code associated with this error.
	ErrorCode *string `min:"1" type:"string"`

	// A message describing the error.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// An execution property of a job.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ExecutionProperty
type ExecutionProperty struct {
	_ struct{} `type:"structure"`

	// The maximum number of concurrent runs allowed for the job. The default is
	// 1. An error is returned when this threshold is reached. The maximum value
	// you can specify is controlled by a service limit.
	MaxConcurrentRuns *int64 `type:"integer"`
}

// String returns the string representation
func (s ExecutionProperty) String() string {
	return awsutil.Prettify(s)
}

// Filters the connection definitions that are returned by the GetConnections
// API operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnectionsFilter
type GetConnectionsFilter struct {
	_ struct{} `type:"structure"`

	// The type of connections to return. Currently, only JDBC is supported; SFTP
	// is not supported.
	ConnectionType ConnectionType `type:"string" enum:"true"`

	// A criteria string that must match the criteria recorded in the connection
	// definition for that connection definition to be returned.
	MatchCriteria []string `type:"list"`
}

// String returns the string representation
func (s GetConnectionsFilter) String() string {
	return awsutil.Prettify(s)
}

// A classifier that uses grok patterns.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GrokClassifier
type GrokClassifier struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, and so on.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Optional custom grok patterns defined by this classifier. For more information,
	// see custom patterns in Writing Custom Classifiers (http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	CustomPatterns *string `type:"string"`

	// The grok pattern applied to a data store by this classifier. For more information,
	// see built-in patterns in Writing Custom Classifiers (http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	//
	// GrokPattern is a required field
	GrokPattern *string `min:"1" type:"string" required:"true"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s GrokClassifier) String() string {
	return awsutil.Prettify(s)
}

// Specifies a JDBC data store to crawl.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JdbcTarget
type JdbcTarget struct {
	_ struct{} `type:"structure"`

	// The name of the connection to use to connect to the JDBC target.
	ConnectionName *string `type:"string"`

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler (http://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []string `type:"list"`

	// The path of the JDBC target.
	Path *string `type:"string"`
}

// String returns the string representation
func (s JdbcTarget) String() string {
	return awsutil.Prettify(s)
}

// Specifies a job definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Job
type Job struct {
	_ struct{} `type:"structure"`

	// This field is deprecated, use MaxCapacity instead.
	//
	// The number of AWS Glue data processing units (DPUs) allocated to runs of
	// this job. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is
	// a relative measure of processing power that consists of 4 vCPUs of compute
	// capacity and 16 GB of memory. For more information, see the AWS Glue pricing
	// page (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The JobCommand that executes this job.
	Command *JobCommand `type:"structure"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The time and date that this job definition was created.
	CreatedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The default arguments for this job, specified as name-value pairs.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]string `type:"map"`

	// Description of the job being defined.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// The last point in time when this job definition was modified.
	LastModifiedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when this job runs. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
	// see the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a python shell job, or an Apache Spark ETL job:
	//
	//    * When you specify a python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"),
	//    you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job
	//    type cannot have a fractional DPU allocation.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry this job after a JobRun fails.
	MaxRetries *int64 `type:"integer"`

	// The name you assign to this job definition.
	Name *string `min:"1" type:"string"`

	// Specifies configuration properties of a job notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The name or ARN of the IAM role associated with this job.
	Role *string `type:"string"`

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// Defines a point which a job can resume processing.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JobBookmarkEntry
type JobBookmarkEntry struct {
	_ struct{} `type:"structure"`

	// The attempt ID number.
	Attempt *int64 `type:"integer"`

	// The bookmark itself.
	JobBookmark *string `type:"string"`

	// Name of the job in question.
	JobName *string `type:"string"`

	// The run ID number.
	Run *int64 `type:"integer"`

	// Version of the job.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s JobBookmarkEntry) String() string {
	return awsutil.Prettify(s)
}

// Specifies how Job bookmark data should be encrypted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JobBookmarksEncryption
type JobBookmarksEncryption struct {
	_ struct{} `type:"structure"`

	// The encryption mode to use for Job bookmarks data.
	JobBookmarksEncryptionMode JobBookmarksEncryptionMode `type:"string" enum:"true"`

	// The AWS ARN of the KMS key to be used to encrypt the data.
	KmsKeyArn *string `type:"string"`
}

// String returns the string representation
func (s JobBookmarksEncryption) String() string {
	return awsutil.Prettify(s)
}

// Specifies code executed when a job is run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JobCommand
type JobCommand struct {
	_ struct{} `type:"structure"`

	// The name of the job command: this must be glueetl, for an Apache Spark ETL
	// job, or pythonshell, for a Python shell job.
	Name *string `type:"string"`

	// Specifies the S3 path to a script that executes a job (required).
	ScriptLocation *string `type:"string"`
}

// String returns the string representation
func (s JobCommand) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a job run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JobRun
type JobRun struct {
	_ struct{} `type:"structure"`

	// This field is deprecated, use MaxCapacity instead.
	//
	// The number of AWS Glue data processing units (DPUs) allocated to this JobRun.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The job arguments associated with this run. For this job run, they replace
	// the default arguments set in the job definition itself.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]string `type:"map"`

	// The number of the attempt to run this job.
	Attempt *int64 `type:"integer"`

	// The date and time this job run completed.
	CompletedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An error message associated with this job run.
	ErrorMessage *string `type:"string"`

	// The amount of time (in seconds) that the job run consumed resources.
	ExecutionTime *int64 `type:"integer"`

	// The ID of this job run.
	Id *string `min:"1" type:"string"`

	// The name of the job definition being used in this run.
	JobName *string `min:"1" type:"string"`

	// The current state of the job run.
	JobRunState JobRunState `type:"string" enum:"true"`

	// The last time this job run was modified.
	LastModifiedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the log group for secure logging, that can be server-side encrypted
	// in CloudWatch using KMS. This name can be /aws-glue/jobs/, in which case
	// the default encryption is NONE. If you add a role name and SecurityConfiguration
	// name (in other words, /aws-glue/jobs-yourRoleName-yourSecurityConfigurationName/),
	// then that security configuration will be used to encrypt the log group.
	LogGroupName *string `type:"string"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when this job runs. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
	// see the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a python shell job, or an Apache Spark ETL job:
	//
	//    * When you specify a python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"),
	//    you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job
	//    type cannot have a fractional DPU allocation.
	MaxCapacity *float64 `type:"double"`

	// Specifies configuration properties of a job run notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// A list of predecessors to this job run.
	PredecessorRuns []Predecessor `type:"list"`

	// The ID of the previous run of this job. For example, the JobRunId specified
	// in the StartJobRun action.
	PreviousRunId *string `min:"1" type:"string"`

	// The name of the SecurityConfiguration structure to be used with this job
	// run.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The date and time at which this job run was started.
	StartedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The JobRun timeout in minutes. This is the maximum time that a job run can
	// consume resources before it is terminated and enters TIMEOUT status. The
	// default is 2,880 minutes (48 hours). This overrides the timeout value set
	// in the parent job.
	Timeout *int64 `min:"1" type:"integer"`

	// The name of the trigger that started this job run.
	TriggerName *string `min:"1" type:"string"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s JobRun) String() string {
	return awsutil.Prettify(s)
}

// Specifies information used to update an existing job definition. Note that
// the previous job definition will be completely overwritten by this information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JobUpdate
type JobUpdate struct {
	_ struct{} `type:"structure"`

	// This field is deprecated. Use MaxCapacity instead.
	//
	// The number of AWS Glue data processing units (DPUs) to allocate to this Job.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `deprecated:"true" type:"integer"`

	// The JobCommand that executes this job (required).
	Command *JobCommand `type:"structure"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The default arguments for this job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]string `type:"map"`

	// Description of the job being defined.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The number of AWS Glue data processing units (DPUs) that can be allocated
	// when this job runs. A DPU is a relative measure of processing power that
	// consists of 4 vCPUs of compute capacity and 16 GB of memory. For more information,
	// see the AWS Glue pricing page (https://aws.amazon.com/glue/pricing/).
	//
	// Do not set Max Capacity if using WorkerType and NumberOfWorkers.
	//
	// The value that can be allocated for MaxCapacity depends on whether you are
	// running a python shell job, or an Apache Spark ETL job:
	//
	//    * When you specify a python shell job (JobCommand.Name="pythonshell"),
	//    you can allocate either 0.0625 or 1 DPU. The default is 0.0625 DPU.
	//
	//    * When you specify an Apache Spark ETL job (JobCommand.Name="glueetl"),
	//    you can allocate from 2 to 100 DPUs. The default is 10 DPUs. This job
	//    type cannot have a fractional DPU allocation.
	MaxCapacity *float64 `type:"double"`

	// The maximum number of times to retry this job if it fails.
	MaxRetries *int64 `type:"integer"`

	// Specifies configuration properties of a job notification.
	NotificationProperty *NotificationProperty `type:"structure"`

	// The number of workers of a defined workerType that are allocated when a job
	// runs.
	//
	// The maximum number of workers you can define are 299 for G.1X, and 149 for
	// G.2X.
	NumberOfWorkers *int64 `type:"integer"`

	// The name or ARN of the IAM role associated with this job (required).
	Role *string `type:"string"`

	// The name of the SecurityConfiguration structure to be used with this job.
	SecurityConfiguration *string `min:"1" type:"string"`

	// The job timeout in minutes. This is the maximum time that a job run can consume
	// resources before it is terminated and enters TIMEOUT status. The default
	// is 2,880 minutes (48 hours).
	Timeout *int64 `min:"1" type:"integer"`

	// The type of predefined worker that is allocated when a job runs. Accepts
	// a value of Standard, G.1X, or G.2X.
	//
	//    * For the Standard worker type, each worker provides 4 vCPU, 16 GB of
	//    memory and a 50GB disk, and 2 executors per worker.
	//
	//    * For the G.1X worker type, each worker provides 4 vCPU, 16 GB of memory
	//    and a 64GB disk, and 1 executor per worker.
	//
	//    * For the G.2X worker type, each worker provides 8 vCPU, 32 GB of memory
	//    and a 128GB disk, and 1 executor per worker.
	WorkerType WorkerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s JobUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JobUpdate"}
	if s.SecurityConfiguration != nil && len(*s.SecurityConfiguration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityConfiguration", 1))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Timeout", 1))
	}
	if s.NotificationProperty != nil {
		if err := s.NotificationProperty.Validate(); err != nil {
			invalidParams.AddNested("NotificationProperty", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A classifier for JSON content.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/JsonClassifier
type JsonClassifier struct {
	_ struct{} `type:"structure"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// JsonPath is a required field
	JsonPath *string `type:"string" required:"true"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s JsonClassifier) String() string {
	return awsutil.Prettify(s)
}

// Status and error information about the most recent crawl.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/LastCrawlInfo
type LastCrawlInfo struct {
	_ struct{} `type:"structure"`

	// If an error occurred, the error information about the last crawl.
	ErrorMessage *string `type:"string"`

	// The log group for the last crawl.
	LogGroup *string `min:"1" type:"string"`

	// The log stream for the last crawl.
	LogStream *string `min:"1" type:"string"`

	// The prefix for a message about this crawl.
	MessagePrefix *string `min:"1" type:"string"`

	// The time at which the crawl started.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Status of the last crawl.
	Status LastCrawlStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s LastCrawlInfo) String() string {
	return awsutil.Prettify(s)
}

// The location of resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Location
type Location struct {
	_ struct{} `type:"structure"`

	// An Amazon DynamoDB table location.
	DynamoDB []CodeGenNodeArg `type:"list"`

	// A JDBC location.
	Jdbc []CodeGenNodeArg `type:"list"`

	// An Amazon Simple Storage Service (Amazon S3) location.
	S3 []CodeGenNodeArg `type:"list"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Location"}
	if s.DynamoDB != nil {
		for i, v := range s.DynamoDB {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DynamoDB", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Jdbc != nil {
		for i, v := range s.Jdbc {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Jdbc", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.S3 != nil {
		for i, v := range s.S3 {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Defines a mapping.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/MappingEntry
type MappingEntry struct {
	_ struct{} `type:"structure"`

	// The source path.
	SourcePath *string `type:"string"`

	// The name of the source table.
	SourceTable *string `type:"string"`

	// The source type.
	SourceType *string `type:"string"`

	// The target path.
	TargetPath *string `type:"string"`

	// The target table.
	TargetTable *string `type:"string"`

	// The target type.
	TargetType *string `type:"string"`
}

// String returns the string representation
func (s MappingEntry) String() string {
	return awsutil.Prettify(s)
}

// Specifies configuration properties of a notification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/NotificationProperty
type NotificationProperty struct {
	_ struct{} `type:"structure"`

	// After a job run starts, the number of minutes to wait before sending a job
	// run delay notification.
	NotifyDelayAfter *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s NotificationProperty) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationProperty) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NotificationProperty"}
	if s.NotifyDelayAfter != nil && *s.NotifyDelayAfter < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NotifyDelayAfter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the sort order of a sorted column.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Order
type Order struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	//
	// Column is a required field
	Column *string `min:"1" type:"string" required:"true"`

	// Indicates that the column is sorted in ascending order (== 1), or in descending
	// order (==0).
	//
	// SortOrder is a required field
	SortOrder *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Order) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Order) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Order"}

	if s.Column == nil {
		invalidParams.Add(aws.NewErrParamRequired("Column"))
	}
	if s.Column != nil && len(*s.Column) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Column", 1))
	}

	if s.SortOrder == nil {
		invalidParams.Add(aws.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a slice of table data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Partition
type Partition struct {
	_ struct{} `type:"structure"`

	// The time at which the partition was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the catalog database where the table in question is located.
	DatabaseName *string `min:"1" type:"string"`

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// These key-value pairs define partition parameters.
	Parameters map[string]string `type:"map"`

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The name of the table in question.
	TableName *string `min:"1" type:"string"`

	// The values of the partition.
	Values []string `type:"list"`
}

// String returns the string representation
func (s Partition) String() string {
	return awsutil.Prettify(s)
}

// Contains information about a partition error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PartitionError
type PartitionError struct {
	_ struct{} `type:"structure"`

	// Details about the partition error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The values that define the partition.
	PartitionValues []string `type:"list"`
}

// String returns the string representation
func (s PartitionError) String() string {
	return awsutil.Prettify(s)
}

// The structure used to create and update a partion.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PartitionInput
type PartitionInput struct {
	_ struct{} `type:"structure"`

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// These key-value pairs define partition parameters.
	Parameters map[string]string `type:"map"`

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The values of the partition. Although this parameter is not required by the
	// SDK, you must specify this parameter for a valid input.
	Values []string `type:"list"`
}

// String returns the string representation
func (s PartitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PartitionInput"}
	if s.StorageDescriptor != nil {
		if err := s.StorageDescriptor.Validate(); err != nil {
			invalidParams.AddNested("StorageDescriptor", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains a list of values defining partitions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PartitionValueList
type PartitionValueList struct {
	_ struct{} `type:"structure"`

	// The list of values.
	//
	// Values is a required field
	Values []string `type:"list" required:"true"`
}

// String returns the string representation
func (s PartitionValueList) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionValueList) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PartitionValueList"}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the physical requirements for a connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/PhysicalConnectionRequirements
type PhysicalConnectionRequirements struct {
	_ struct{} `type:"structure"`

	// The connection's Availability Zone. This field is redundant because the specified
	// subnet implies the Availability Zone to be used. Currently the field must
	// be populated, but it will be deprecated in the future.
	AvailabilityZone *string `min:"1" type:"string"`

	// The security group ID list used by the connection.
	SecurityGroupIdList []string `type:"list"`

	// The subnet ID used by the connection.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PhysicalConnectionRequirements) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhysicalConnectionRequirements) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PhysicalConnectionRequirements"}
	if s.AvailabilityZone != nil && len(*s.AvailabilityZone) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AvailabilityZone", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A job run that was used in the predicate of a conditional trigger that triggered
// this job run.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Predecessor
type Predecessor struct {
	_ struct{} `type:"structure"`

	// The name of the job definition used by the predecessor job run.
	JobName *string `min:"1" type:"string"`

	// The job-run ID of the predecessor job run.
	RunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Predecessor) String() string {
	return awsutil.Prettify(s)
}

// Defines the predicate of the trigger, which determines when it fires.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Predicate
type Predicate struct {
	_ struct{} `type:"structure"`

	// A list of the conditions that determine when the trigger will fire.
	Conditions []Condition `type:"list"`

	// Optional field if only one condition is listed. If multiple conditions are
	// listed, then this field is required.
	Logical Logical `type:"string" enum:"true"`
}

// String returns the string representation
func (s Predicate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Predicate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Predicate"}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// URIs for function resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResourceUri
type ResourceUri struct {
	_ struct{} `type:"structure"`

	// The type of the resource.
	ResourceType ResourceType `type:"string" enum:"true"`

	// The URI for accessing the resource.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceUri) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceUri) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceUri"}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies how S3 data should be encrypted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/S3Encryption
type S3Encryption struct {
	_ struct{} `type:"structure"`

	// The AWS ARN of the KMS key to be used to encrypt the data.
	KmsKeyArn *string `type:"string"`

	// The encryption mode to use for S3 data.
	S3EncryptionMode S3EncryptionMode `type:"string" enum:"true"`
}

// String returns the string representation
func (s S3Encryption) String() string {
	return awsutil.Prettify(s)
}

// Specifies a data store in Amazon Simple Storage Service (Amazon S3).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/S3Target
type S3Target struct {
	_ struct{} `type:"structure"`

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler (http://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []string `type:"list"`

	// The path to the Amazon S3 target.
	Path *string `type:"string"`
}

// String returns the string representation
func (s S3Target) String() string {
	return awsutil.Prettify(s)
}

// A scheduling object using a cron statement to schedule an event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Schedule
type Schedule struct {
	_ struct{} `type:"structure"`

	// A cron expression used to specify the schedule. For more information, see
	// Time-Based Schedules for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, specify cron(15 12
	// * * ? *).
	ScheduleExpression *string `type:"string"`

	// The state of the schedule.
	State ScheduleState `type:"string" enum:"true"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// A policy that specifies update and deletion behaviors for the crawler.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SchemaChangePolicy
type SchemaChangePolicy struct {
	_ struct{} `type:"structure"`

	// The deletion behavior when the crawler finds a deleted object.
	DeleteBehavior DeleteBehavior `type:"string" enum:"true"`

	// The update behavior when the crawler finds a changed schema.
	UpdateBehavior UpdateBehavior `type:"string" enum:"true"`
}

// String returns the string representation
func (s SchemaChangePolicy) String() string {
	return awsutil.Prettify(s)
}

// Specifies a security configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SecurityConfiguration
type SecurityConfiguration struct {
	_ struct{} `type:"structure"`

	// The time at which this security configuration was created.
	CreatedTimeStamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The encryption configuration associated with this security configuration.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// The name of the security configuration.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SecurityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Defines a non-overlapping region of a table's partitions, allowing multiple
// requests to be executed in parallel.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Segment
type Segment struct {
	_ struct{} `type:"structure"`

	// The zero-based index number of the this segment. For example, if the total
	// number of segments is 4, SegmentNumber values will range from zero through
	// three.
	//
	// SegmentNumber is a required field
	SegmentNumber *int64 `type:"integer" required:"true"`

	// The total numer of segments.
	//
	// TotalSegments is a required field
	TotalSegments *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Segment) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Segment"}

	if s.SegmentNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("SegmentNumber"))
	}

	if s.TotalSegments == nil {
		invalidParams.Add(aws.NewErrParamRequired("TotalSegments"))
	}
	if s.TotalSegments != nil && *s.TotalSegments < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("TotalSegments", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a serialization/deserialization program (SerDe) which serves
// as an extractor and loader.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SerDeInfo
type SerDeInfo struct {
	_ struct{} `type:"structure"`

	// Name of the SerDe.
	Name *string `min:"1" type:"string"`

	// These key-value pairs define initialization parameters for the SerDe.
	Parameters map[string]string `type:"map"`

	// Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
	SerializationLibrary *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SerDeInfo) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SerDeInfo) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SerDeInfo"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.SerializationLibrary != nil && len(*s.SerializationLibrary) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SerializationLibrary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies skewed values in a table. Skewed are ones that occur with very
// high frequency.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/SkewedInfo
type SkewedInfo struct {
	_ struct{} `type:"structure"`

	// A list of names of columns that contain skewed values.
	SkewedColumnNames []string `type:"list"`

	// A mapping of skewed values to the columns that contain them.
	SkewedColumnValueLocationMaps map[string]string `type:"map"`

	// A list of values that appear so frequently as to be considered skewed.
	SkewedColumnValues []string `type:"list"`
}

// String returns the string representation
func (s SkewedInfo) String() string {
	return awsutil.Prettify(s)
}

// Describes the physical storage of table data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StorageDescriptor
type StorageDescriptor struct {
	_ struct{} `type:"structure"`

	// A list of reducer grouping columns, clustering columns, and bucketing columns
	// in the table.
	BucketColumns []string `type:"list"`

	// A list of the Columns in the table.
	Columns []Column `type:"list"`

	// True if the data in the table is compressed, or False if not.
	Compressed *bool `type:"boolean"`

	// The input format: SequenceFileInputFormat (binary), or TextInputFormat, or
	// a custom format.
	InputFormat *string `type:"string"`

	// The physical location of the table. By default this takes the form of the
	// warehouse location, followed by the database location in the warehouse, followed
	// by the table name.
	Location *string `type:"string"`

	// Must be specified if the table contains any dimension columns.
	NumberOfBuckets *int64 `type:"integer"`

	// The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat,
	// or a custom format.
	OutputFormat *string `type:"string"`

	// User-supplied properties in key-value form.
	Parameters map[string]string `type:"map"`

	// Serialization/deserialization (SerDe) information.
	SerdeInfo *SerDeInfo `type:"structure"`

	// Information about values that appear very frequently in a column (skewed
	// values).
	SkewedInfo *SkewedInfo `type:"structure"`

	// A list specifying the sort order of each bucket in the table.
	SortColumns []Order `type:"list"`

	// True if the table data is stored in subdirectories, or False if not.
	StoredAsSubDirectories *bool `type:"boolean"`
}

// String returns the string representation
func (s StorageDescriptor) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageDescriptor) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StorageDescriptor"}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SerdeInfo != nil {
		if err := s.SerdeInfo.Validate(); err != nil {
			invalidParams.AddNested("SerdeInfo", err.(aws.ErrInvalidParams))
		}
	}
	if s.SortColumns != nil {
		for i, v := range s.SortColumns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortColumns", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a collection of related data organized in columns and rows.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Table
type Table struct {
	_ struct{} `type:"structure"`

	// Time when the table definition was created in the Data Catalog.
	CreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Person or entity who created the table.
	CreatedBy *string `min:"1" type:"string"`

	// Name of the metadata database where the table metadata resides. For Hive
	// compatibility, this must be all lowercase.
	DatabaseName *string `min:"1" type:"string"`

	// Description of the table.
	Description *string `type:"string"`

	// Last time the table was accessed. This is usually taken from HDFS, and may
	// not be reliable.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Last time column statistics were computed for this table.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Name of the table. For Hive compatibility, this must be entirely lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Owner of the table.
	Owner *string `min:"1" type:"string"`

	// These key-value pairs define properties associated with the table.
	Parameters map[string]string `type:"map"`

	// A list of columns by which the table is partitioned. Only primitive types
	// are supported as partition keys.
	//
	// When creating a table used by Athena, and you do not specify any partitionKeys,
	// you must at least set the value of partitionKeys to an empty list. For example:
	//
	// "PartitionKeys": []
	PartitionKeys []Column `type:"list"`

	// Retention time for this table.
	Retention *int64 `type:"integer"`

	// A storage descriptor containing information about the physical storage of
	// this table.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string `type:"string"`

	// Last time the table was updated.
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string `type:"string"`

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string `type:"string"`
}

// String returns the string representation
func (s Table) String() string {
	return awsutil.Prettify(s)
}

// An error record for table operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TableError
type TableError struct {
	_ struct{} `type:"structure"`

	// Detail about the error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// Name of the table. For Hive compatibility, this must be entirely lowercase.
	TableName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableError) String() string {
	return awsutil.Prettify(s)
}

// Structure used to create or update the table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TableInput
type TableInput struct {
	_ struct{} `type:"structure"`

	// Description of the table.
	Description *string `type:"string"`

	// Last time the table was accessed.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Last time column statistics were computed for this table.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Name of the table. For Hive compatibility, this is folded to lowercase when
	// it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Owner of the table.
	Owner *string `min:"1" type:"string"`

	// These key-value pairs define properties associated with the table.
	Parameters map[string]string `type:"map"`

	// A list of columns by which the table is partitioned. Only primitive types
	// are supported as partition keys.
	//
	// When creating a table used by Athena, and you do not specify any partitionKeys,
	// you must at least set the value of partitionKeys to an empty list. For example:
	//
	// "PartitionKeys": []
	PartitionKeys []Column `type:"list"`

	// Retention time for this table.
	Retention *int64 `type:"integer"`

	// A storage descriptor containing information about the physical storage of
	// this table.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string `type:"string"`

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string `type:"string"`

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string `type:"string"`
}

// String returns the string representation
func (s TableInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TableInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Owner != nil && len(*s.Owner) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Owner", 1))
	}
	if s.PartitionKeys != nil {
		for i, v := range s.PartitionKeys {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionKeys", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.StorageDescriptor != nil {
		if err := s.StorageDescriptor.Validate(); err != nil {
			invalidParams.AddNested("StorageDescriptor", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a version of a table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TableVersion
type TableVersion struct {
	_ struct{} `type:"structure"`

	// The table in question
	Table *Table `type:"structure"`

	// The ID value that identifies this table version. A VersionId is a string
	// representation of an integer. Each version is incremented by 1.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableVersion) String() string {
	return awsutil.Prettify(s)
}

// An error record for table-version operations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TableVersionError
type TableVersionError struct {
	_ struct{} `type:"structure"`

	// Detail about the error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the table in question.
	TableName *string `min:"1" type:"string"`

	// The ID value of the version in question. A VersionID is a string representation
	// of an integer. Each version is incremented by 1.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableVersionError) String() string {
	return awsutil.Prettify(s)
}

// Information about a specific trigger.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/Trigger
type Trigger struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger.
	Actions []Action `type:"list"`

	// A description of this trigger.
	Description *string `type:"string"`

	// Reserved for future use.
	Id *string `min:"1" type:"string"`

	// Name of the trigger.
	Name *string `min:"1" type:"string"`

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`

	// The current state of the trigger.
	State TriggerState `type:"string" enum:"true"`

	// The type of trigger that this is.
	Type TriggerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Trigger) String() string {
	return awsutil.Prettify(s)
}

// A structure used to provide information used to update a trigger. This object
// will update the the previous trigger definition by overwriting it completely.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TriggerUpdate
type TriggerUpdate struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger.
	Actions []Action `type:"list"`

	// A description of this trigger.
	Description *string `type:"string"`

	// Reserved for future use.
	Name *string `min:"1" type:"string"`

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`
}

// String returns the string representation
func (s TriggerUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TriggerUpdate"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Predicate != nil {
		if err := s.Predicate.Validate(); err != nil {
			invalidParams.AddNested("Predicate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a custom CSV classifier to be updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCsvClassifierRequest
type UpdateCsvClassifierRequest struct {
	_ struct{} `type:"structure"`

	// Enables the processing of files that contain only one column.
	AllowSingleColumn *bool `type:"boolean"`

	// Indicates whether the CSV file contains a header.
	ContainsHeader CsvHeaderOption `type:"string" enum:"true"`

	// A custom symbol to denote what separates each column entry in the row.
	Delimiter *string `min:"1" type:"string"`

	// Specifies not to trim values before identifying the type of column values.
	// The default value is true.
	DisableValueTrimming *bool `type:"boolean"`

	// A list of strings representing column names.
	Header []string `type:"list"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A custom symbol to denote what combines content into a single column value.
	// It must be different from the column delimiter.
	QuoteSymbol *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateCsvClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCsvClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCsvClassifierRequest"}
	if s.Delimiter != nil && len(*s.Delimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Delimiter", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.QuoteSymbol != nil && len(*s.QuoteSymbol) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("QuoteSymbol", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a grok classifier to update when passed to UpdateClassifier.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateGrokClassifierRequest
type UpdateGrokClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	Classification *string `type:"string"`

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string `type:"string"`

	// The grok pattern used by this classifier.
	GrokPattern *string `min:"1" type:"string"`

	// The name of the GrokClassifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGrokClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGrokClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGrokClassifierRequest"}
	if s.GrokPattern != nil && len(*s.GrokPattern) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GrokPattern", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies a JSON classifier to be updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJsonClassifierRequest
type UpdateJsonClassifierRequest struct {
	_ struct{} `type:"structure"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	JsonPath *string `type:"string"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateJsonClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJsonClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateJsonClassifierRequest"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies an XML classifier to be updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateXMLClassifierRequest
type UpdateXMLClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	Classification *string `type:"string"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This cannot identify a self-closing element (closed by />).
	// An empty row element that contains only attributes can be parsed as long
	// as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`
}

// String returns the string representation
func (s UpdateXMLClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateXMLClassifierRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateXMLClassifierRequest"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the equivalent of a Hive user-defined function (UDF) definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UserDefinedFunction
type UserDefinedFunction struct {
	_ struct{} `type:"structure"`

	// The Java class that contains the function code.
	ClassName *string `min:"1" type:"string"`

	// The time at which the function was created.
	CreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The owner of the function.
	OwnerName *string `min:"1" type:"string"`

	// The owner type.
	OwnerType PrincipalType `type:"string" enum:"true"`

	// The resource URIs for the function.
	ResourceUris []ResourceUri `type:"list"`
}

// String returns the string representation
func (s UserDefinedFunction) String() string {
	return awsutil.Prettify(s)
}

// A structure used to create or updata a user-defined function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UserDefinedFunctionInput
type UserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Java class that contains the function code.
	ClassName *string `min:"1" type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The owner of the function.
	OwnerName *string `min:"1" type:"string"`

	// The owner type.
	OwnerType PrincipalType `type:"string" enum:"true"`

	// The resource URIs for the function.
	ResourceUris []ResourceUri `type:"list"`
}

// String returns the string representation
func (s UserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserDefinedFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UserDefinedFunctionInput"}
	if s.ClassName != nil && len(*s.ClassName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClassName", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionName", 1))
	}
	if s.OwnerName != nil && len(*s.OwnerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OwnerName", 1))
	}
	if s.ResourceUris != nil {
		for i, v := range s.ResourceUris {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceUris", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A classifier for XML content.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/XMLClassifier
type XMLClassifier struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The time that this classifier was registered.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time that this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. This can't identify a self-closing element (closed by />).
	// An empty row element that contains only attributes can be parsed as long
	// as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s XMLClassifier) String() string {
	return awsutil.Prettify(s)
}
