// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Represents the input for CreateStream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStreamInput
type CreateStreamInput struct {
	_ struct{} `type:"structure"`

	// The number of shards that the stream will use. The throughput of the stream
	// is a function of the number of shards; more shards are required for greater
	// provisioned throughput.
	//
	// DefaultShardLimit;
	//
	// ShardCount is a required field
	ShardCount *int64 `min:"1" type:"integer" required:"true"`

	// A name to identify the stream. The stream name is scoped to the AWS account
	// used by the application that creates the stream. It is also scoped by AWS
	// Region. That is, two streams in two different AWS accounts can have the same
	// name. Two streams in the same AWS account but in two different Regions can
	// also have the same name.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateStreamInput"}

	if s.ShardCount == nil {
		invalidParams.Add(aws.NewErrParamRequired("ShardCount"))
	}
	if s.ShardCount != nil && *s.ShardCount < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ShardCount", 1))
	}

	if s.StreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStreamOutput
type CreateStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateStream = "CreateStream"

// CreateStreamRequest returns a request value for making API operation for
// Amazon Kinesis.
//
// Creates a Kinesis data stream. A stream captures and transports data records
// that are continuously emitted from different data sources or producers. Scale-out
// within a stream is explicitly supported by means of shards, which are uniquely
// identified groups of data records in a stream.
//
// You specify and control the number of shards that a stream is composed of.
// Each shard can support reads up to five transactions per second, up to a
// maximum data read total of 2 MB per second. Each shard can support writes
// up to 1,000 records per second, up to a maximum data write total of 1 MB
// per second. If the amount of data input increases or decreases, you can add
// or remove shards.
//
// The stream name identifies the stream. The name is scoped to the AWS account
// used by the application. It is also scoped by AWS Region. That is, two streams
// in two different accounts can have the same name, and two streams in the
// same account, but in two different Regions, can have the same name.
//
// CreateStream is an asynchronous operation. Upon receiving a CreateStream
// request, Kinesis Data Streams immediately returns and sets the stream status
// to CREATING. After the stream is created, Kinesis Data Streams sets the stream
// status to ACTIVE. You should perform read and write operations only on an
// ACTIVE stream.
//
// You receive a LimitExceededException when making a CreateStream request when
// you try to do one of the following:
//
//    * Have more than five streams in the CREATING state at any point in time.
//
//    * Create more shards than are authorized for your account.
//
// For the default shard limit for an AWS account, see Amazon Kinesis Data Streams
// Limits (http://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html)
// in the Amazon Kinesis Data Streams Developer Guide. To increase this limit,
// contact AWS Support (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html).
//
// You can use DescribeStream to check the stream status, which is returned
// in StreamStatus.
//
// CreateStream has a limit of five transactions per second per account.
//
//    // Example sending a request using CreateStreamRequest.
//    req := client.CreateStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream
func (c *Client) CreateStreamRequest(input *CreateStreamInput) CreateStreamRequest {
	op := &aws.Operation{
		Name:       opCreateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStreamInput{}
	}

	req := c.newRequest(op, input, &CreateStreamOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return CreateStreamRequest{Request: req, Input: input, Copy: c.CreateStreamRequest}
}

// CreateStreamRequest is the request type for the
// CreateStream API operation.
type CreateStreamRequest struct {
	*aws.Request
	Input *CreateStreamInput
	Copy  func(*CreateStreamInput) CreateStreamRequest
}

// Send marshals and sends the CreateStream API request.
func (r CreateStreamRequest) Send(ctx context.Context) (*CreateStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateStreamResponse{
		CreateStreamOutput: r.Request.Data.(*CreateStreamOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateStreamResponse is the response type for the
// CreateStream API operation.
type CreateStreamResponse struct {
	*CreateStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateStream request.
func (r *CreateStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
