// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurationsRequest
type ListLicenseConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// One or more filters.
	Filters []Filter `type:"list"`

	// An array of ARNs for the calling account’s license configurations.
	LicenseConfigurationArns []string `type:"list"`

	// Maximum number of results to return in a single call. To retrieve the remaining
	// results, make another call with the returned NextToken value.
	MaxResults *int64 `type:"integer"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLicenseConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurationsResponse
type ListLicenseConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// Array of license configuration objects.
	LicenseConfigurations []LicenseConfiguration `type:"list"`

	// Token for the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLicenseConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListLicenseConfigurations = "ListLicenseConfigurations"

// ListLicenseConfigurationsRequest returns a request value for making API operation for
// AWS License Manager.
//
// Lists license configuration objects for an account, each containing the name,
// description, license type, and other license terms modeled from a license
// agreement.
//
//    // Example sending a request using ListLicenseConfigurationsRequest.
//    req := client.ListLicenseConfigurationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/ListLicenseConfigurations
func (c *Client) ListLicenseConfigurationsRequest(input *ListLicenseConfigurationsInput) ListLicenseConfigurationsRequest {
	op := &aws.Operation{
		Name:       opListLicenseConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLicenseConfigurationsInput{}
	}

	req := c.newRequest(op, input, &ListLicenseConfigurationsOutput{})
	return ListLicenseConfigurationsRequest{Request: req, Input: input, Copy: c.ListLicenseConfigurationsRequest}
}

// ListLicenseConfigurationsRequest is the request type for the
// ListLicenseConfigurations API operation.
type ListLicenseConfigurationsRequest struct {
	*aws.Request
	Input *ListLicenseConfigurationsInput
	Copy  func(*ListLicenseConfigurationsInput) ListLicenseConfigurationsRequest
}

// Send marshals and sends the ListLicenseConfigurations API request.
func (r ListLicenseConfigurationsRequest) Send(ctx context.Context) (*ListLicenseConfigurationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLicenseConfigurationsResponse{
		ListLicenseConfigurationsOutput: r.Request.Data.(*ListLicenseConfigurationsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListLicenseConfigurationsResponse is the response type for the
// ListLicenseConfigurations API operation.
type ListLicenseConfigurationsResponse struct {
	*ListLicenseConfigurationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLicenseConfigurations request.
func (r *ListLicenseConfigurationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
