// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package macie

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccountsRequest
type ListMemberAccountsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to indicate the maximum number of items that you want
	// in the response. The default value is 250.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// Use this parameter when paginating results. Set the value of this parameter
	// to null on your first call to the ListMemberAccounts action. Subsequent calls
	// to the action fill nextToken in the request with the value of nextToken from
	// the previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMemberAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccountsResult
type ListMemberAccountsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the Amazon Macie member accounts returned by the action. The current
	// master account is also included in this list.
	MemberAccounts []MemberAccount `locationName:"memberAccounts" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to null.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMemberAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListMemberAccounts = "ListMemberAccounts"

// ListMemberAccountsRequest returns a request value for making API operation for
// Amazon Macie.
//
// Lists all Amazon Macie member accounts for the current Amazon Macie master
// account.
//
//    // Example sending a request using ListMemberAccountsRequest.
//    req := client.ListMemberAccountsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/macie-2017-12-19/ListMemberAccounts
func (c *Client) ListMemberAccountsRequest(input *ListMemberAccountsInput) ListMemberAccountsRequest {
	op := &aws.Operation{
		Name:       opListMemberAccounts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMemberAccountsInput{}
	}

	req := c.newRequest(op, input, &ListMemberAccountsOutput{})
	return ListMemberAccountsRequest{Request: req, Input: input, Copy: c.ListMemberAccountsRequest}
}

// ListMemberAccountsRequest is the request type for the
// ListMemberAccounts API operation.
type ListMemberAccountsRequest struct {
	*aws.Request
	Input *ListMemberAccountsInput
	Copy  func(*ListMemberAccountsInput) ListMemberAccountsRequest
}

// Send marshals and sends the ListMemberAccounts API request.
func (r ListMemberAccountsRequest) Send(ctx context.Context) (*ListMemberAccountsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMemberAccountsResponse{
		ListMemberAccountsOutput: r.Request.Data.(*ListMemberAccountsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListMemberAccountsRequestPaginator returns a paginator for ListMemberAccounts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListMemberAccountsRequest(input)
//   p := macie.NewListMemberAccountsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListMemberAccountsPaginator(req ListMemberAccountsRequest) ListMemberAccountsPaginator {
	return ListMemberAccountsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListMemberAccountsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListMemberAccountsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMemberAccountsPaginator struct {
	aws.Pager
}

func (p *ListMemberAccountsPaginator) CurrentPage() *ListMemberAccountsOutput {
	return p.Pager.CurrentPage().(*ListMemberAccountsOutput)
}

// ListMemberAccountsResponse is the response type for the
// ListMemberAccounts API operation.
type ListMemberAccountsResponse struct {
	*ListMemberAccountsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMemberAccounts request.
func (r *ListMemberAccountsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
