// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package marketplaceentitlementservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The GetEntitlementsRequest contains parameters for the GetEntitlements operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlementsRequest
type GetEntitlementsInput struct {
	_ struct{} `type:"structure"`

	// Filter is used to return entitlements for a specific customer or for a specific
	// dimension. Filters are described as keys mapped to a lists of values. Filtered
	// requests are unioned for each value in the value list, and then intersected
	// for each filter key.
	Filter map[string][]string `type:"map"`

	// The maximum number of items to retrieve from the GetEntitlements operation.
	// For pagination, use the NextToken field in subsequent calls to GetEntitlements.
	MaxResults *int64 `type:"integer"`

	// For paginated calls to GetEntitlements, pass the NextToken from the previous
	// GetEntitlementsResult.
	NextToken *string `type:"string"`

	// Product code is used to uniquely identify a product in AWS Marketplace. The
	// product code will be provided by AWS Marketplace when the product listing
	// is created.
	//
	// ProductCode is a required field
	ProductCode *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEntitlementsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEntitlementsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetEntitlementsInput"}

	if s.ProductCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductCode"))
	}
	if s.ProductCode != nil && len(*s.ProductCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The GetEntitlementsRequest contains results from the GetEntitlements operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlementsResult
type GetEntitlementsOutput struct {
	_ struct{} `type:"structure"`

	// The set of entitlements found through the GetEntitlements operation. If the
	// result contains an empty set of entitlements, NextToken might still be present
	// and should be used.
	Entitlements []Entitlement `type:"list"`

	// For paginated results, use NextToken in subsequent calls to GetEntitlements.
	// If the result contains an empty set of entitlements, NextToken might still
	// be present and should be used.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetEntitlementsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetEntitlements = "GetEntitlements"

// GetEntitlementsRequest returns a request value for making API operation for
// AWS Marketplace Entitlement Service.
//
// GetEntitlements retrieves entitlement values for a given product. The results
// can be filtered based on customer identifier or product dimensions.
//
//    // Example sending a request using GetEntitlementsRequest.
//    req := client.GetEntitlementsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/entitlement.marketplace-2017-01-11/GetEntitlements
func (c *Client) GetEntitlementsRequest(input *GetEntitlementsInput) GetEntitlementsRequest {
	op := &aws.Operation{
		Name:       opGetEntitlements,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEntitlementsInput{}
	}

	req := c.newRequest(op, input, &GetEntitlementsOutput{})
	return GetEntitlementsRequest{Request: req, Input: input, Copy: c.GetEntitlementsRequest}
}

// GetEntitlementsRequest is the request type for the
// GetEntitlements API operation.
type GetEntitlementsRequest struct {
	*aws.Request
	Input *GetEntitlementsInput
	Copy  func(*GetEntitlementsInput) GetEntitlementsRequest
}

// Send marshals and sends the GetEntitlements API request.
func (r GetEntitlementsRequest) Send(ctx context.Context) (*GetEntitlementsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEntitlementsResponse{
		GetEntitlementsOutput: r.Request.Data.(*GetEntitlementsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEntitlementsResponse is the response type for the
// GetEntitlements API operation.
type GetEntitlementsResponse struct {
	*GetEntitlementsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEntitlements request.
func (r *GetEntitlementsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
