// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutLifecyclePolicyInput
type PutLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container that you want to assign the object lifecycle policy
	// to.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`

	// The object lifecycle policy to apply to the container.
	//
	// LifecyclePolicy is a required field
	LifecyclePolicy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLifecyclePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutLifecyclePolicyInput"}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerName", 1))
	}

	if s.LifecyclePolicy == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifecyclePolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutLifecyclePolicyOutput
type PutLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutLifecyclePolicy = "PutLifecyclePolicy"

// PutLifecyclePolicyRequest returns a request value for making API operation for
// AWS Elemental MediaStore.
//
// Writes an object lifecycle policy to a container. If the container already
// has an object lifecycle policy, the service replaces the existing policy
// with the new policy. It takes up to 20 minutes for the change to take effect.
//
// For information about how to construct an object lifecycle policy, see Components
// of an Object Lifecycle Policy (https://docs.aws.amazon.com/mediastore/latest/ug/policies-object-lifecycle-components.html).
//
//    // Example sending a request using PutLifecyclePolicyRequest.
//    req := client.PutLifecyclePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/PutLifecyclePolicy
func (c *Client) PutLifecyclePolicyRequest(input *PutLifecyclePolicyInput) PutLifecyclePolicyRequest {
	op := &aws.Operation{
		Name:       opPutLifecyclePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLifecyclePolicyInput{}
	}

	req := c.newRequest(op, input, &PutLifecyclePolicyOutput{})
	return PutLifecyclePolicyRequest{Request: req, Input: input, Copy: c.PutLifecyclePolicyRequest}
}

// PutLifecyclePolicyRequest is the request type for the
// PutLifecyclePolicy API operation.
type PutLifecyclePolicyRequest struct {
	*aws.Request
	Input *PutLifecyclePolicyInput
	Copy  func(*PutLifecyclePolicyInput) PutLifecyclePolicyRequest
}

// Send marshals and sends the PutLifecyclePolicy API request.
func (r PutLifecyclePolicyRequest) Send(ctx context.Context) (*PutLifecyclePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutLifecyclePolicyResponse{
		PutLifecyclePolicyOutput: r.Request.Data.(*PutLifecyclePolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutLifecyclePolicyResponse is the response type for the
// PutLifecyclePolicy API operation.
type PutLifecyclePolicyResponse struct {
	*PutLifecyclePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutLifecyclePolicy request.
func (r *PutLifecyclePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
