// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateElasticIpRequest
type UpdateElasticIpInput struct {
	_ struct{} `type:"structure"`

	// The IP address for which you want to update the name.
	//
	// ElasticIp is a required field
	ElasticIp *string `type:"string" required:"true"`

	// The new name.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateElasticIpInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateElasticIpInput"}

	if s.ElasticIp == nil {
		invalidParams.Add(aws.NewErrParamRequired("ElasticIp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateElasticIpOutput
type UpdateElasticIpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateElasticIp = "UpdateElasticIp"

// UpdateElasticIpRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Updates a registered Elastic IP address's name. For more information, see
// Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using UpdateElasticIpRequest.
//    req := client.UpdateElasticIpRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateElasticIp
func (c *Client) UpdateElasticIpRequest(input *UpdateElasticIpInput) UpdateElasticIpRequest {
	op := &aws.Operation{
		Name:       opUpdateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateElasticIpInput{}
	}

	req := c.newRequest(op, input, &UpdateElasticIpOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateElasticIpRequest{Request: req, Input: input, Copy: c.UpdateElasticIpRequest}
}

// UpdateElasticIpRequest is the request type for the
// UpdateElasticIp API operation.
type UpdateElasticIpRequest struct {
	*aws.Request
	Input *UpdateElasticIpInput
	Copy  func(*UpdateElasticIpInput) UpdateElasticIpRequest
}

// Send marshals and sends the UpdateElasticIp API request.
func (r UpdateElasticIpRequest) Send(ctx context.Context) (*UpdateElasticIpResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateElasticIpResponse{
		UpdateElasticIpOutput: r.Request.Data.(*UpdateElasticIpOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateElasticIpResponse is the response type for the
// UpdateElasticIp API operation.
type UpdateElasticIpResponse struct {
	*UpdateElasticIpOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateElasticIp request.
func (r *UpdateElasticIpResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
