// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroups

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResourcesInput
type SearchResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of group member ARNs returned by SearchResources in paginated
	// output. By default, this number is 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value that is returned in a paginated SearchResources request.
	// To get the next page of results, run the call again, add the NextToken parameter,
	// and specify the NextToken value.
	NextToken *string `type:"string"`

	// The search query, using the same formats that are supported for resource
	// group definition.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s SearchResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ResourceQuery == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceQuery"))
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchResourcesInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceQuery != nil {
		v := s.ResourceQuery

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ResourceQuery", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResourcesOutput
type SearchResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a subsequent SearchResources request, to
	// get more results.
	NextToken *string `type:"string"`

	// A list of QueryError objects. Each error is an object that contains ErrorCode
	// and Message structures. Possible values for ErrorCode are CLOUDFORMATION_STACK_INACTIVE
	// and CLOUDFORMATION_STACK_NOT_EXISTING.
	QueryErrors []QueryError `type:"list"`

	// The ARNs and resource types of resources that are members of the group that
	// you specified.
	ResourceIdentifiers []ResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s SearchResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchResourcesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.QueryErrors) > 0 {
		v := s.QueryErrors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "QueryErrors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceIdentifiers) > 0 {
		v := s.ResourceIdentifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceIdentifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opSearchResources = "SearchResources"

// SearchResourcesRequest returns a request value for making API operation for
// AWS Resource Groups.
//
// Returns a list of AWS resource identifiers that matches a specified query.
// The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery
// operation.
//
//    // Example sending a request using SearchResourcesRequest.
//    req := client.SearchResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources
func (c *Client) SearchResourcesRequest(input *SearchResourcesInput) SearchResourcesRequest {
	op := &aws.Operation{
		Name:       opSearchResources,
		HTTPMethod: "POST",
		HTTPPath:   "/resources/search",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchResourcesInput{}
	}

	req := c.newRequest(op, input, &SearchResourcesOutput{})
	return SearchResourcesRequest{Request: req, Input: input, Copy: c.SearchResourcesRequest}
}

// SearchResourcesRequest is the request type for the
// SearchResources API operation.
type SearchResourcesRequest struct {
	*aws.Request
	Input *SearchResourcesInput
	Copy  func(*SearchResourcesInput) SearchResourcesRequest
}

// Send marshals and sends the SearchResources API request.
func (r SearchResourcesRequest) Send(ctx context.Context) (*SearchResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchResourcesResponse{
		SearchResourcesOutput: r.Request.Data.(*SearchResourcesOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchResourcesRequestPaginator returns a paginator for SearchResources.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchResourcesRequest(input)
//   p := resourcegroups.NewSearchResourcesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchResourcesPaginator(req SearchResourcesRequest) SearchResourcesPaginator {
	return SearchResourcesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchResourcesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchResourcesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchResourcesPaginator struct {
	aws.Pager
}

func (p *SearchResourcesPaginator) CurrentPage() *SearchResourcesOutput {
	return p.Pager.CurrentPage().(*SearchResourcesOutput)
}

// SearchResourcesResponse is the response type for the
// SearchResources API operation.
type SearchResourcesResponse struct {
	*SearchResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchResources request.
func (r *SearchResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
