// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AccountLimit
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// The limit that you requested. Valid values include the following:
	//
	//    * MAX_HEALTH_CHECKS_BY_OWNER: The maximum number of health checks that
	//    you can create using the current account.
	//
	//    * MAX_HOSTED_ZONES_BY_OWNER: The maximum number of hosted zones that you
	//    can create using the current account.
	//
	//    * MAX_REUSABLE_DELEGATION_SETS_BY_OWNER: The maximum number of reusable
	//    delegation sets that you can create using the current account.
	//
	//    * MAX_TRAFFIC_POLICIES_BY_OWNER: The maximum number of traffic policies
	//    that you can create using the current account.
	//
	//    * MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER: The maximum number of traffic
	//    policy instances that you can create using the current account. (Traffic
	//    policy instances are referred to as traffic flow policy records in the
	//    Amazon Route 53 console.)
	//
	// Type is a required field
	Type AccountLimitType `type:"string" required:"true" enum:"true"`

	// The current value for the limit that is specified by Type (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AccountLimit.html#Route53-Type-AccountLimit-Type).
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountLimit) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that identifies the CloudWatch alarm that you want Amazon
// Route 53 health checkers to use to determine whether the specified health
// check is healthy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AlarmIdentifier
type AlarmIdentifier struct {
	_ struct{} `type:"structure"`

	// The name of the CloudWatch alarm that you want Amazon Route 53 health checkers
	// to use to determine whether this health check is healthy.
	//
	// Route 53 supports CloudWatch alarms with the following features:
	//
	//    * Standard-resolution metrics. High-resolution metrics aren't supported.
	//    For more information, see High-Resolution Metrics (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics)
	//    in the Amazon CloudWatch User Guide.
	//
	//    * Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended
	//    statistics aren't supported.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// For the CloudWatch alarm that you want Route 53 health checkers to use to
	// determine whether this health check is healthy, the region that the alarm
	// was created in.
	//
	// For the current list of CloudWatch regions, see Amazon CloudWatch (http://docs.aws.amazon.com/general/latest/gr/rande.html#cw_region)
	// in the AWS Regions and Endpoints chapter of the Amazon Web Services General
	// Reference.
	//
	// Region is a required field
	Region CloudWatchRegion `min:"1" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s AlarmIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AlarmIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AlarmIdentifier"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Region) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Region"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AlarmIdentifier) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if len(s.Region) > 0 {
		v := s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Region", v, metadata)
	}
	return nil
}

// Alias resource record sets only: Information about the AWS resource, such
// as a CloudFront distribution or an Amazon S3 bucket, that you want to route
// traffic to.
//
// When creating resource record sets for a private hosted zone, note the following:
//
//    * Creating geolocation alias resource record sets or latency alias resource
//    record sets in a private hosted zone is unsupported.
//
//    * For information about creating failover resource record sets in a private
//    hosted zone, see Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/AliasTarget
type AliasTarget struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: The value that you specify depends on where
	// you want to route queries:
	//
	// Amazon API Gateway custom regional APIs and edge-optimized APIs
	//
	// Specify the applicable domain name for your API. You can get the applicable
	// value using the AWS CLI command get-domain-names (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html):
	//
	//    * For regional APIs, specify the value of regionalDomainName.
	//
	//    * For edge-optimized APIs, specify the value of distributionDomainName.
	//    This is the name of the associated CloudFront distribution, such as da1b2c3d4e5.cloudfront.net.
	//
	// The name of the record that you're creating must match a custom domain name
	// for your API, such as api.example.com.
	//
	// Amazon Virtual Private Cloud interface VPC endpoint
	//
	// Enter the API endpoint for the interface endpoint, such as vpce-123456789abcdef01-example-us-east-1a.elasticloadbalancing.us-east-1.vpce.amazonaws.com.
	// For edge-optimized APIs, this is the domain name for the corresponding CloudFront
	// distribution. You can get the value of DnsName using the AWS CLI command
	// describe-vpc-endpoints (https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html).
	//
	// CloudFront distribution
	//
	// Specify the domain name that CloudFront assigned when you created your distribution.
	//
	// Your CloudFront distribution must include an alternate domain name that matches
	// the name of the resource record set. For example, if the name of the resource
	// record set is acme.example.com, your CloudFront distribution must include
	// acme.example.com as one of the alternate domain names. For more information,
	// see Using Alternate Domain Names (CNAMEs) (http://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html)
	// in the Amazon CloudFront Developer Guide.
	//
	// You can't create a resource record set in a private hosted zone to route
	// traffic to a CloudFront distribution.
	//
	// For failover alias records, you can't specify a CloudFront distribution for
	// both the primary and secondary records. A distribution must include an alternate
	// domain name that matches the name of the record. However, the primary and
	// secondary records have the same name, and you can't include the same alternate
	// domain name in more than one distribution.
	//
	// Elastic Beanstalk environment
	//
	// If the domain name for your Elastic Beanstalk environment includes the region
	// that you deployed the environment in, you can create an alias record that
	// routes traffic to the environment. For example, the domain name my-environment.us-west-2.elasticbeanstalk.com
	// is a regionalized domain name.
	//
	// For environments that were created before early 2016, the domain name doesn't
	// include the region. To route traffic to these environments, you must create
	// a CNAME record instead of an alias record. Note that you can't create a CNAME
	// record for the root domain name. For example, if your domain name is example.com,
	// you can create a record that routes traffic for acme.example.com to your
	// Elastic Beanstalk environment, but you can't create a record that routes
	// traffic for example.com to your Elastic Beanstalk environment.
	//
	// For Elastic Beanstalk environments that have regionalized subdomains, specify
	// the CNAME attribute for the environment. You can use the following methods
	// to get the value of the CNAME attribute:
	//
	//    * AWS Management Console: For information about how to get the value by
	//    using the console, see Using Custom Domains with AWS Elastic Beanstalk
	//    (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html)
	//    in the AWS Elastic Beanstalk Developer Guide.
	//
	//    * Elastic Beanstalk API: Use the DescribeEnvironments action to get the
	//    value of the CNAME attribute. For more information, see DescribeEnvironments
	//    (http://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html)
	//    in the AWS Elastic Beanstalk API Reference.
	//
	//    * AWS CLI: Use the describe-environments command to get the value of the
	//    CNAME attribute. For more information, see describe-environments (http://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/describe-environments.html)
	//    in the AWS Command Line Interface Reference.
	//
	// ELB load balancer
	//
	// Specify the DNS name that is associated with the load balancer. Get the DNS
	// name by using the AWS Management Console, the ELB API, or the AWS CLI.
	//
	//    * AWS Management Console: Go to the EC2 page, choose Load Balancers in
	//    the navigation pane, choose the load balancer, choose the Description
	//    tab, and get the value of the DNS name field. If you're routing traffic
	//    to a Classic Load Balancer, get the value that begins with dualstack.
	//    If you're routing traffic to another type of load balancer, get the value
	//    that applies to the record type, A or AAAA.
	//
	//    * Elastic Load Balancing API: Use DescribeLoadBalancers to get the value
	//    of DNSName. For more information, see the applicable guide: Classic Load
	//    Balancers: DescribeLoadBalancers (http://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html)
	//    Application and Network Load Balancers: DescribeLoadBalancers (http://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	//
	//    * AWS CLI: Use describe-load-balancers to get the value of DNSName. For
	//    more information, see the applicable guide: Classic Load Balancers: describe-load-balancers
	//    (http://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html)
	//    Application and Network Load Balancers: describe-load-balancers (http://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html)
	//
	// Amazon S3 bucket that is configured as a static website
	//
	// Specify the domain name of the Amazon S3 website endpoint that you created
	// the bucket in, for example, s3-website.us-east-2.amazonaws.com. For more
	// information about valid values, see the table Amazon Simple Storage Service
	// (S3) Website Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// in the Amazon Web Services General Reference. For more information about
	// using S3 buckets for websites, see Getting Started with Amazon Route 53 (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Another Route 53 resource record set
	//
	// Specify the value of the Name element for a resource record set in the current
	// hosted zone.
	//
	// If you're creating an alias record that has the same name as the hosted zone
	// (known as the zone apex), you can't specify the domain name for a record
	// for which the value of Type is CNAME. This is because the alias record must
	// have the same type as the record that you're routing traffic to, and creating
	// a CNAME record for the zone apex isn't supported even for an alias record.
	//
	// DNSName is a required field
	DNSName *string `type:"string" required:"true"`

	// Applies only to alias, failover alias, geolocation alias, latency alias,
	// and weighted alias resource record sets: When EvaluateTargetHealth is true,
	// an alias resource record set inherits the health of the referenced AWS resource,
	// such as an ELB load balancer or another resource record set in the hosted
	// zone.
	//
	// Note the following:
	//
	// CloudFront distributions
	//
	// You can't set EvaluateTargetHealth to true when the alias target is a CloudFront
	// distribution.
	//
	// Elastic Beanstalk environments that have regionalized subdomains
	//
	// If you specify an Elastic Beanstalk environment in DNSName and the environment
	// contains an ELB load balancer, Elastic Load Balancing routes queries only
	// to the healthy Amazon EC2 instances that are registered with the load balancer.
	// (An environment automatically contains an ELB load balancer if it includes
	// more than one Amazon EC2 instance.) If you set EvaluateTargetHealth to true
	// and either no Amazon EC2 instances are healthy or the load balancer itself
	// is unhealthy, Route 53 routes queries to other available resources that are
	// healthy, if any.
	//
	// If the environment contains a single Amazon EC2 instance, there are no special
	// requirements.
	//
	// ELB load balancers
	//
	// Health checking behavior depends on the type of load balancer:
	//
	//    * Classic Load Balancers: If you specify an ELB Classic Load Balancer
	//    in DNSName, Elastic Load Balancing routes queries only to the healthy
	//    Amazon EC2 instances that are registered with the load balancer. If you
	//    set EvaluateTargetHealth to true and either no EC2 instances are healthy
	//    or the load balancer itself is unhealthy, Route 53 routes queries to other
	//    resources.
	//
	//    * Application and Network Load Balancers: If you specify an ELB Application
	//    or Network Load Balancer and you set EvaluateTargetHealth to true, Route
	//    53 routes queries to the load balancer based on the health of the target
	//    groups that are associated with the load balancer: For an Application
	//    or Network Load Balancer to be considered healthy, every target group
	//    that contains targets must contain at least one healthy target. If any
	//    target group contains only unhealthy targets, the load balancer is considered
	//    unhealthy, and Route 53 routes queries to other resources. A target group
	//    that has no registered targets is considered unhealthy.
	//
	// When you create a load balancer, you configure settings for Elastic Load
	// Balancing health checks; they're not Route 53 health checks, but they perform
	// a similar function. Do not create Route 53 health checks for the EC2 instances
	// that you register with an ELB load balancer.
	//
	// S3 buckets
	//
	// There are no special requirements for setting EvaluateTargetHealth to true
	// when the alias target is an S3 bucket.
	//
	// Other records in the same hosted zone
	//
	// If the AWS resource that you specify in DNSName is a record or a group of
	// records (for example, a group of weighted records) but is not another alias
	// record, we recommend that you associate a health check with all of the records
	// in the alias target. For more information, see What Happens When You Omit
	// Health Checks? (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting)
	// in the Amazon Route 53 Developer Guide.
	//
	// For more information and examples, see Amazon Route 53 Health Checks and
	// DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// EvaluateTargetHealth is a required field
	EvaluateTargetHealth *bool `type:"boolean" required:"true"`

	// Alias resource records sets only: The value used depends on where you want
	// to route traffic:
	//
	// Amazon API Gateway custom regional APIs and edge-optimized APIs
	//
	// Specify the hosted zone ID for your API. You can get the applicable value
	// using the AWS CLI command get-domain-names (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html):
	//
	//    * For regional APIs, specify the value of regionalHostedZoneId.
	//
	//    * For edge-optimized APIs, specify the value of distributionHostedZoneId.
	//
	// Amazon Virtual Private Cloud interface VPC endpoint
	//
	// Specify the hosted zone ID for your interface endpoint. You can get the value
	// of HostedZoneId using the AWS CLI command describe-vpc-endpoints (https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html).
	//
	// CloudFront distribution
	//
	// Specify Z2FDTNDATAQYW2.
	//
	// Alias resource record sets for CloudFront can't be created in a private zone.
	//
	// Elastic Beanstalk environment
	//
	// Specify the hosted zone ID for the region that you created the environment
	// in. The environment must have a regionalized subdomain. For a list of regions
	// and the corresponding hosted zone IDs, see AWS Elastic Beanstalk (http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region)
	// in the "AWS Regions and Endpoints" chapter of the Amazon Web Services General
	// Reference.
	//
	// ELB load balancer
	//
	// Specify the value of the hosted zone ID for the load balancer. Use the following
	// methods to get the hosted zone ID:
	//
	//    * Elastic Load Balancing (https://docs.aws.amazon.com/general/latest/gr/rande.html#elb_region)
	//    table in the "AWS Regions and Endpoints" chapter of the Amazon Web Services
	//    General Reference: Use the value that corresponds with the region that
	//    you created your load balancer in. Note that there are separate columns
	//    for Application and Classic Load Balancers and for Network Load Balancers.
	//
	//    * AWS Management Console: Go to the Amazon EC2 page, choose Load Balancers
	//    in the navigation pane, select the load balancer, and get the value of
	//    the Hosted zone field on the Description tab.
	//
	//    * Elastic Load Balancing API: Use DescribeLoadBalancers to get the applicable
	//    value. For more information, see the applicable guide: Classic Load Balancers:
	//    Use DescribeLoadBalancers (http://docs.aws.amazon.com/elasticloadbalancing/2012-06-01/APIReference/API_DescribeLoadBalancers.html)
	//    to get the value of CanonicalHostedZoneNameId. Application and Network
	//    Load Balancers: Use DescribeLoadBalancers (http://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	//    to get the value of CanonicalHostedZoneId.
	//
	//    * AWS CLI: Use describe-load-balancers to get the applicable value. For
	//    more information, see the applicable guide: Classic Load Balancers: Use
	//    describe-load-balancers (http://docs.aws.amazon.com/cli/latest/reference/elb/describe-load-balancers.html)
	//    to get the value of CanonicalHostedZoneNameId. Application and Network
	//    Load Balancers: Use describe-load-balancers (http://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html)
	//    to get the value of CanonicalHostedZoneId.
	//
	// An Amazon S3 bucket configured as a static website
	//
	// Specify the hosted zone ID for the region that you created the bucket in.
	// For more information about valid values, see the Amazon Simple Storage Service
	// Website Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region)
	// table in the "AWS Regions and Endpoints" chapter of the Amazon Web Services
	// General Reference.
	//
	// Another Route 53 resource record set in your hosted zone
	//
	// Specify the hosted zone ID of your hosted zone. (An alias resource record
	// set can't reference a resource record set in a different hosted zone.)
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AliasTarget) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AliasTarget) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AliasTarget"}

	if s.DNSName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DNSName"))
	}

	if s.EvaluateTargetHealth == nil {
		invalidParams.Add(aws.NewErrParamRequired("EvaluateTargetHealth"))
	}

	if s.HostedZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostedZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AliasTarget) MarshalFields(e protocol.FieldEncoder) error {
	if s.DNSName != nil {
		v := *s.DNSName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DNSName", protocol.StringValue(v), metadata)
	}
	if s.EvaluateTargetHealth != nil {
		v := *s.EvaluateTargetHealth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EvaluateTargetHealth", protocol.BoolValue(v), metadata)
	}
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostedZoneId", protocol.StringValue(v), metadata)
	}
	return nil
}

// The information for each resource record set that you want to change.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/Change
type Change struct {
	_ struct{} `type:"structure"`

	// The action to perform:
	//
	//    * CREATE: Creates a resource record set that has the specified values.
	//
	//    * DELETE: Deletes a existing resource record set. To delete the resource
	//    record set that is associated with a traffic policy instance, use DeleteTrafficPolicyInstance
	//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html).
	//    Amazon Route 53 will delete the resource record set automatically. If
	//    you delete the resource record set by using ChangeResourceRecordSets,
	//    Route 53 doesn't automatically delete the traffic policy instance, and
	//    you'll continue to be charged for it even though it's no longer in use.
	//
	//    * UPSERT: If a resource record set doesn't already exist, Route 53 creates
	//    it. If a resource record set does exist, Route 53 updates it with the
	//    values in the request.
	//
	// Action is a required field
	Action ChangeAction `type:"string" required:"true" enum:"true"`

	// Information about the resource record set to create, delete, or update.
	//
	// ResourceRecordSet is a required field
	ResourceRecordSet *ResourceRecordSet `type:"structure" required:"true"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Change) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Change"}
	if len(s.Action) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Action"))
	}

	if s.ResourceRecordSet == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceRecordSet"))
	}
	if s.ResourceRecordSet != nil {
		if err := s.ResourceRecordSet.Validate(); err != nil {
			invalidParams.AddNested("ResourceRecordSet", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Change) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Action) > 0 {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Action", v, metadata)
	}
	if s.ResourceRecordSet != nil {
		v := s.ResourceRecordSet

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ResourceRecordSet", v, metadata)
	}
	return nil
}

// The information for a change request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeBatch
type ChangeBatch struct {
	_ struct{} `type:"structure"`

	// Information about the changes to make to the record sets.
	//
	// Changes is a required field
	Changes []Change `locationNameList:"Change" min:"1" type:"list" required:"true"`

	// Optional: Any comments you want to include about a change batch request.
	Comment *string `type:"string"`
}

// String returns the string representation
func (s ChangeBatch) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangeBatch) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ChangeBatch"}

	if s.Changes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Changes"))
	}
	if s.Changes != nil && len(s.Changes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Changes", 1))
	}
	if s.Changes != nil {
		for i, v := range s.Changes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Changes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChangeBatch) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Changes) > 0 {
		v := s.Changes

		metadata := protocol.Metadata{ListLocationName: "Change"}
		ls0 := e.List(protocol.BodyTarget, "Changes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that describes change information about changes made to your
// hosted zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ChangeInfo
type ChangeInfo struct {
	_ struct{} `type:"structure"`

	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// This element contains an ID that you use when performing a GetChange (https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html)
	// action to get detailed information about the change.
	Comment *string `type:"string"`

	// The ID of the request.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The current state of the request. PENDING indicates that this request has
	// not yet been applied to all Amazon Route 53 DNS servers.
	//
	// Status is a required field
	Status ChangeStatus `type:"string" required:"true" enum:"true"`

	// The date and time that the change request was submitted in ISO 8601 format
	// (https://en.wikipedia.org/wiki/ISO_8601) and Coordinated Universal Time (UTC).
	// For example, the value 2017-03-27T17:48:16.751Z represents March 27, 2017
	// at 17:48:16.751 UTC.
	//
	// SubmittedAt is a required field
	SubmittedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ChangeInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChangeInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", v, metadata)
	}
	if s.SubmittedAt != nil {
		v := *s.SubmittedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubmittedAt", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	return nil
}

// A complex type that contains information about the CloudWatch alarm that
// Amazon Route 53 is monitoring for this health check.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/CloudWatchAlarmConfiguration
type CloudWatchAlarmConfiguration struct {
	_ struct{} `type:"structure"`

	// For the metric that the CloudWatch alarm is associated with, the arithmetic
	// operation that is used for the comparison.
	//
	// ComparisonOperator is a required field
	ComparisonOperator ComparisonOperator `type:"string" required:"true" enum:"true"`

	// For the metric that the CloudWatch alarm is associated with, a complex type
	// that contains information about the dimensions for the metric. For information,
	// see Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html)
	// in the Amazon CloudWatch User Guide.
	Dimensions []Dimension `locationNameList:"Dimension" type:"list"`

	// For the metric that the CloudWatch alarm is associated with, the number of
	// periods that the metric is compared to the threshold.
	//
	// EvaluationPeriods is a required field
	EvaluationPeriods *int64 `min:"1" type:"integer" required:"true"`

	// The name of the CloudWatch metric that the alarm is associated with.
	//
	// MetricName is a required field
	MetricName *string `min:"1" type:"string" required:"true"`

	// The namespace of the metric that the alarm is associated with. For more information,
	// see Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference (http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html)
	// in the Amazon CloudWatch User Guide.
	//
	// Namespace is a required field
	Namespace *string `min:"1" type:"string" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the duration
	// of one evaluation period in seconds.
	//
	// Period is a required field
	Period *int64 `min:"60" type:"integer" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the statistic
	// that is applied to the metric.
	//
	// Statistic is a required field
	Statistic Statistic `type:"string" required:"true" enum:"true"`

	// For the metric that the CloudWatch alarm is associated with, the value the
	// metric is compared with.
	//
	// Threshold is a required field
	Threshold *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s CloudWatchAlarmConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CloudWatchAlarmConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ComparisonOperator) > 0 {
		v := s.ComparisonOperator

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ComparisonOperator", v, metadata)
	}
	if len(s.Dimensions) > 0 {
		v := s.Dimensions

		metadata := protocol.Metadata{ListLocationName: "Dimension"}
		ls0 := e.List(protocol.BodyTarget, "Dimensions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.EvaluationPeriods != nil {
		v := *s.EvaluationPeriods

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EvaluationPeriods", protocol.Int64Value(v), metadata)
	}
	if s.MetricName != nil {
		v := *s.MetricName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MetricName", protocol.StringValue(v), metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Namespace", protocol.StringValue(v), metadata)
	}
	if s.Period != nil {
		v := *s.Period

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Period", protocol.Int64Value(v), metadata)
	}
	if len(s.Statistic) > 0 {
		v := s.Statistic

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Statistic", v, metadata)
	}
	if s.Threshold != nil {
		v := *s.Threshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Threshold", protocol.Float64Value(v), metadata)
	}
	return nil
}

// A complex type that lists the name servers in a delegation set, as well as
// the CallerReference and the ID for the delegation set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DelegationSet
type DelegationSet struct {
	_ struct{} `type:"structure"`

	// The value that you specified for CallerReference when you created the reusable
	// delegation set.
	CallerReference *string `min:"1" type:"string"`

	// The ID that Amazon Route 53 assigns to a reusable delegation set.
	Id *string `type:"string"`

	// A complex type that contains a list of the authoritative name servers for
	// a hosted zone or for a reusable delegation set.
	//
	// NameServers is a required field
	NameServers []string `locationNameList:"NameServer" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DelegationSet) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DelegationSet) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if len(s.NameServers) > 0 {
		v := s.NameServers

		metadata := protocol.Metadata{ListLocationName: "NameServer"}
		ls0 := e.List(protocol.BodyTarget, "NameServers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	return nil
}

// For the metric that the CloudWatch alarm is associated with, a complex type
// that contains information about one dimension.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/Dimension
type Dimension struct {
	_ struct{} `type:"structure"`

	// For the metric that the CloudWatch alarm is associated with, the name of
	// one dimension.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// For the metric that the CloudWatch alarm is associated with, the value of
	// one dimension.
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Dimension) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Dimension) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains information about a geographic location.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GeoLocation
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// The two-letter code for the continent.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string `min:"2" type:"string"`

	// The two-letter code for the country.
	CountryCode *string `min:"1" type:"string"`

	// The code for the subdivision. Route 53 currently supports only states in
	// the United States.
	SubdivisionCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GeoLocation"}
	if s.ContinentCode != nil && len(*s.ContinentCode) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ContinentCode", 2))
	}
	if s.CountryCode != nil && len(*s.CountryCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CountryCode", 1))
	}
	if s.SubdivisionCode != nil && len(*s.SubdivisionCode) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SubdivisionCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GeoLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContinentCode != nil {
		v := *s.ContinentCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContinentCode", protocol.StringValue(v), metadata)
	}
	if s.CountryCode != nil {
		v := *s.CountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryCode", protocol.StringValue(v), metadata)
	}
	if s.SubdivisionCode != nil {
		v := *s.SubdivisionCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubdivisionCode", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains the codes and full continent, country, and subdivision
// names for the specified geolocation code.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/GeoLocationDetails
type GeoLocationDetails struct {
	_ struct{} `type:"structure"`

	// The two-letter code for the continent.
	ContinentCode *string `min:"2" type:"string"`

	// The full name of the continent.
	ContinentName *string `min:"1" type:"string"`

	// The two-letter code for the country.
	CountryCode *string `min:"1" type:"string"`

	// The name of the country.
	CountryName *string `min:"1" type:"string"`

	// The code for the subdivision. Route 53 currently supports only states in
	// the United States.
	SubdivisionCode *string `min:"1" type:"string"`

	// The full name of the subdivision. Route 53 currently supports only states
	// in the United States.
	SubdivisionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoLocationDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GeoLocationDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContinentCode != nil {
		v := *s.ContinentCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContinentCode", protocol.StringValue(v), metadata)
	}
	if s.ContinentName != nil {
		v := *s.ContinentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContinentName", protocol.StringValue(v), metadata)
	}
	if s.CountryCode != nil {
		v := *s.CountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryCode", protocol.StringValue(v), metadata)
	}
	if s.CountryName != nil {
		v := *s.CountryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CountryName", protocol.StringValue(v), metadata)
	}
	if s.SubdivisionCode != nil {
		v := *s.SubdivisionCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubdivisionCode", protocol.StringValue(v), metadata)
	}
	if s.SubdivisionName != nil {
		v := *s.SubdivisionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubdivisionName", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains information about one health check that is associated
// with the current AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/HealthCheck
type HealthCheck struct {
	_ struct{} `type:"structure"`

	// A unique string that you specified when you created the health check.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains information about the CloudWatch alarm that
	// Amazon Route 53 is monitoring for this health check.
	CloudWatchAlarmConfiguration *CloudWatchAlarmConfiguration `type:"structure"`

	// A complex type that contains detailed information about one health check.
	//
	// HealthCheckConfig is a required field
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`

	// The version of the health check. You can optionally pass this value in a
	// call to UpdateHealthCheck to prevent overwriting another change to the health
	// check.
	//
	// HealthCheckVersion is a required field
	HealthCheckVersion *int64 `min:"1" type:"long" required:"true"`

	// The identifier that Amazon Route 53assigned to the health check when you
	// created it. When you add or update a resource record set, you use this value
	// to specify which health check to use. The value can be up to 64 characters
	// long.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If the health check was created by another service, the service that created
	// the health check. When a health check is created by another service, you
	// can't edit or delete it using Amazon Route 53.
	LinkedService *LinkedService `type:"structure"`
}

// String returns the string representation
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HealthCheck) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.CloudWatchAlarmConfiguration != nil {
		v := s.CloudWatchAlarmConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "CloudWatchAlarmConfiguration", v, metadata)
	}
	if s.HealthCheckConfig != nil {
		v := s.HealthCheckConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HealthCheckConfig", v, metadata)
	}
	if s.HealthCheckVersion != nil {
		v := *s.HealthCheckVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HealthCheckVersion", protocol.Int64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LinkedService != nil {
		v := s.LinkedService

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LinkedService", v, metadata)
	}
	return nil
}

// A complex type that contains information about the health check.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/HealthCheckConfig
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// A complex type that identifies the CloudWatch alarm that you want Amazon
	// Route 53 health checkers to use to determine whether the specified health
	// check is healthy.
	AlarmIdentifier *AlarmIdentifier `type:"structure"`

	// (CALCULATED Health Checks Only) A complex type that contains one ChildHealthCheck
	// element for each health check that you want to associate with a CALCULATED
	// health check.
	ChildHealthChecks []string `locationNameList:"ChildHealthCheck" type:"list"`

	// Stops Route 53 from performing health checks. When you disable a health check,
	// here's what happens:
	//
	//    * Health checks that check the health of endpoints: Route 53 stops submitting
	//    requests to your application, server, or other resource.
	//
	//    * Calculated health checks: Route 53 stops aggregating the status of the
	//    referenced health checks.
	//
	//    * Health checks that monitor CloudWatch alarms: Route 53 stops monitoring
	//    the corresponding CloudWatch metrics.
	//
	// After you disable a health check, Route 53 considers the status of the health
	// check to always be healthy. If you configured DNS failover, Route 53 continues
	// to route traffic to the corresponding resources. If you want to stop routing
	// traffic to a resource, change the value of Inverted (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted).
	//
	// Charges for a health check still apply when the health check is disabled.
	// For more information, see Amazon Route 53 Pricing (http://aws.amazon.com/route53/pricing/).
	Disabled *bool `type:"boolean"`

	// Specify whether you want Amazon Route 53 to send the value of FullyQualifiedDomainName
	// to the endpoint in the client_hello message during TLS negotiation. This
	// allows the endpoint to respond to HTTPS health check requests with the applicable
	// SSL/TLS certificate.
	//
	// Some endpoints require that HTTPS requests include the host name in the client_hello
	// message. If you don't enable SNI, the status of the health check will be
	// SSL alert handshake_failure. A health check can also have that status for
	// other reasons. If SNI is enabled and you're still getting the error, check
	// the SSL/TLS configuration on your endpoint and confirm that your certificate
	// is valid.
	//
	// The SSL/TLS certificate on your endpoint includes a domain name in the Common
	// Name field and possibly several more in the Subject Alternative Names field.
	// One of the domain names in the certificate should match the value that you
	// specify for FullyQualifiedDomainName. If the endpoint responds to the client_hello
	// message with a certificate that does not include the domain name that you
	// specified in FullyQualifiedDomainName, a health checker will retry the handshake.
	// In the second attempt, the health checker will omit FullyQualifiedDomainName
	// from the client_hello message.
	EnableSNI *bool `type:"boolean"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Amazon Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Amazon Route 53 Determines
	// Whether an Endpoint Is Healthy (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// If you don't specify a value for FailureThreshold, the default value is three
	// health checks.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Amazon Route 53 behavior depends on whether you specify a value for IPAddress.
	//
	// If you specify a value for IPAddress:
	//
	// Amazon Route 53 sends health check requests to the specified IPv4 or IPv6
	// address and passes the value of FullyQualifiedDomainName in the Host header
	// for all health checks except TCP health checks. This is typically the fully
	// qualified DNS name of the endpoint on which you want Route 53 to perform
	// health checks.
	//
	// When Route 53 checks the health of an endpoint, here is how it constructs
	// the Host header:
	//
	//    * If you specify a value of 80 for Port and HTTP or HTTP_STR_MATCH for
	//    Type, Route 53 passes the value of FullyQualifiedDomainName to the endpoint
	//    in the Host header.
	//
	//    * If you specify a value of 443 for Port and HTTPS or HTTPS_STR_MATCH
	//    for Type, Route 53 passes the value of FullyQualifiedDomainName to the
	//    endpoint in the Host header.
	//
	//    * If you specify another value for Port and any value except TCP for Type,
	//    Route 53 passes FullyQualifiedDomainName:Port to the endpoint in the Host
	//    header.
	//
	// If you don't specify a value for FullyQualifiedDomainName, Route 53 substitutes
	// the value of IPAddress in the Host header in each of the preceding cases.
	//
	// If you don't specify a value for IPAddress :
	//
	// Route 53 sends a DNS request to the domain that you specify for FullyQualifiedDomainName
	// at the interval that you specify for RequestInterval. Using an IPv4 address
	// that DNS returns, Route 53 then checks the health of the endpoint.
	//
	// If you don't specify a value for IPAddress, Route 53 uses only IPv4 to send
	// health checks to the endpoint. If there's no resource record set with a type
	// of A for the name that you specify for FullyQualifiedDomainName, the health
	// check fails with a "DNS resolution failed" error.
	//
	// If you want to check the health of weighted, latency, or failover resource
	// record sets and you choose to specify the endpoint only by FullyQualifiedDomainName,
	// we recommend that you create a separate health check for each endpoint. For
	// example, create a health check for each HTTP server that is serving content
	// for www.example.com. For the value of FullyQualifiedDomainName, specify the
	// domain name of the server (such as us-east-2-www.example.com), not the name
	// of the resource record sets (www.example.com).
	//
	// In this configuration, if you create a health check for which the value of
	// FullyQualifiedDomainName matches the name of the resource record sets and
	// you then associate the health check with those resource record sets, health
	// check results will be unpredictable.
	//
	// In addition, if the value that you specify for Type is HTTP, HTTPS, HTTP_STR_MATCH,
	// or HTTPS_STR_MATCH, Route 53 passes the value of FullyQualifiedDomainName
	// in the Host header, as it does when you specify a value for IPAddress. If
	// the value of Type is TCP, Route 53 doesn't pass a Host header.
	FullyQualifiedDomainName *string `type:"string"`

	// The number of child health checks that are associated with a CALCULATED health
	// check that Amazon Route 53 must consider healthy for the CALCULATED health
	// check to be considered healthy. To specify the child health checks that you
	// want to associate with a CALCULATED health check, use the ChildHealthChecks
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks)
	// element.
	//
	// Note the following:
	//
	//    * If you specify a number greater than the number of child health checks,
	//    Route 53 always considers this health check to be unhealthy.
	//
	//    * If you specify 0, Route 53 always considers this health check to be
	//    healthy.
	HealthThreshold *int64 `type:"integer"`

	// The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53
	// to perform health checks on. If you don't specify a value for IPAddress,
	// Route 53 sends a DNS request to resolve the domain name that you specify
	// in FullyQualifiedDomainName at the interval that you specify in RequestInterval.
	// Using an IP address returned by DNS, Route 53 then checks the health of the
	// endpoint.
	//
	// Use one of the following formats for the value of IPAddress:
	//
	//    * IPv4 address: four values between 0 and 255, separated by periods (.),
	//    for example, 192.0.2.44.
	//
	//    * IPv6 address: eight groups of four hexadecimal values, separated by
	//    colons (:), for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345. You
	//    can also shorten IPv6 addresses as described in RFC 5952, for example,
	//    2001:db8:85a3::abcd:1:2345.
	//
	// If the endpoint is an EC2 instance, we recommend that you create an Elastic
	// IP address, associate it with your EC2 instance, and specify the Elastic
	// IP address for IPAddress. This ensures that the IP address of your instance
	// will never change.
	//
	// For more information, see FullyQualifiedDomainName (https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
	//
	// Constraints: Route 53 can't check the health of endpoints for which the IP
	// address is in local, private, non-routable, or multicast ranges. For more
	// information about IP addresses for which you can't create health checks,
	// see the following documents:
	//
	//    * RFC 5735, Special Use IPv4 Addresses (https://tools.ietf.org/html/rfc5735)
	//
	//    * RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space (https://tools.ietf.org/html/rfc6598)
	//
	//    * RFC 5156, Special-Use IPv6 Addresses (https://tools.ietf.org/html/rfc5156)
	//
	// When the value of Type is CALCULATED or CLOUDWATCH_METRIC, omit IPAddress.
	IPAddress *string `type:"string"`

	// When CloudWatch has insufficient data about the metric to determine the alarm
	// state, the status that you want Amazon Route 53 to assign to the health check:
	//
	//    * Healthy: Route 53 considers the health check to be healthy.
	//
	//    * Unhealthy: Route 53 considers the health check to be unhealthy.
	//
	//    * LastKnownStatus: Route 53 uses the status of the health check from the
	//    last time that CloudWatch had sufficient data to determine the alarm state.
	//    For new health checks that have no last known status, the default status
	//    for the health check is healthy.
	InsufficientDataHealthStatus InsufficientDataHealthStatus `type:"string" enum:"true"`

	// Specify whether you want Amazon Route 53 to invert the status of a health
	// check, for example, to consider a health check unhealthy when it otherwise
	// would be considered healthy.
	Inverted *bool `type:"boolean"`

	// Specify whether you want Amazon Route 53 to measure the latency between health
	// checkers in multiple AWS regions and your endpoint, and to display CloudWatch
	// latency graphs on the Health Checks page in the Route 53 console.
	//
	// You can't change the value of MeasureLatency after you create a health check.
	MeasureLatency *bool `type:"boolean"`

	// The port on the endpoint on which you want Amazon Route 53 to perform health
	// checks. Specify a value for Port only when you specify a value for IPAddress.
	Port *int64 `min:"1" type:"integer"`

	// A complex type that contains one Region element for each region from which
	// you want Amazon Route 53 health checkers to check the specified endpoint.
	//
	// If you don't specify any regions, Route 53 health checkers automatically
	// performs checks from all of the regions that are listed under Valid Values.
	//
	// If you update a health check to remove a region that has been performing
	// health checks, Route 53 will briefly continue to perform checks from that
	// region to ensure that some health checkers are always checking the endpoint
	// (for example, if you replace three regions with four different regions).
	Regions []HealthCheckRegion `locationNameList:"Region" min:"3" type:"list"`

	// The number of seconds between the time that Amazon Route 53 gets a response
	// from your endpoint and the time that it sends the next health check request.
	// Each Route 53 health checker makes requests at this interval.
	//
	// You can't change the value of RequestInterval after you create a health check.
	//
	// If you don't specify a value for RequestInterval, the default value is 30
	// seconds.
	RequestInterval *int64 `min:"10" type:"integer"`

	// The path, if any, that you want Amazon Route 53 to request when performing
	// health checks. The path can be any value for which your endpoint will return
	// an HTTP status code of 2xx or 3xx when the endpoint is healthy, for example,
	// the file /docs/route53-health-check.html. You can also include query string
	// parameters, for example, /welcome.html?language=jp&login=y.
	ResourcePath *string `type:"string"`

	// If the value of Type is HTTP_STR_MATCH or HTTP_STR_MATCH, the string that
	// you want Amazon Route 53 to search for in the response body from the specified
	// resource. If the string appears in the response body, Route 53 considers
	// the resource healthy.
	//
	// Route 53 considers case when searching for SearchString in the response body.
	SearchString *string `type:"string"`

	// The type of health check that you want to create, which indicates how Amazon
	// Route 53 determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//    * HTTP: Route 53 tries to establish a TCP connection. If successful, Route
	//    53 submits an HTTP request and waits for an HTTP status code of 200 or
	//    greater and less than 400.
	//
	//    * HTTPS: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTPS request and waits for an HTTP status code of
	//    200 or greater and less than 400. If you specify HTTPS for the value of
	//    Type, the endpoint must support TLS v1.0 or later.
	//
	//    * HTTP_STR_MATCH: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTP request and searches the first 5,120 bytes of
	//    the response body for the string that you specify in SearchString.
	//
	//    * HTTPS_STR_MATCH: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTPS request and searches the first 5,120 bytes of
	//    the response body for the string that you specify in SearchString.
	//
	//    * TCP: Route 53 tries to establish a TCP connection.
	//
	//    * CLOUDWATCH_METRIC: The health check is associated with a CloudWatch
	//    alarm. If the state of the alarm is OK, the health check is considered
	//    healthy. If the state is ALARM, the health check is considered unhealthy.
	//    If CloudWatch doesn't have sufficient data to determine whether the state
	//    is OK or ALARM, the health check status depends on the setting for InsufficientDataHealthStatus:
	//    Healthy, Unhealthy, or LastKnownStatus.
	//
	//    * CALCULATED: For health checks that monitor the status of other health
	//    checks, Route 53 adds up the number of health checks that Route 53 health
	//    checkers consider to be healthy and compares that number with the value
	//    of HealthThreshold.
	//
	// For more information, see How Route 53 Determines Whether an Endpoint Is
	// Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Type is a required field
	Type HealthCheckType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HealthCheckConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FailureThreshold", 1))
	}
	if s.Port != nil && *s.Port < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Port", 1))
	}
	if s.Regions != nil && len(s.Regions) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Regions", 3))
	}
	if s.RequestInterval != nil && *s.RequestInterval < 10 {
		invalidParams.Add(aws.NewErrParamMinValue("RequestInterval", 10))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.AlarmIdentifier != nil {
		if err := s.AlarmIdentifier.Validate(); err != nil {
			invalidParams.AddNested("AlarmIdentifier", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HealthCheckConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.AlarmIdentifier != nil {
		v := s.AlarmIdentifier

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AlarmIdentifier", v, metadata)
	}
	if len(s.ChildHealthChecks) > 0 {
		v := s.ChildHealthChecks

		metadata := protocol.Metadata{ListLocationName: "ChildHealthCheck"}
		ls0 := e.List(protocol.BodyTarget, "ChildHealthChecks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.Disabled != nil {
		v := *s.Disabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Disabled", protocol.BoolValue(v), metadata)
	}
	if s.EnableSNI != nil {
		v := *s.EnableSNI

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EnableSNI", protocol.BoolValue(v), metadata)
	}
	if s.FailureThreshold != nil {
		v := *s.FailureThreshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailureThreshold", protocol.Int64Value(v), metadata)
	}
	if s.FullyQualifiedDomainName != nil {
		v := *s.FullyQualifiedDomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FullyQualifiedDomainName", protocol.StringValue(v), metadata)
	}
	if s.HealthThreshold != nil {
		v := *s.HealthThreshold

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HealthThreshold", protocol.Int64Value(v), metadata)
	}
	if s.IPAddress != nil {
		v := *s.IPAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IPAddress", protocol.StringValue(v), metadata)
	}
	if len(s.InsufficientDataHealthStatus) > 0 {
		v := s.InsufficientDataHealthStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsufficientDataHealthStatus", v, metadata)
	}
	if s.Inverted != nil {
		v := *s.Inverted

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Inverted", protocol.BoolValue(v), metadata)
	}
	if s.MeasureLatency != nil {
		v := *s.MeasureLatency

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MeasureLatency", protocol.BoolValue(v), metadata)
	}
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Port", protocol.Int64Value(v), metadata)
	}
	if len(s.Regions) > 0 {
		v := s.Regions

		metadata := protocol.Metadata{ListLocationName: "Region"}
		ls0 := e.List(protocol.BodyTarget, "Regions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.StringValue(v1))
		}
		ls0.End()

	}
	if s.RequestInterval != nil {
		v := *s.RequestInterval

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestInterval", protocol.Int64Value(v), metadata)
	}
	if s.ResourcePath != nil {
		v := *s.ResourcePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourcePath", protocol.StringValue(v), metadata)
	}
	if s.SearchString != nil {
		v := *s.SearchString

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SearchString", protocol.StringValue(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// A complex type that contains the last failure reason as reported by one Amazon
// Route 53 health checker.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/HealthCheckObservation
type HealthCheckObservation struct {
	_ struct{} `type:"structure"`

	// The IP address of the Amazon Route 53 health checker that provided the failure
	// reason in StatusReport.
	IPAddress *string `type:"string"`

	// The region of the Amazon Route 53 health checker that provided the status
	// in StatusReport.
	Region HealthCheckRegion `min:"1" type:"string" enum:"true"`

	// A complex type that contains the last failure reason as reported by one Amazon
	// Route 53 health checker and the time of the failed health check.
	StatusReport *StatusReport `type:"structure"`
}

// String returns the string representation
func (s HealthCheckObservation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HealthCheckObservation) MarshalFields(e protocol.FieldEncoder) error {
	if s.IPAddress != nil {
		v := *s.IPAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IPAddress", protocol.StringValue(v), metadata)
	}
	if len(s.Region) > 0 {
		v := s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Region", v, metadata)
	}
	if s.StatusReport != nil {
		v := s.StatusReport

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "StatusReport", v, metadata)
	}
	return nil
}

// A complex type that contains general information about the hosted zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/HostedZone
type HostedZone struct {
	_ struct{} `type:"structure"`

	// The value that you specified for CallerReference when you created the hosted
	// zone.
	//
	// CallerReference is a required field
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that includes the Comment and PrivateZone elements. If you
	// omitted the HostedZoneConfig and Comment elements from the request, the Config
	// and Comment elements don't appear in the response.
	Config *HostedZoneConfig `type:"structure"`

	// The ID that Amazon Route 53 assigned to the hosted zone when you created
	// it.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// If the hosted zone was created by another service, the service that created
	// the hosted zone. When a hosted zone is created by another service, you can't
	// edit or delete it using Route 53.
	LinkedService *LinkedService `type:"structure"`

	// The name of the domain. For public hosted zones, this is the name that you
	// have registered with your DNS registrar.
	//
	// For information about how to specify characters other than a-z, 0-9, and
	// - (hyphen) and how to specify internationalized domain names, see CreateHostedZone
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html).
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The number of resource record sets in the hosted zone.
	ResourceRecordSetCount *int64 `type:"long"`
}

// String returns the string representation
func (s HostedZone) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HostedZone) MarshalFields(e protocol.FieldEncoder) error {
	if s.CallerReference != nil {
		v := *s.CallerReference

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CallerReference", protocol.StringValue(v), metadata)
	}
	if s.Config != nil {
		v := s.Config

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Config", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LinkedService != nil {
		v := s.LinkedService

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LinkedService", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.ResourceRecordSetCount != nil {
		v := *s.ResourceRecordSetCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceRecordSetCount", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains an optional comment about your hosted zone.
// If you don't want to specify a comment, omit both the HostedZoneConfig and
// Comment elements.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/HostedZoneConfig
type HostedZoneConfig struct {
	_ struct{} `type:"structure"`

	// Any comments that you want to include about the hosted zone.
	Comment *string `type:"string"`

	// A value that indicates whether this is a private hosted zone.
	PrivateZone *bool `type:"boolean"`
}

// String returns the string representation
func (s HostedZoneConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HostedZoneConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.PrivateZone != nil {
		v := *s.PrivateZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PrivateZone", protocol.BoolValue(v), metadata)
	}
	return nil
}

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/HostedZoneLimit
type HostedZoneLimit struct {
	_ struct{} `type:"structure"`

	// The limit that you requested. Valid values include the following:
	//
	//    * MAX_RRSETS_BY_ZONE: The maximum number of records that you can create
	//    in the specified hosted zone.
	//
	//    * MAX_VPCS_ASSOCIATED_BY_ZONE: The maximum number of Amazon VPCs that
	//    you can associate with the specified private hosted zone.
	//
	// Type is a required field
	Type HostedZoneLimitType `type:"string" required:"true" enum:"true"`

	// The current value for the limit that is specified by Type.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s HostedZoneLimit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HostedZoneLimit) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Int64Value(v), metadata)
	}
	return nil
}

// If a health check or hosted zone was created by another service, LinkedService
// is a complex type that describes the service that created the resource. When
// a resource is created by another service, you can't edit or delete it using
// Amazon Route 53.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/LinkedService
type LinkedService struct {
	_ struct{} `type:"structure"`

	// If the health check or hosted zone was created by another service, an optional
	// description that can be provided by the other service. When a resource is
	// created by another service, you can't edit or delete it using Amazon Route
	// 53.
	Description *string `type:"string"`

	// If the health check or hosted zone was created by another service, the service
	// that created the resource. When a resource is created by another service,
	// you can't edit or delete it using Amazon Route 53.
	ServicePrincipal *string `type:"string"`
}

// String returns the string representation
func (s LinkedService) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LinkedService) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.StringValue(v), metadata)
	}
	if s.ServicePrincipal != nil {
		v := *s.ServicePrincipal

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ServicePrincipal", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains information about a configuration for DNS query
// logging.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/QueryLoggingConfig
type QueryLoggingConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon
	// Route 53 is publishing logs to.
	//
	// CloudWatchLogsLogGroupArn is a required field
	CloudWatchLogsLogGroupArn *string `type:"string" required:"true"`

	// The ID of the hosted zone that CloudWatch Logs is logging queries for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The ID for a configuration for DNS query logging.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s QueryLoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueryLoggingConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.CloudWatchLogsLogGroupArn != nil {
		v := *s.CloudWatchLogsLogGroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CloudWatchLogsLogGroupArn", protocol.StringValue(v), metadata)
	}
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostedZoneId", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Information specific to the resource record.
//
// If you're creating an alias resource record set, omit ResourceRecord.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ResourceRecord
type ResourceRecord struct {
	_ struct{} `type:"structure"`

	// The current or new DNS record value, not to exceed 4,000 characters. In the
	// case of a DELETE action, if the current value does not match the actual value,
	// an error is returned. For descriptions about how to format Value for different
	// record types, see Supported DNS Resource Record Types (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can specify more than one value for all record types except CNAME and
	// SOA.
	//
	// If you're creating an alias resource record set, omit Value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRecord) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceRecord"}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceRecord) MarshalFields(e protocol.FieldEncoder) error {
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// Information about the resource record set to create or delete.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ResourceRecordSet
type ResourceRecordSet struct {
	_ struct{} `type:"structure"`

	// Alias resource record sets only: Information about the AWS resource, such
	// as a CloudFront distribution or an Amazon S3 bucket, that you want to route
	// traffic to.
	//
	// If you're creating resource records sets for a private hosted zone, note
	// the following:
	//
	//    * You can't create an alias resource record set in a private hosted zone
	//    to route traffic to a CloudFront distribution.
	//
	//    * Creating geolocation alias resource record sets or latency alias resource
	//    record sets in a private hosted zone is unsupported.
	//
	//    * For information about creating failover resource record sets in a private
	//    hosted zone, see Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	//    in the Amazon Route 53 Developer Guide.
	AliasTarget *AliasTarget `type:"structure"`

	// Failover resource record sets only: To configure failover, you add the Failover
	// element to two resource record sets. For one resource record set, you specify
	// PRIMARY as the value for Failover; for the other resource record set, you
	// specify SECONDARY. In addition, you include the HealthCheckId element and
	// specify the health check that you want Amazon Route 53 to perform for each
	// resource record set.
	//
	// Except where noted, the following failover behaviors assume that you have
	// included the HealthCheckId element in both resource record sets:
	//
	//    * When the primary resource record set is healthy, Route 53 responds to
	//    DNS queries with the applicable value from the primary resource record
	//    set regardless of the health of the secondary resource record set.
	//
	//    * When the primary resource record set is unhealthy and the secondary
	//    resource record set is healthy, Route 53 responds to DNS queries with
	//    the applicable value from the secondary resource record set.
	//
	//    * When the secondary resource record set is unhealthy, Route 53 responds
	//    to DNS queries with the applicable value from the primary resource record
	//    set regardless of the health of the primary resource record set.
	//
	//    * If you omit the HealthCheckId element for the secondary resource record
	//    set, and if the primary resource record set is unhealthy, Route 53 always
	//    responds to DNS queries with the applicable value from the secondary resource
	//    record set. This is true regardless of the health of the associated endpoint.
	//
	// You can't create non-failover resource record sets that have the same values
	// for the Name and Type elements as failover resource record sets.
	//
	// For failover alias resource record sets, you must also include the EvaluateTargetHealth
	// element and set the value to true.
	//
	// For more information about configuring failover for Route 53, see the following
	// topics in the Amazon Route 53 Developer Guide:
	//
	//    * Route 53 Health Checks and DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	//
	//    * Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	Failover ResourceRecordSetFailover `type:"string" enum:"true"`

	// Geolocation resource record sets only: A complex type that lets you control
	// how Amazon Route 53 responds to DNS queries based on the geographic origin
	// of the query. For example, if you want all queries from Africa to be routed
	// to a web server with an IP address of 192.0.2.111, create a resource record
	// set with a Type of A and a ContinentCode of AF.
	//
	// Creating geolocation and geolocation alias resource record sets in private
	// hosted zones is not supported.
	//
	// If you create separate resource record sets for overlapping geographic regions
	// (for example, one resource record set for a continent and one for a country
	// on the same continent), priority goes to the smallest geographic region.
	// This allows you to route most queries for a continent to one resource and
	// to route queries for a country on that continent to a different resource.
	//
	// You can't create two geolocation resource record sets that specify the same
	// geographic location.
	//
	// The value * in the CountryCode element matches all geographic locations that
	// aren't specified in other geolocation resource record sets that have the
	// same values for the Name and Type elements.
	//
	// Geolocation works by mapping IP addresses to locations. However, some IP
	// addresses aren't mapped to geographic locations, so even if you create geolocation
	// resource record sets that cover all seven continents, Route 53 will receive
	// some DNS queries from locations that it can't identify. We recommend that
	// you create a resource record set for which the value of CountryCode is *,
	// which handles both queries that come from locations for which you haven't
	// created geolocation resource record sets and queries from IP addresses that
	// aren't mapped to a location. If you don't create a * resource record set,
	// Route 53 returns a "no answer" response for queries from those locations.
	//
	// You can't create non-geolocation resource record sets that have the same
	// values for the Name and Type elements as geolocation resource record sets.
	GeoLocation *GeoLocation `type:"structure"`

	// If you want Amazon Route 53 to return this resource record set in response
	// to a DNS query only when the status of a health check is healthy, include
	// the HealthCheckId element and specify the ID of the applicable health check.
	//
	// Route 53 determines whether a resource record set is healthy based on one
	// of the following:
	//
	//    * By periodically sending a request to the endpoint that is specified
	//    in the health check
	//
	//    * By aggregating the status of a specified group of health checks (calculated
	//    health checks)
	//
	//    * By determining the current state of a CloudWatch alarm (CloudWatch metric
	//    health checks)
	//
	// Route 53 doesn't check the health of the endpoint that is specified in the
	// resource record set, for example, the endpoint specified by the IP address
	// in the Value element. When you add a HealthCheckId element to a resource
	// record set, Route 53 checks the health of the endpoint that you specified
	// in the health check.
	//
	// For more information, see the following topics in the Amazon Route 53 Developer
	// Guide:
	//
	//    * How Amazon Route 53 Determines Whether an Endpoint Is Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	//
	//    * Route 53 Health Checks and DNS Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html)
	//
	//    * Configuring Failover in a Private Hosted Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html)
	//
	// When to Specify HealthCheckId
	//
	// Specifying a value for HealthCheckId is useful only when Route 53 is choosing
	// between two or more resource record sets to respond to a DNS query, and you
	// want Route 53 to base the choice in part on the status of a health check.
	// Configuring health checks makes sense only in the following configurations:
	//
	//    * Non-alias resource record sets: You're checking the health of a group
	//    of non-alias resource record sets that have the same routing policy, name,
	//    and type (such as multiple weighted records named www.example.com with
	//    a type of A) and you specify health check IDs for all the resource record
	//    sets. If the health check status for a resource record set is healthy,
	//    Route 53 includes the record among the records that it responds to DNS
	//    queries with. If the health check status for a resource record set is
	//    unhealthy, Route 53 stops responding to DNS queries using the value for
	//    that resource record set. If the health check status for all resource
	//    record sets in the group is unhealthy, Route 53 considers all resource
	//    record sets in the group healthy and responds to DNS queries accordingly.
	//
	//    * Alias resource record sets: You specify the following settings: You
	//    set EvaluateTargetHealth to true for an alias resource record set in a
	//    group of resource record sets that have the same routing policy, name,
	//    and type (such as multiple weighted records named www.example.com with
	//    a type of A). You configure the alias resource record set to route traffic
	//    to a non-alias resource record set in the same hosted zone. You specify
	//    a health check ID for the non-alias resource record set. If the health
	//    check status is healthy, Route 53 considers the alias resource record
	//    set to be healthy and includes the alias record among the records that
	//    it responds to DNS queries with. If the health check status is unhealthy,
	//    Route 53 stops responding to DNS queries using the alias resource record
	//    set. The alias resource record set can also route traffic to a group of
	//    non-alias resource record sets that have the same routing policy, name,
	//    and type. In that configuration, associate health checks with all of the
	//    resource record sets in the group of non-alias resource record sets.
	//
	// Geolocation Routing
	//
	// For geolocation resource record sets, if an endpoint is unhealthy, Route
	// 53 looks for a resource record set for the larger, associated geographic
	// region. For example, suppose you have resource record sets for a state in
	// the United States, for the entire United States, for North America, and a
	// resource record set that has * for CountryCode is *, which applies to all
	// locations. If the endpoint for the state resource record set is unhealthy,
	// Route 53 checks for healthy resource record sets in the following order until
	// it finds a resource record set for which the endpoint is healthy:
	//
	//    * The United States
	//
	//    * North America
	//
	//    * The default resource record set
	//
	// Specifying the Health Check Endpoint by Domain Name
	//
	// If your health checks specify the endpoint only by domain name, we recommend
	// that you create a separate health check for each endpoint. For example, create
	// a health check for each HTTP server that is serving content for www.example.com.
	// For the value of FullyQualifiedDomainName, specify the domain name of the
	// server (such as us-east-2-www.example.com), not the name of the resource
	// record sets (www.example.com).
	//
	// Health check results will be unpredictable if you do the following:
	//
	//    * Create a health check that has the same value for FullyQualifiedDomainName
	//    as the name of a resource record set.
	//
	//    * Associate that health check with the resource record set.
	HealthCheckId *string `type:"string"`

	// Multivalue answer resource record sets only: To route traffic approximately
	// randomly to multiple resources, such as web servers, create one multivalue
	// answer record for each resource and specify true for MultiValueAnswer. Note
	// the following:
	//
	//    * If you associate a health check with a multivalue answer resource record
	//    set, Amazon Route 53 responds to DNS queries with the corresponding IP
	//    address only when the health check is healthy.
	//
	//    * If you don't associate a health check with a multivalue answer record,
	//    Route 53 always considers the record to be healthy.
	//
	//    * Route 53 responds to DNS queries with up to eight healthy records; if
	//    you have eight or fewer healthy records, Route 53 responds to all DNS
	//    queries with all the healthy records.
	//
	//    * If you have more than eight healthy records, Route 53 responds to different
	//    DNS resolvers with different combinations of healthy records.
	//
	//    * When all records are unhealthy, Route 53 responds to DNS queries with
	//    up to eight unhealthy records.
	//
	//    * If a resource becomes unavailable after a resolver caches a response,
	//    client software typically tries another of the IP addresses in the response.
	//
	// You can't create multivalue answer alias records.
	MultiValueAnswer *bool `type:"boolean"`

	// For ChangeResourceRecordSets requests, the name of the record that you want
	// to create, update, or delete. For ListResourceRecordSets responses, the name
	// of a record in the specified hosted zone.
	//
	// ChangeResourceRecordSets Only
	//
	// Enter a fully qualified domain name, for example, www.example.com. You can
	// optionally include a trailing dot. If you omit the trailing dot, Amazon Route
	// 53 assumes that the domain name that you specify is fully qualified. This
	// means that Route 53 treats www.example.com (without a trailing dot) and www.example.com.
	// (with a trailing dot) as identical.
	//
	// For information about how to specify characters other than a-z, 0-9, and
	// - (hyphen) and how to specify internationalized domain names, see DNS Domain
	// Name Format (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// You can use the asterisk (*) wildcard to replace the leftmost label in a
	// domain name, for example, *.example.com. Note the following:
	//
	//    * The * must replace the entire label. For example, you can't specify
	//    *prod.example.com or prod*.example.com.
	//
	//    * The * can't replace any of the middle labels, for example, marketing.*.example.com.
	//
	//    * If you include * in any position other than the leftmost label in a
	//    domain name, DNS treats it as an * character (ASCII 42), not as a wildcard.
	//    You can't use the * wildcard for resource records sets that have a type
	//    of NS.
	//
	// You can use the * wildcard as the leftmost label in a domain name, for example,
	// *.example.com. You can't use an * for one of the middle labels, for example,
	// marketing.*.example.com. In addition, the * must replace the entire label;
	// for example, you can't specify prod*.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Latency-based resource record sets only: The Amazon EC2 Region where you
	// created the resource that this resource record set refers to. The resource
	// typically is an AWS resource, such as an EC2 instance or an ELB load balancer,
	// and is referred to by an IP address or a DNS domain name, depending on the
	// record type.
	//
	// Creating latency and latency alias resource record sets in private hosted
	// zones is not supported.
	//
	// When Amazon Route 53 receives a DNS query for a domain name and type for
	// which you have created latency resource record sets, Route 53 selects the
	// latency resource record set that has the lowest latency between the end user
	// and the associated Amazon EC2 Region. Route 53 then returns the value that
	// is associated with the selected resource record set.
	//
	// Note the following:
	//
	//    * You can only specify one ResourceRecord per latency resource record
	//    set.
	//
	//    * You can only create one latency resource record set for each Amazon
	//    EC2 Region.
	//
	//    * You aren't required to create latency resource record sets for all Amazon
	//    EC2 Regions. Route 53 will choose the region with the best latency from
	//    among the regions that you create latency resource record sets for.
	//
	//    * You can't create non-latency resource record sets that have the same
	//    values for the Name and Type elements as latency resource record sets.
	Region ResourceRecordSetRegion `min:"1" type:"string" enum:"true"`

	// Information about the resource records to act upon.
	//
	// If you're creating an alias resource record set, omit ResourceRecords.
	ResourceRecords []ResourceRecord `locationNameList:"ResourceRecord" min:"1" type:"list"`

	// Resource record sets that have a routing policy other than simple: An identifier
	// that differentiates among multiple resource record sets that have the same
	// combination of name and type, such as multiple weighted resource record sets
	// named acme.example.com that have a type of A. In a group of resource record
	// sets that have the same name and type, the value of SetIdentifier must be
	// unique for each resource record set.
	//
	// For information about routing policies, see Choosing a Routing Policy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html)
	// in the Amazon Route 53 Developer Guide.
	SetIdentifier *string `min:"1" type:"string"`

	// The resource record cache time to live (TTL), in seconds. Note the following:
	//
	//    * If you're creating or updating an alias resource record set, omit TTL.
	//    Amazon Route 53 uses the value of TTL for the alias target.
	//
	//    * If you're associating this resource record set with a health check (if
	//    you're adding a HealthCheckId element), we recommend that you specify
	//    a TTL of 60 seconds or less so clients respond quickly to changes in health
	//    status.
	//
	//    * All of the resource record sets in a group of weighted resource record
	//    sets must have the same value for TTL.
	//
	//    * If a group of weighted resource record sets includes one or more weighted
	//    alias resource record sets for which the alias target is an ELB load balancer,
	//    we recommend that you specify a TTL of 60 seconds for all of the non-alias
	//    weighted resource record sets that have the same name and type. Values
	//    other than 60 seconds (the TTL for load balancers) will change the effect
	//    of the values that you specify for Weight.
	TTL *int64 `type:"long"`

	// When you create a traffic policy instance, Amazon Route 53 automatically
	// creates a resource record set. TrafficPolicyInstanceId is the ID of the traffic
	// policy instance that Route 53 created this resource record set for.
	//
	// To delete the resource record set that is associated with a traffic policy
	// instance, use DeleteTrafficPolicyInstance. Route 53 will delete the resource
	// record set automatically. If you delete the resource record set by using
	// ChangeResourceRecordSets, Route 53 doesn't automatically delete the traffic
	// policy instance, and you'll continue to be charged for it even though it's
	// no longer in use.
	TrafficPolicyInstanceId *string `min:"1" type:"string"`

	// The DNS record type. For information about different record types and how
	// data is encoded for them, see Supported DNS Resource Record Types (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Valid values for basic resource record sets: A | AAAA | CAA | CNAME | MX
	// | NAPTR | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for weighted, latency, geolocation, and failover resource record sets:
	// A | AAAA | CAA | CNAME | MX | NAPTR | PTR | SPF | SRV | TXT. When creating
	// a group of weighted, latency, geolocation, or failover resource record sets,
	// specify the same value for all of the resource record sets in the group.
	//
	// Valid values for multivalue answer resource record sets: A | AAAA | MX |
	// NAPTR | PTR | SPF | SRV | TXT
	//
	// SPF records were formerly used to verify the identity of the sender of email
	// messages. However, we no longer recommend that you create resource record
	// sets for which the value of Type is SPF. RFC 7208, Sender Policy Framework
	// (SPF) for Authorizing Use of Domains in Email, Version 1, has been updated
	// to say, "...[I]ts existence and mechanism defined in [RFC4408] have led to
	// some interoperability issues. Accordingly, its use is no longer appropriate
	// for SPF version 1; implementations are not to use it." In RFC 7208, see section
	// 14.1, The SPF DNS Record Type (http://tools.ietf.org/html/rfc7208#section-14.1).
	//
	// Values for alias resource record sets:
	//
	//    * Amazon API Gateway custom regional APIs and edge-optimized APIs: A
	//
	//    * CloudFront distributions: A If IPv6 is enabled for the distribution,
	//    create two resource record sets to route traffic to your distribution,
	//    one with a value of A and one with a value of AAAA.
	//
	//    * AWS Elastic Beanstalk environment that has a regionalized subdomain:
	//    A
	//
	//    * ELB load balancers: A | AAAA
	//
	//    * Amazon S3 buckets: A
	//
	//    * Amazon Virtual Private Cloud interface VPC endpoints A
	//
	//    * Another resource record set in this hosted zone: Specify the type of
	//    the resource record set that you're creating the alias for. All values
	//    are supported except NS and SOA. If you're creating an alias record that
	//    has the same name as the hosted zone (known as the zone apex), you can't
	//    route traffic to a record for which the value of Type is CNAME. This is
	//    because the alias record must have the same type as the record you're
	//    routing traffic to, and creating a CNAME record for the zone apex isn't
	//    supported even for an alias record.
	//
	// Type is a required field
	Type RRType `type:"string" required:"true" enum:"true"`

	// Weighted resource record sets only: Among resource record sets that have
	// the same combination of DNS name and type, a value that determines the proportion
	// of DNS queries that Amazon Route 53 responds to using the current resource
	// record set. Route 53 calculates the sum of the weights for the resource record
	// sets that have the same combination of DNS name and type. Route 53 then responds
	// to queries based on the ratio of a resource's weight to the total. Note the
	// following:
	//
	//    * You must specify a value for the Weight element for every weighted resource
	//    record set.
	//
	//    * You can only specify one ResourceRecord per weighted resource record
	//    set.
	//
	//    * You can't create latency, failover, or geolocation resource record sets
	//    that have the same values for the Name and Type elements as weighted resource
	//    record sets.
	//
	//    * You can create a maximum of 100 weighted resource record sets that have
	//    the same values for the Name and Type elements.
	//
	//    * For weighted (but not weighted alias) resource record sets, if you set
	//    Weight to 0 for a resource record set, Route 53 never responds to queries
	//    with the applicable value for that resource record set. However, if you
	//    set Weight to 0 for all resource record sets that have the same combination
	//    of DNS name and type, traffic is routed to all resources with equal probability.
	//    The effect of setting Weight to 0 is different when you associate health
	//    checks with weighted resource record sets. For more information, see Options
	//    for Configuring Route 53 Active-Active and Active-Passive Failover (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html)
	//    in the Amazon Route 53 Developer Guide.
	Weight *int64 `type:"long"`
}

// String returns the string representation
func (s ResourceRecordSet) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceRecordSet) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceRecordSet"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.ResourceRecords != nil && len(s.ResourceRecords) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceRecords", 1))
	}
	if s.SetIdentifier != nil && len(*s.SetIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SetIdentifier", 1))
	}
	if s.TrafficPolicyInstanceId != nil && len(*s.TrafficPolicyInstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TrafficPolicyInstanceId", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.AliasTarget != nil {
		if err := s.AliasTarget.Validate(); err != nil {
			invalidParams.AddNested("AliasTarget", err.(aws.ErrInvalidParams))
		}
	}
	if s.GeoLocation != nil {
		if err := s.GeoLocation.Validate(); err != nil {
			invalidParams.AddNested("GeoLocation", err.(aws.ErrInvalidParams))
		}
	}
	if s.ResourceRecords != nil {
		for i, v := range s.ResourceRecords {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRecords", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceRecordSet) MarshalFields(e protocol.FieldEncoder) error {
	if s.AliasTarget != nil {
		v := s.AliasTarget

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AliasTarget", v, metadata)
	}
	if len(s.Failover) > 0 {
		v := s.Failover

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Failover", v, metadata)
	}
	if s.GeoLocation != nil {
		v := s.GeoLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GeoLocation", v, metadata)
	}
	if s.HealthCheckId != nil {
		v := *s.HealthCheckId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HealthCheckId", protocol.StringValue(v), metadata)
	}
	if s.MultiValueAnswer != nil {
		v := *s.MultiValueAnswer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MultiValueAnswer", protocol.BoolValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if len(s.Region) > 0 {
		v := s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Region", v, metadata)
	}
	if len(s.ResourceRecords) > 0 {
		v := s.ResourceRecords

		metadata := protocol.Metadata{ListLocationName: "ResourceRecord"}
		ls0 := e.List(protocol.BodyTarget, "ResourceRecords", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SetIdentifier != nil {
		v := *s.SetIdentifier

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SetIdentifier", protocol.StringValue(v), metadata)
	}
	if s.TTL != nil {
		v := *s.TTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TTL", protocol.Int64Value(v), metadata)
	}
	if s.TrafficPolicyInstanceId != nil {
		v := *s.TrafficPolicyInstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyInstanceId", protocol.StringValue(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	if s.Weight != nil {
		v := *s.Weight

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Weight", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type containing a resource and its associated tags.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ResourceTagSet
type ResourceTagSet struct {
	_ struct{} `type:"structure"`

	// The ID for the specified resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	//
	//    * The resource type for health checks is healthcheck.
	//
	//    * The resource type for hosted zones is hostedzone.
	ResourceType TagResourceType `type:"string" enum:"true"`

	// The tags associated with the specified resource.
	Tags []Tag `locationNameList:"Tag" min:"1" type:"list"`
}

// String returns the string representation
func (s ResourceTagSet) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceTagSet) MarshalFields(e protocol.FieldEncoder) error {
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceId", protocol.StringValue(v), metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceType", v, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{ListLocationName: "Tag"}
		ls0 := e.List(protocol.BodyTarget, "Tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ReusableDelegationSetLimit
type ReusableDelegationSetLimit struct {
	_ struct{} `type:"structure"`

	// The limit that you requested: MAX_ZONES_BY_REUSABLE_DELEGATION_SET, the maximum
	// number of hosted zones that you can associate with the specified reusable
	// delegation set.
	//
	// Type is a required field
	Type ReusableDelegationSetLimitType `type:"string" required:"true" enum:"true"`

	// The current value for the MAX_ZONES_BY_REUSABLE_DELEGATION_SET limit.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s ReusableDelegationSetLimit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReusableDelegationSetLimit) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains the status that one Amazon Route 53 health checker
// reports and the time of the health check.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/StatusReport
type StatusReport struct {
	_ struct{} `type:"structure"`

	// The date and time that the health checker performed the health check in ISO
	// 8601 format (https://en.wikipedia.org/wiki/ISO_8601) and Coordinated Universal
	// Time (UTC). For example, the value 2017-03-27T17:48:16.751Z represents March
	// 27, 2017 at 17:48:16.751 UTC.
	CheckedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A description of the status of the health check endpoint as reported by one
	// of the Amazon Route 53 health checkers.
	Status *string `type:"string"`
}

// String returns the string representation
func (s StatusReport) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StatusReport) MarshalFields(e protocol.FieldEncoder) error {
	if s.CheckedTime != nil {
		v := *s.CheckedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CheckedTime", protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormat}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains information about a tag that you want to add
// or edit for the specified health check or hosted zone.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The value of Key depends on the operation that you want to perform:
	//
	//    * Add a tag to a health check or hosted zone: Key is the name that you
	//    want to give the new tag.
	//
	//    * Edit a tag: Key is the name of the tag that you want to change the Value
	//    for.
	//
	//    * Delete a key: Key is the name of the tag you want to remove.
	//
	//    * Give a name to a health check: Edit the default Name tag. In the Amazon
	//    Route 53 console, the list of your health checks includes a Name column
	//    that lets you see the name that you've given to each health check.
	Key *string `type:"string"`

	// The value of Value depends on the operation that you want to perform:
	//
	//    * Add a tag to a health check or hosted zone: Value is the value that
	//    you want to give the new tag.
	//
	//    * Edit a tag: Value is the new value that you want to assign the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.StringValue(v), metadata)
	}
	return nil
}

// A complex type that contains settings for a traffic policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TrafficPolicy
type TrafficPolicy struct {
	_ struct{} `type:"structure"`

	// The comment that you specify in the CreateTrafficPolicy request, if any.
	Comment *string `type:"string"`

	// The definition of a traffic policy in JSON format. You specify the JSON document
	// to use for a new traffic policy in the CreateTrafficPolicy request. For more
	// information about the JSON format, see Traffic Policy Document Format (https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
	//
	// Document is a required field
	Document *string `type:"string" required:"true"`

	// The ID that Amazon Route 53 assigned to a traffic policy when you created
	// it.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The name that you specified when you created the traffic policy.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The DNS type of the resource record sets that Amazon Route 53 creates when
	// you use a traffic policy to create a traffic policy instance.
	//
	// Type is a required field
	Type RRType `type:"string" required:"true" enum:"true"`

	// The version number that Amazon Route 53 assigns to a traffic policy. For
	// a new traffic policy, the value of Version is always 1.
	//
	// Version is a required field
	Version *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TrafficPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if s.Comment != nil {
		v := *s.Comment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comment", protocol.StringValue(v), metadata)
	}
	if s.Document != nil {
		v := *s.Document

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Document", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains settings for the new traffic policy instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TrafficPolicyInstance
type TrafficPolicyInstance struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that Amazon Route 53 created resource record sets
	// in.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `type:"string" required:"true"`

	// The ID that Amazon Route 53 assigned to the new traffic policy instance.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// If State is Failed, an explanation of the reason for the failure. If State
	// is another value, Message is empty.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`

	// The DNS name, such as www.example.com, for which Amazon Route 53 responds
	// to queries by using the resource record sets that are associated with this
	// traffic policy instance.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of State is one of the following values:
	//
	// Applied
	//
	// Amazon Route 53 has finished creating resource record sets, and changes have
	// propagated to all Route 53 edge locations.
	//
	// Creating
	//
	// Route 53 is creating the resource record sets. Use GetTrafficPolicyInstance
	// to confirm that the CreateTrafficPolicyInstance request completed successfully.
	//
	// Failed
	//
	// Route 53 wasn't able to create or update the resource record sets. When the
	// value of State is Failed, see Message for an explanation of what caused the
	// request to fail.
	//
	// State is a required field
	State *string `type:"string" required:"true"`

	// The TTL that Amazon Route 53 assigned to all of the resource record sets
	// that it created in the specified hosted zone.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The ID of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyId is a required field
	TrafficPolicyId *string `min:"1" type:"string" required:"true"`

	// The DNS type that Amazon Route 53 assigned to all of the resource record
	// sets that it created for this traffic policy instance.
	//
	// TrafficPolicyType is a required field
	TrafficPolicyType RRType `type:"string" required:"true" enum:"true"`

	// The version of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// TrafficPolicyVersion is a required field
	TrafficPolicyVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s TrafficPolicyInstance) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TrafficPolicyInstance) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostedZoneId", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Message", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.State != nil {
		v := *s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.StringValue(v), metadata)
	}
	if s.TTL != nil {
		v := *s.TTL

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TTL", protocol.Int64Value(v), metadata)
	}
	if s.TrafficPolicyId != nil {
		v := *s.TrafficPolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyId", protocol.StringValue(v), metadata)
	}
	if len(s.TrafficPolicyType) > 0 {
		v := s.TrafficPolicyType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyType", v, metadata)
	}
	if s.TrafficPolicyVersion != nil {
		v := *s.TrafficPolicyVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A complex type that contains information about the latest version of one
// traffic policy that is associated with the current AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/TrafficPolicySummary
type TrafficPolicySummary struct {
	_ struct{} `type:"structure"`

	// The ID that Amazon Route 53 assigned to the traffic policy when you created
	// it.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The version number of the latest version of the traffic policy.
	//
	// LatestVersion is a required field
	LatestVersion *int64 `min:"1" type:"integer" required:"true"`

	// The name that you specified for the traffic policy when you created it.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The number of traffic policies that are associated with the current AWS account.
	//
	// TrafficPolicyCount is a required field
	TrafficPolicyCount *int64 `min:"1" type:"integer" required:"true"`

	// The DNS type of the resource record sets that Amazon Route 53 creates when
	// you use a traffic policy to create a traffic policy instance.
	//
	// Type is a required field
	Type RRType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s TrafficPolicySummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TrafficPolicySummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.LatestVersion != nil {
		v := *s.LatestVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersion", protocol.Int64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.StringValue(v), metadata)
	}
	if s.TrafficPolicyCount != nil {
		v := *s.TrafficPolicyCount

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyCount", protocol.Int64Value(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", v, metadata)
	}
	return nil
}

// (Private hosted zones only) A complex type that contains information about
// an Amazon VPC.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/VPC
type VPC struct {
	_ struct{} `type:"structure"`

	// (Private hosted zones only) The ID of an Amazon VPC.
	VPCId *string `type:"string"`

	// (Private hosted zones only) The region that an Amazon VPC was created in.
	VPCRegion VPCRegion `min:"1" type:"string" enum:"true"`
}

// String returns the string representation
func (s VPC) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VPC) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VPC"}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VPC) MarshalFields(e protocol.FieldEncoder) error {
	if s.VPCId != nil {
		v := *s.VPCId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VPCId", protocol.StringValue(v), metadata)
	}
	if len(s.VPCRegion) > 0 {
		v := s.VPCRegion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VPCRegion", v, metadata)
	}
	return nil
}
