// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitationsRequest
type ListInvitationsInput struct {
	_ struct{} `type:"structure"`

	// Indicates the maximum number of items that you want in the response.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// Paginates results. Set the value of this parameter to NULL on your first
	// call to the ListInvitations operation. For subsequent calls to the operation,
	// fill nextToken in the request with the value of NextToken from the previous
	// response to continue listing data.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation
func (s ListInvitationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInvitationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInvitationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInvitationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitationsResponse
type ListInvitationsOutput struct {
	_ struct{} `type:"structure"`

	// The details of the invitations returned by the operation.
	Invitations []Invitation `type:"list"`

	// The token that is required for pagination.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInvitationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListInvitationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Invitations) > 0 {
		v := s.Invitations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Invitations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListInvitations = "ListInvitations"

// ListInvitationsRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Lists all Security Hub membership invitations that were sent to the current
// AWS account.
//
//    // Example sending a request using ListInvitationsRequest.
//    req := client.ListInvitationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations
func (c *Client) ListInvitationsRequest(input *ListInvitationsInput) ListInvitationsRequest {
	op := &aws.Operation{
		Name:       opListInvitations,
		HTTPMethod: "GET",
		HTTPPath:   "/invitations",
	}

	if input == nil {
		input = &ListInvitationsInput{}
	}

	req := c.newRequest(op, input, &ListInvitationsOutput{})
	return ListInvitationsRequest{Request: req, Input: input, Copy: c.ListInvitationsRequest}
}

// ListInvitationsRequest is the request type for the
// ListInvitations API operation.
type ListInvitationsRequest struct {
	*aws.Request
	Input *ListInvitationsInput
	Copy  func(*ListInvitationsInput) ListInvitationsRequest
}

// Send marshals and sends the ListInvitations API request.
func (r ListInvitationsRequest) Send(ctx context.Context) (*ListInvitationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInvitationsResponse{
		ListInvitationsOutput: r.Request.Data.(*ListInvitationsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListInvitationsResponse is the response type for the
// ListInvitations API operation.
type ListInvitationsResponse struct {
	*ListInvitationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInvitations request.
func (r *ListInvitationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
