// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstancesRequest
type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances that you want AWS Cloud Map to return in
	// the response to a ListInstances request. If you don't specify a value for
	// MaxResults, AWS Cloud Map returns up to 100 instances.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListInstances request, omit this value.
	//
	// If more than MaxResults instances match the specified criteria, you can submit
	// another ListInstances request to get the next group of results. Specify the
	// value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// The ID of the service that you want to list instances for.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ServiceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstancesResponse
type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the instances that are associated with the specified
	// service.
	Instances []InstanceSummary `type:"list"`

	// If more than MaxResults instances match the specified criteria, you can submit
	// another ListInstances request to get the next group of results. Specify the
	// value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListInstances = "ListInstances"

// ListInstancesRequest returns a request value for making API operation for
// AWS Cloud Map.
//
// Lists summary information about the instances that you registered by using
// a specified service.
//
//    // Example sending a request using ListInstancesRequest.
//    req := client.ListInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances
func (c *Client) ListInstancesRequest(input *ListInstancesInput) ListInstancesRequest {
	op := &aws.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	req := c.newRequest(op, input, &ListInstancesOutput{})
	return ListInstancesRequest{Request: req, Input: input, Copy: c.ListInstancesRequest}
}

// ListInstancesRequest is the request type for the
// ListInstances API operation.
type ListInstancesRequest struct {
	*aws.Request
	Input *ListInstancesInput
	Copy  func(*ListInstancesInput) ListInstancesRequest
}

// Send marshals and sends the ListInstances API request.
func (r ListInstancesRequest) Send(ctx context.Context) (*ListInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListInstancesResponse{
		ListInstancesOutput: r.Request.Data.(*ListInstancesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListInstancesRequestPaginator returns a paginator for ListInstances.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListInstancesRequest(input)
//   p := servicediscovery.NewListInstancesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListInstancesPaginator(req ListInstancesRequest) ListInstancesPaginator {
	return ListInstancesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListInstancesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListInstancesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListInstancesPaginator struct {
	aws.Pager
}

func (p *ListInstancesPaginator) CurrentPage() *ListInstancesOutput {
	return p.Pager.CurrentPage().(*ListInstancesOutput)
}

// ListInstancesResponse is the response type for the
// ListInstances API operation.
type ListInstancesResponse struct {
	*ListInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListInstances request.
func (r *ListInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
