// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplateRequest
type TestRenderTemplateInput struct {
	_ struct{} `type:"structure"`

	// A list of replacement values to apply to the template. This parameter is
	// a JSON object, typically consisting of key-value pairs in which the keys
	// correspond to replacement tags in the email template.
	//
	// TemplateData is a required field
	TemplateData *string `type:"string" required:"true"`

	// The name of the template that you want to render.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestRenderTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestRenderTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TestRenderTemplateInput"}

	if s.TemplateData == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateData"))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplateResponse
type TestRenderTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The complete MIME message rendered by applying the data in the TemplateData
	// parameter to the template specified in the TemplateName parameter.
	RenderedTemplate *string `type:"string"`
}

// String returns the string representation
func (s TestRenderTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opTestRenderTemplate = "TestRenderTemplate"

// TestRenderTemplateRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Creates a preview of the MIME content of an email when provided with a template
// and a set of replacement data.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using TestRenderTemplateRequest.
//    req := client.TestRenderTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/TestRenderTemplate
func (c *Client) TestRenderTemplateRequest(input *TestRenderTemplateInput) TestRenderTemplateRequest {
	op := &aws.Operation{
		Name:       opTestRenderTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestRenderTemplateInput{}
	}

	req := c.newRequest(op, input, &TestRenderTemplateOutput{})
	return TestRenderTemplateRequest{Request: req, Input: input, Copy: c.TestRenderTemplateRequest}
}

// TestRenderTemplateRequest is the request type for the
// TestRenderTemplate API operation.
type TestRenderTemplateRequest struct {
	*aws.Request
	Input *TestRenderTemplateInput
	Copy  func(*TestRenderTemplateInput) TestRenderTemplateRequest
}

// Send marshals and sends the TestRenderTemplate API request.
func (r TestRenderTemplateRequest) Send(ctx context.Context) (*TestRenderTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestRenderTemplateResponse{
		TestRenderTemplateOutput: r.Request.Data.(*TestRenderTemplateOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestRenderTemplateResponse is the response type for the
// TestRenderTemplate API operation.
type TestRenderTemplateResponse struct {
	*TestRenderTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestRenderTemplate request.
func (r *TestRenderTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
