// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectorsRequest
type GetConnectorsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. The default value
	// is 50. To retrieve the remaining results, make another call with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectorsResponse
type GetConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the registered connectors.
	ConnectorList []Connector `locationName:"connectorList" type:"list"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetConnectors = "GetConnectors"

// GetConnectorsRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Describes the connectors registered with the AWS SMS.
//
//    // Example sending a request using GetConnectorsRequest.
//    req := client.GetConnectorsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetConnectors
func (c *Client) GetConnectorsRequest(input *GetConnectorsInput) GetConnectorsRequest {
	op := &aws.Operation{
		Name:       opGetConnectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConnectorsInput{}
	}

	req := c.newRequest(op, input, &GetConnectorsOutput{})
	return GetConnectorsRequest{Request: req, Input: input, Copy: c.GetConnectorsRequest}
}

// GetConnectorsRequest is the request type for the
// GetConnectors API operation.
type GetConnectorsRequest struct {
	*aws.Request
	Input *GetConnectorsInput
	Copy  func(*GetConnectorsInput) GetConnectorsRequest
}

// Send marshals and sends the GetConnectors API request.
func (r GetConnectorsRequest) Send(ctx context.Context) (*GetConnectorsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetConnectorsResponse{
		GetConnectorsOutput: r.Request.Data.(*GetConnectorsOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetConnectorsRequestPaginator returns a paginator for GetConnectors.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetConnectorsRequest(input)
//   p := sms.NewGetConnectorsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetConnectorsPaginator(req GetConnectorsRequest) GetConnectorsPaginator {
	return GetConnectorsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetConnectorsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetConnectorsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetConnectorsPaginator struct {
	aws.Pager
}

func (p *GetConnectorsPaginator) CurrentPage() *GetConnectorsOutput {
	return p.Pager.CurrentPage().(*GetConnectorsOutput)
}

// GetConnectorsResponse is the response type for the
// GetConnectors API operation.
type GetConnectorsResponse struct {
	*GetConnectorsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetConnectors request.
func (r *GetConnectorsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
