// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTargetRequest
type UpdateMaintenanceWindowTargetInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the update.
	Description *string `min:"1" type:"string"`

	// A name for the update.
	Name *string `min:"3" type:"string"`

	// User-provided value that will be included in any CloudWatch events raised
	// while running tasks for these targets in this Maintenance Window.
	OwnerInformation *string `min:"1" type:"string"`

	// If True, then all fields that are required by the RegisterTargetWithMaintenanceWindow
	// action are also required for this API request. Optional fields that are not
	// specified are set to null.
	Replace *bool `type:"boolean"`

	// The targets to add or replace.
	Targets []Target `type:"list"`

	// The Maintenance Window ID with which to modify the target.
	//
	// WindowId is a required field
	WindowId *string `min:"20" type:"string" required:"true"`

	// The target ID to modify.
	//
	// WindowTargetId is a required field
	WindowTargetId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateMaintenanceWindowTargetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMaintenanceWindowTargetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateMaintenanceWindowTargetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 3))
	}
	if s.OwnerInformation != nil && len(*s.OwnerInformation) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OwnerInformation", 1))
	}

	if s.WindowId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WindowId"))
	}
	if s.WindowId != nil && len(*s.WindowId) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowId", 20))
	}

	if s.WindowTargetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WindowTargetId"))
	}
	if s.WindowTargetId != nil && len(*s.WindowTargetId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("WindowTargetId", 36))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTargetResult
type UpdateMaintenanceWindowTargetOutput struct {
	_ struct{} `type:"structure"`

	// The updated description.
	Description *string `min:"1" type:"string"`

	// The updated name.
	Name *string `min:"3" type:"string"`

	// The updated owner.
	OwnerInformation *string `min:"1" type:"string"`

	// The updated targets.
	Targets []Target `type:"list"`

	// The Maintenance Window ID specified in the update request.
	WindowId *string `min:"20" type:"string"`

	// The target ID specified in the update request.
	WindowTargetId *string `min:"36" type:"string"`
}

// String returns the string representation
func (s UpdateMaintenanceWindowTargetOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateMaintenanceWindowTarget = "UpdateMaintenanceWindowTarget"

// UpdateMaintenanceWindowTargetRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Modifies the target of an existing Maintenance Window. You can't change the
// target type, but you can change the following:
//
// The target from being an ID target to a Tag target, or a Tag target to an
// ID target.
//
// IDs for an ID target.
//
// Tags for a Tag target.
//
// Owner.
//
// Name.
//
// Description.
//
// If a parameter is null, then the corresponding field is not modified.
//
//    // Example sending a request using UpdateMaintenanceWindowTargetRequest.
//    req := client.UpdateMaintenanceWindowTargetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget
func (c *Client) UpdateMaintenanceWindowTargetRequest(input *UpdateMaintenanceWindowTargetInput) UpdateMaintenanceWindowTargetRequest {
	op := &aws.Operation{
		Name:       opUpdateMaintenanceWindowTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceWindowTargetInput{}
	}

	req := c.newRequest(op, input, &UpdateMaintenanceWindowTargetOutput{})
	return UpdateMaintenanceWindowTargetRequest{Request: req, Input: input, Copy: c.UpdateMaintenanceWindowTargetRequest}
}

// UpdateMaintenanceWindowTargetRequest is the request type for the
// UpdateMaintenanceWindowTarget API operation.
type UpdateMaintenanceWindowTargetRequest struct {
	*aws.Request
	Input *UpdateMaintenanceWindowTargetInput
	Copy  func(*UpdateMaintenanceWindowTargetInput) UpdateMaintenanceWindowTargetRequest
}

// Send marshals and sends the UpdateMaintenanceWindowTarget API request.
func (r UpdateMaintenanceWindowTargetRequest) Send(ctx context.Context) (*UpdateMaintenanceWindowTargetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateMaintenanceWindowTargetResponse{
		UpdateMaintenanceWindowTargetOutput: r.Request.Data.(*UpdateMaintenanceWindowTargetOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateMaintenanceWindowTargetResponse is the response type for the
// UpdateMaintenanceWindowTarget API operation.
type UpdateMaintenanceWindowTargetResponse struct {
	*UpdateMaintenanceWindowTargetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateMaintenanceWindowTarget request.
func (r *UpdateMaintenanceWindowTargetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
