// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A JSON object containing one or more of the following fields:
//
//    * UpdateSnapshotScheduleInput$Description
//
//    * UpdateSnapshotScheduleInput$RecurrenceInHours
//
//    * UpdateSnapshotScheduleInput$StartAt
//
//    * UpdateSnapshotScheduleInput$VolumeARN
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotScheduleInput
type UpdateSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// Optional description of the snapshot that overwrites the existing description.
	Description *string `min:"1" type:"string"`

	// Frequency of snapshots. Specify the number of hours between snapshots.
	//
	// RecurrenceInHours is a required field
	RecurrenceInHours *int64 `min:"1" type:"integer" required:"true"`

	// The hour of the day at which the snapshot schedule begins represented as
	// hh, where hh is the hour (0 to 23). The hour of the day is in the time zone
	// of the gateway.
	//
	// StartAt is a required field
	StartAt *int64 `type:"integer" required:"true"`

	// A list of up to 50 tags that can be assigned to a snapshot. Each tag is a
	// key-value pair.
	//
	// Valid characters for key and value are letters, spaces, and numbers representable
	// in UTF-8 format, and the following special characters: + - = . _ : / @. The
	// maximum length of a tag's key is 128 characters, and the maximum length for
	// a tag's value is 256.
	Tags []Tag `type:"list"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	//
	// VolumeARN is a required field
	VolumeARN *string `min:"50" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSnapshotScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSnapshotScheduleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.RecurrenceInHours == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecurrenceInHours"))
	}
	if s.RecurrenceInHours != nil && *s.RecurrenceInHours < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("RecurrenceInHours", 1))
	}

	if s.StartAt == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartAt"))
	}

	if s.VolumeARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeARN"))
	}
	if s.VolumeARN != nil && len(*s.VolumeARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("VolumeARN", 50))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the of the updated storage volume.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotScheduleOutput
type UpdateSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	VolumeARN *string `min:"50" type:"string"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateSnapshotSchedule = "UpdateSnapshotSchedule"

// UpdateSnapshotScheduleRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Updates a snapshot schedule configured for a gateway volume. This operation
// is only supported in the cached volume and stored volume gateway types.
//
// The default snapshot schedule for volume is once every 24 hours, starting
// at the creation time of the volume. You can use this API to change the snapshot
// schedule configured for the volume.
//
// In the request you must identify the gateway volume whose snapshot schedule
// you want to update, and the schedule information, including when you want
// the snapshot to begin on a day and the frequency (in hours) of snapshots.
//
//    // Example sending a request using UpdateSnapshotScheduleRequest.
//    req := client.UpdateSnapshotScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/UpdateSnapshotSchedule
func (c *Client) UpdateSnapshotScheduleRequest(input *UpdateSnapshotScheduleInput) UpdateSnapshotScheduleRequest {
	op := &aws.Operation{
		Name:       opUpdateSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSnapshotScheduleInput{}
	}

	req := c.newRequest(op, input, &UpdateSnapshotScheduleOutput{})
	return UpdateSnapshotScheduleRequest{Request: req, Input: input, Copy: c.UpdateSnapshotScheduleRequest}
}

// UpdateSnapshotScheduleRequest is the request type for the
// UpdateSnapshotSchedule API operation.
type UpdateSnapshotScheduleRequest struct {
	*aws.Request
	Input *UpdateSnapshotScheduleInput
	Copy  func(*UpdateSnapshotScheduleInput) UpdateSnapshotScheduleRequest
}

// Send marshals and sends the UpdateSnapshotSchedule API request.
func (r UpdateSnapshotScheduleRequest) Send(ctx context.Context) (*UpdateSnapshotScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSnapshotScheduleResponse{
		UpdateSnapshotScheduleOutput: r.Request.Data.(*UpdateSnapshotScheduleOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSnapshotScheduleResponse is the response type for the
// UpdateSnapshotSchedule API operation.
type UpdateSnapshotScheduleResponse struct {
	*UpdateSnapshotScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSnapshotSchedule request.
func (r *UpdateSnapshotScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
