// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACLRequest
type DisassociateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource from which the web ACL is
	// being removed, either an application load balancer or Amazon API Gateway
	// stage.
	//
	// The ARN should be in one of the following formats:
	//
	//    * For an Application Load Balancer: arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id
	//
	//    * For an Amazon API Gateway stage: arn:aws:apigateway:region::/restapis/api-id/stages/stage-name
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWebACLInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateWebACLInput"}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACLResponse
type DisassociateWebACLOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateWebACL = "DisassociateWebACL"

// DisassociateWebACLRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Removes a web ACL from the specified resource, either an application load
// balancer or Amazon API Gateway stage.
//
//    // Example sending a request using DisassociateWebACLRequest.
//    req := client.DisassociateWebACLRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DisassociateWebACL
func (c *Client) DisassociateWebACLRequest(input *DisassociateWebACLInput) DisassociateWebACLRequest {
	op := &aws.Operation{
		Name:       opDisassociateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateWebACLInput{}
	}

	req := c.newRequest(op, input, &DisassociateWebACLOutput{})
	return DisassociateWebACLRequest{Request: req, Input: input, Copy: c.DisassociateWebACLRequest}
}

// DisassociateWebACLRequest is the request type for the
// DisassociateWebACL API operation.
type DisassociateWebACLRequest struct {
	*aws.Request
	Input *DisassociateWebACLInput
	Copy  func(*DisassociateWebACLInput) DisassociateWebACLRequest
}

// Send marshals and sends the DisassociateWebACL API request.
func (r DisassociateWebACLRequest) Send(ctx context.Context) (*DisassociateWebACLResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateWebACLResponse{
		DisassociateWebACLOutput: r.Request.Data.(*DisassociateWebACLOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateWebACLResponse is the response type for the
// DisassociateWebACL API operation.
type DisassociateWebACLResponse struct {
	*DisassociateWebACLOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateWebACL request.
func (r *DisassociateWebACLResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
