// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The summary of devices.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeviceSummary
type DeviceSummary struct {
	_ struct{} `type:"structure"`

	// The ID of the device.
	DeviceId *string `min:"1" type:"string"`

	// The status of the device.
	DeviceStatus DeviceStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s DeviceSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeviceSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DeviceStatus) > 0 {
		v := s.DeviceStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The summary of the domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DomainSummary
type DomainSummary struct {
	_ struct{} `type:"structure"`

	// The time that the domain was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The status of the domain.
	//
	// DomainStatus is a required field
	DomainStatus DomainStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DomainSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DomainStatus) > 0 {
		v := s.DomainStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The summary of the fleet.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/FleetSummary
type FleetSummary struct {
	_ struct{} `type:"structure"`

	// The identifier used by users to sign into the Amazon WorkLink app.
	CompanyCode *string `min:"1" type:"string"`

	// The time when the fleet was created.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The ARN of the fleet.
	FleetArn *string `min:"20" type:"string"`

	// The name of the fleet.
	FleetName *string `min:"1" type:"string"`

	// The status of the fleet.
	FleetStatus FleetStatus `type:"string" enum:"true"`

	// The time when the fleet was last updated.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s FleetSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FleetSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CompanyCode != nil {
		v := *s.CompanyCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompanyCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FleetName != nil {
		v := *s.FleetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.FleetStatus) > 0 {
		v := s.FleetStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastUpdatedTime != nil {
		v := *s.LastUpdatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// The summary of the website authorization provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/WebsiteAuthorizationProviderSummary
type WebsiteAuthorizationProviderSummary struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the authorization provider.
	AuthorizationProviderId *string `min:"1" type:"string"`

	// The authorization provider type.
	//
	// AuthorizationProviderType is a required field
	AuthorizationProviderType AuthorizationProviderType `type:"string" required:"true" enum:"true"`

	// The time of creation.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The domain name of the authorization provider. This applies only to SAML-based
	// authorization providers.
	DomainName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WebsiteAuthorizationProviderSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WebsiteAuthorizationProviderSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizationProviderId != nil {
		v := *s.AuthorizationProviderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AuthorizationProviderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AuthorizationProviderType) > 0 {
		v := s.AuthorizationProviderType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AuthorizationProviderType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The summary of the certificate authority (CA).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/WebsiteCaSummary
type WebsiteCaSummary struct {
	_ struct{} `type:"structure"`

	// The time when the CA was added.
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name to display.
	DisplayName *string `type:"string"`

	// A unique identifier for the CA.
	WebsiteCaId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WebsiteCaSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s WebsiteCaSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedTime != nil {
		v := *s.CreatedTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WebsiteCaId != nil {
		v := *s.WebsiteCaId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebsiteCaId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
