// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroupRequest
type AssociateSkillWithSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill group to associate the skill to. Required.
	SkillGroupArn *string `type:"string"`

	// The unique identifier of the skill.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateSkillWithSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSkillWithSkillGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateSkillWithSkillGroupInput"}

	if s.SkillId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroupResponse
type AssociateSkillWithSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateSkillWithSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateSkillWithSkillGroup = "AssociateSkillWithSkillGroup"

// AssociateSkillWithSkillGroupRequest returns a request value for making API operation for
// Alexa For Business.
//
// Associates a skill with a skill group.
//
//    // Example sending a request using AssociateSkillWithSkillGroupRequest.
//    req := client.AssociateSkillWithSkillGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateSkillWithSkillGroup
func (c *Client) AssociateSkillWithSkillGroupRequest(input *AssociateSkillWithSkillGroupInput) AssociateSkillWithSkillGroupRequest {
	op := &aws.Operation{
		Name:       opAssociateSkillWithSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateSkillWithSkillGroupInput{}
	}

	req := c.newRequest(op, input, &AssociateSkillWithSkillGroupOutput{})
	return AssociateSkillWithSkillGroupRequest{Request: req, Input: input, Copy: c.AssociateSkillWithSkillGroupRequest}
}

// AssociateSkillWithSkillGroupRequest is the request type for the
// AssociateSkillWithSkillGroup API operation.
type AssociateSkillWithSkillGroupRequest struct {
	*aws.Request
	Input *AssociateSkillWithSkillGroupInput
	Copy  func(*AssociateSkillWithSkillGroupInput) AssociateSkillWithSkillGroupRequest
}

// Send marshals and sends the AssociateSkillWithSkillGroup API request.
func (r AssociateSkillWithSkillGroupRequest) Send(ctx context.Context) (*AssociateSkillWithSkillGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateSkillWithSkillGroupResponse{
		AssociateSkillWithSkillGroupOutput: r.Request.Data.(*AssociateSkillWithSkillGroupOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateSkillWithSkillGroupResponse is the response type for the
// AssociateSkillWithSkillGroup API operation.
type AssociateSkillWithSkillGroupResponse struct {
	*AssociateSkillWithSkillGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateSkillWithSkillGroup request.
func (r *AssociateSkillWithSkillGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
