// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroupRequest
type DeleteSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the skill group to delete. Required.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s DeleteSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroupResponse
type DeleteSkillGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSkillGroup = "DeleteSkillGroup"

// DeleteSkillGroupRequest returns a request value for making API operation for
// Alexa For Business.
//
// Deletes a skill group by skill group ARN.
//
//    // Example sending a request using DeleteSkillGroupRequest.
//    req := client.DeleteSkillGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteSkillGroup
func (c *Client) DeleteSkillGroupRequest(input *DeleteSkillGroupInput) DeleteSkillGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSkillGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteSkillGroupOutput{})
	return DeleteSkillGroupRequest{Request: req, Input: input, Copy: c.DeleteSkillGroupRequest}
}

// DeleteSkillGroupRequest is the request type for the
// DeleteSkillGroup API operation.
type DeleteSkillGroupRequest struct {
	*aws.Request
	Input *DeleteSkillGroupInput
	Copy  func(*DeleteSkillGroupInput) DeleteSkillGroupRequest
}

// Send marshals and sends the DeleteSkillGroup API request.
func (r DeleteSkillGroupRequest) Send(ctx context.Context) (*DeleteSkillGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSkillGroupResponse{
		DeleteSkillGroupOutput: r.Request.Data.(*DeleteSkillGroupOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSkillGroupResponse is the response type for the
// DeleteSkillGroup API operation.
type DeleteSkillGroupResponse struct {
	*DeleteSkillGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSkillGroup request.
func (r *DeleteSkillGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
