// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package autoscaling

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollectionQuery
type EnableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The granularity to associate with the metrics to collect. The only valid
	// value is 1Minute.
	//
	// Granularity is a required field
	Granularity *string `min:"1" type:"string" required:"true"`

	// One or more of the following metrics. If you omit this parameter, all metrics
	// are enabled.
	//
	//    * GroupMinSize
	//
	//    * GroupMaxSize
	//
	//    * GroupDesiredCapacity
	//
	//    * GroupInServiceInstances
	//
	//    * GroupPendingInstances
	//
	//    * GroupStandbyInstances
	//
	//    * GroupTerminatingInstances
	//
	//    * GroupTotalInstances
	Metrics []string `type:"list"`
}

// String returns the string representation
func (s EnableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableMetricsCollectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableMetricsCollectionInput"}

	if s.AutoScalingGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if s.Granularity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Granularity"))
	}
	if s.Granularity != nil && len(*s.Granularity) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Granularity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollectionOutput
type EnableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableMetricsCollection = "EnableMetricsCollection"

// EnableMetricsCollectionRequest returns a request value for making API operation for
// Auto Scaling.
//
// Enables group metrics for the specified Auto Scaling group. For more information,
// see Monitoring Your Auto Scaling Groups and Instances (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html)
// in the Amazon EC2 Auto Scaling User Guide.
//
//    // Example sending a request using EnableMetricsCollectionRequest.
//    req := client.EnableMetricsCollectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection
func (c *Client) EnableMetricsCollectionRequest(input *EnableMetricsCollectionInput) EnableMetricsCollectionRequest {
	op := &aws.Operation{
		Name:       opEnableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableMetricsCollectionInput{}
	}

	req := c.newRequest(op, input, &EnableMetricsCollectionOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return EnableMetricsCollectionRequest{Request: req, Input: input, Copy: c.EnableMetricsCollectionRequest}
}

// EnableMetricsCollectionRequest is the request type for the
// EnableMetricsCollection API operation.
type EnableMetricsCollectionRequest struct {
	*aws.Request
	Input *EnableMetricsCollectionInput
	Copy  func(*EnableMetricsCollectionInput) EnableMetricsCollectionRequest
}

// Send marshals and sends the EnableMetricsCollection API request.
func (r EnableMetricsCollectionRequest) Send(ctx context.Context) (*EnableMetricsCollectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableMetricsCollectionResponse{
		EnableMetricsCollectionOutput: r.Request.Data.(*EnableMetricsCollectionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableMetricsCollectionResponse is the response type for the
// EnableMetricsCollection API operation.
type EnableMetricsCollectionResponse struct {
	*EnableMetricsCollectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableMetricsCollection request.
func (r *EnableMetricsCollectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
