// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request to get a streaming distribution's information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/GetStreamingDistributionRequest
type GetStreamingDistributionInput struct {
	_ struct{} `type:"structure"`

	// The streaming distribution's ID.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStreamingDistributionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetStreamingDistributionInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetStreamingDistributionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	return nil
}

// The returned result of the corresponding request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/GetStreamingDistributionResult
type GetStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the streaming distribution's information. For example:
	// E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s GetStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetStreamingDistributionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.StreamingDistribution != nil {
		v := s.StreamingDistribution

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "StreamingDistribution", v, metadata)
	}
	return nil
}

const opGetStreamingDistribution = "GetStreamingDistribution2018_11_05"

// GetStreamingDistributionRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Gets information about a specified RTMP distribution, including the distribution
// configuration.
//
//    // Example sending a request using GetStreamingDistributionRequest.
//    req := client.GetStreamingDistributionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/GetStreamingDistribution
func (c *Client) GetStreamingDistributionRequest(input *GetStreamingDistributionInput) GetStreamingDistributionRequest {
	op := &aws.Operation{
		Name:       opGetStreamingDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-11-05/streaming-distribution/{Id}",
	}

	if input == nil {
		input = &GetStreamingDistributionInput{}
	}

	req := c.newRequest(op, input, &GetStreamingDistributionOutput{})
	return GetStreamingDistributionRequest{Request: req, Input: input, Copy: c.GetStreamingDistributionRequest}
}

// GetStreamingDistributionRequest is the request type for the
// GetStreamingDistribution API operation.
type GetStreamingDistributionRequest struct {
	*aws.Request
	Input *GetStreamingDistributionInput
	Copy  func(*GetStreamingDistributionInput) GetStreamingDistributionRequest
}

// Send marshals and sends the GetStreamingDistribution API request.
func (r GetStreamingDistributionRequest) Send(ctx context.Context) (*GetStreamingDistributionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetStreamingDistributionResponse{
		GetStreamingDistributionOutput: r.Request.Data.(*GetStreamingDistributionOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetStreamingDistributionResponse is the response type for the
// GetStreamingDistribution API operation.
type GetStreamingDistributionResponse struct {
	*GetStreamingDistributionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetStreamingDistribution request.
func (r *GetStreamingDistributionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
