// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudfront

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The request to update a streaming distribution.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/UpdateStreamingDistributionRequest
type UpdateStreamingDistributionInput struct {
	_ struct{} `type:"structure" payload:"StreamingDistributionConfig"`

	// The streaming distribution's id.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The value of the ETag header that you received when retrieving the streaming
	// distribution's configuration. For example: E2QWRUHAPOMQZL.
	IfMatch *string `location:"header" locationName:"If-Match" type:"string"`

	// The streaming distribution's configuration information.
	//
	// StreamingDistributionConfig is a required field
	StreamingDistributionConfig *StreamingDistributionConfig `locationName:"StreamingDistributionConfig" type:"structure" required:"true" xmlURI:"http://cloudfront.amazonaws.com/doc/2018-11-05/"`
}

// String returns the string representation
func (s UpdateStreamingDistributionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStreamingDistributionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateStreamingDistributionInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.StreamingDistributionConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamingDistributionConfig"))
	}
	if s.StreamingDistributionConfig != nil {
		if err := s.StreamingDistributionConfig.Validate(); err != nil {
			invalidParams.AddNested("StreamingDistributionConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateStreamingDistributionInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.IfMatch != nil {
		v := *s.IfMatch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "If-Match", protocol.StringValue(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.StringValue(v), metadata)
	}
	if s.StreamingDistributionConfig != nil {
		v := s.StreamingDistributionConfig

		metadata := protocol.Metadata{XMLNamespaceURI: "http://cloudfront.amazonaws.com/doc/2018-11-05/"}
		e.SetFields(protocol.PayloadTarget, "StreamingDistributionConfig", v, metadata)
	}
	return nil
}

// The returned result of the corresponding request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/UpdateStreamingDistributionResult
type UpdateStreamingDistributionOutput struct {
	_ struct{} `type:"structure" payload:"StreamingDistribution"`

	// The current version of the configuration. For example: E2QWRUHAPOMQZL.
	ETag *string `location:"header" locationName:"ETag" type:"string"`

	// The streaming distribution's information.
	StreamingDistribution *StreamingDistribution `type:"structure"`
}

// String returns the string representation
func (s UpdateStreamingDistributionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateStreamingDistributionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ETag != nil {
		v := *s.ETag

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "ETag", protocol.StringValue(v), metadata)
	}
	if s.StreamingDistribution != nil {
		v := s.StreamingDistribution

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "StreamingDistribution", v, metadata)
	}
	return nil
}

const opUpdateStreamingDistribution = "UpdateStreamingDistribution2018_11_05"

// UpdateStreamingDistributionRequest returns a request value for making API operation for
// Amazon CloudFront.
//
// Update a streaming distribution.
//
//    // Example sending a request using UpdateStreamingDistributionRequest.
//    req := client.UpdateStreamingDistributionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2018-11-05/UpdateStreamingDistribution
func (c *Client) UpdateStreamingDistributionRequest(input *UpdateStreamingDistributionInput) UpdateStreamingDistributionRequest {
	op := &aws.Operation{
		Name:       opUpdateStreamingDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/2018-11-05/streaming-distribution/{Id}/config",
	}

	if input == nil {
		input = &UpdateStreamingDistributionInput{}
	}

	req := c.newRequest(op, input, &UpdateStreamingDistributionOutput{})
	return UpdateStreamingDistributionRequest{Request: req, Input: input, Copy: c.UpdateStreamingDistributionRequest}
}

// UpdateStreamingDistributionRequest is the request type for the
// UpdateStreamingDistribution API operation.
type UpdateStreamingDistributionRequest struct {
	*aws.Request
	Input *UpdateStreamingDistributionInput
	Copy  func(*UpdateStreamingDistributionInput) UpdateStreamingDistributionRequest
}

// Send marshals and sends the UpdateStreamingDistribution API request.
func (r UpdateStreamingDistributionRequest) Send(ctx context.Context) (*UpdateStreamingDistributionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateStreamingDistributionResponse{
		UpdateStreamingDistributionOutput: r.Request.Data.(*UpdateStreamingDistributionOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateStreamingDistributionResponse is the response type for the
// UpdateStreamingDistribution API operation.
type UpdateStreamingDistributionResponse struct {
	*UpdateStreamingDistributionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateStreamingDistribution request.
func (r *UpdateStreamingDistributionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
