// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearchdomain

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// A container for facet information.
type Bucket struct {
	_ struct{} `type:"structure"`

	// The number of hits that contain the facet value in the specified facet field.
	Count *int64 `locationName:"count" type:"long"`

	// The facet value being counted.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Bucket) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Bucket) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A container for the calculated facet values and counts.
type BucketInfo struct {
	_ struct{} `type:"structure"`

	// A list of the calculated facet values and counts.
	Buckets []Bucket `locationName:"buckets" type:"list"`
}

// String returns the string representation
func (s BucketInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BucketInfo) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Buckets) > 0 {
		v := s.Buckets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "buckets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// A warning returned by the document service when an issue is discovered while
// processing an upload request.
type DocumentServiceWarning struct {
	_ struct{} `type:"structure"`

	// The description for a warning returned by the document service.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DocumentServiceWarning) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DocumentServiceWarning) MarshalFields(e protocol.FieldEncoder) error {
	if s.Message != nil {
		v := *s.Message

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "message", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The statistics for a field calculated in the request.
type FieldStats struct {
	_ struct{} `type:"structure"`

	// The number of documents that contain a value in the specified field in the
	// result set.
	Count *int64 `locationName:"count" type:"long"`

	// The maximum value found in the specified field in the result set.
	//
	// If the field is numeric (int, int-array, double, or double-array), max is
	// the string representation of a double-precision 64-bit floating point value.
	// If the field is date or date-array, max is the string representation of a
	// date with the format specified in IETF RFC3339 (http://tools.ietf.org/html/rfc3339):
	// yyyy-mm-ddTHH:mm:ss.SSSZ.
	Max *string `locationName:"max" type:"string"`

	// The average of the values found in the specified field in the result set.
	//
	// If the field is numeric (int, int-array, double, or double-array), mean is
	// the string representation of a double-precision 64-bit floating point value.
	// If the field is date or date-array, mean is the string representation of
	// a date with the format specified in IETF RFC3339 (http://tools.ietf.org/html/rfc3339):
	// yyyy-mm-ddTHH:mm:ss.SSSZ.
	Mean *string `locationName:"mean" type:"string"`

	// The minimum value found in the specified field in the result set.
	//
	// If the field is numeric (int, int-array, double, or double-array), min is
	// the string representation of a double-precision 64-bit floating point value.
	// If the field is date or date-array, min is the string representation of a
	// date with the format specified in IETF RFC3339 (http://tools.ietf.org/html/rfc3339):
	// yyyy-mm-ddTHH:mm:ss.SSSZ.
	Min *string `locationName:"min" type:"string"`

	// The number of documents that do not contain a value in the specified field
	// in the result set.
	Missing *int64 `locationName:"missing" type:"long"`

	// The standard deviation of the values in the specified field in the result
	// set.
	Stddev *float64 `locationName:"stddev" type:"double"`

	// The sum of the field values across the documents in the result set. null
	// for date fields.
	Sum *float64 `locationName:"sum" type:"double"`

	// The sum of all field values in the result set squared.
	SumOfSquares *float64 `locationName:"sumOfSquares" type:"double"`
}

// String returns the string representation
func (s FieldStats) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FieldStats) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.Max != nil {
		v := *s.Max

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "max", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Mean != nil {
		v := *s.Mean

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "mean", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Min != nil {
		v := *s.Min

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "min", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Missing != nil {
		v := *s.Missing

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "missing", protocol.Int64Value(v), metadata)
	}
	if s.Stddev != nil {
		v := *s.Stddev

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stddev", protocol.Float64Value(v), metadata)
	}
	if s.Sum != nil {
		v := *s.Sum

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sum", protocol.Float64Value(v), metadata)
	}
	if s.SumOfSquares != nil {
		v := *s.SumOfSquares

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sumOfSquares", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Information about a document that matches the search request.
type Hit struct {
	_ struct{} `type:"structure"`

	// The expressions returned from a document that matches the search request.
	Exprs map[string]string `locationName:"exprs" type:"map"`

	// The fields returned from a document that matches the search request.
	Fields map[string][]string `locationName:"fields" type:"map"`

	// The highlights returned from a document that matches the search request.
	Highlights map[string]string `locationName:"highlights" type:"map"`

	// The document ID of a document that matches the search request.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s Hit) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Hit) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Exprs) > 0 {
		v := s.Exprs

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "exprs", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.Fields) > 0 {
		v := s.Fields

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "fields", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if len(s.Highlights) > 0 {
		v := s.Highlights

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "highlights", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The collection of documents that match the search request.
type Hits struct {
	_ struct{} `type:"structure"`

	// A cursor that can be used to retrieve the next set of matching documents
	// when you want to page through a large result set.
	Cursor *string `locationName:"cursor" type:"string"`

	// The total number of documents that match the search request.
	Found *int64 `locationName:"found" type:"long"`

	// A document that matches the search request.
	Hit []Hit `locationName:"hit" type:"list"`

	// The index of the first matching document.
	Start *int64 `locationName:"start" type:"long"`
}

// String returns the string representation
func (s Hits) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Hits) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cursor != nil {
		v := *s.Cursor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cursor", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Found != nil {
		v := *s.Found

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "found", protocol.Int64Value(v), metadata)
	}
	if len(s.Hit) > 0 {
		v := s.Hit

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "hit", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "start", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Contains the resource id (rid) and the time it took to process the request
// (timems).
type SearchStatus struct {
	_ struct{} `type:"structure"`

	// The encrypted resource ID for the request.
	Rid *string `locationName:"rid" type:"string"`

	// How long it took to process the request, in milliseconds.
	Timems *int64 `locationName:"timems" type:"long"`
}

// String returns the string representation
func (s SearchStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SearchStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rid != nil {
		v := *s.Rid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timems != nil {
		v := *s.Timems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Container for the suggestion information returned in a SuggestResponse.
type SuggestModel struct {
	_ struct{} `type:"structure"`

	// The number of documents that were found to match the query string.
	Found *int64 `locationName:"found" type:"long"`

	// The query string specified in the suggest request.
	Query *string `locationName:"query" type:"string"`

	// The documents that match the query string.
	Suggestions []SuggestionMatch `locationName:"suggestions" type:"list"`
}

// String returns the string representation
func (s SuggestModel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SuggestModel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Found != nil {
		v := *s.Found

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "found", protocol.Int64Value(v), metadata)
	}
	if s.Query != nil {
		v := *s.Query

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "query", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Suggestions) > 0 {
		v := s.Suggestions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "suggestions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Contains the resource id (rid) and the time it took to process the request
// (timems).
type SuggestStatus struct {
	_ struct{} `type:"structure"`

	// The encrypted resource ID for the request.
	Rid *string `locationName:"rid" type:"string"`

	// How long it took to process the request, in milliseconds.
	Timems *int64 `locationName:"timems" type:"long"`
}

// String returns the string representation
func (s SuggestStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SuggestStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Rid != nil {
		v := *s.Rid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "rid", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timems != nil {
		v := *s.Timems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An autocomplete suggestion that matches the query string specified in a SuggestRequest.
type SuggestionMatch struct {
	_ struct{} `type:"structure"`

	// The document ID of the suggested document.
	Id *string `locationName:"id" type:"string"`

	// The relevance score of a suggested match.
	Score *int64 `locationName:"score" type:"long"`

	// The string that matches the query string specified in the SuggestRequest.
	Suggestion *string `locationName:"suggestion" type:"string"`
}

// String returns the string representation
func (s SuggestionMatch) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SuggestionMatch) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Score != nil {
		v := *s.Score

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "score", protocol.Int64Value(v), metadata)
	}
	if s.Suggestion != nil {
		v := *s.Suggestion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "suggestion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
