// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflictsInput
type GetMergeConflictsInput struct {
	_ struct{} `type:"structure"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit. For example, a branch name or a full commit ID.
	//
	// DestinationCommitSpecifier is a required field
	DestinationCommitSpecifier *string `locationName:"destinationCommitSpecifier" type:"string" required:"true"`

	// The merge option or strategy you want to use to merge the code. The only
	// valid value is FAST_FORWARD_MERGE.
	//
	// MergeOption is a required field
	MergeOption MergeOptionTypeEnum `locationName:"mergeOption" type:"string" required:"true" enum:"true"`

	// The name of the repository where the pull request was created.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit. For example, a branch name or a full commit ID.
	//
	// SourceCommitSpecifier is a required field
	SourceCommitSpecifier *string `locationName:"sourceCommitSpecifier" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMergeConflictsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMergeConflictsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMergeConflictsInput"}

	if s.DestinationCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationCommitSpecifier"))
	}
	if len(s.MergeOption) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MergeOption"))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if s.SourceCommitSpecifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceCommitSpecifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflictsOutput
type GetMergeConflictsOutput struct {
	_ struct{} `type:"structure"`

	// The commit ID of the destination commit specifier that was used in the merge
	// evaluation.
	//
	// DestinationCommitId is a required field
	DestinationCommitId *string `locationName:"destinationCommitId" type:"string" required:"true"`

	// A Boolean value that indicates whether the code is mergable by the specified
	// merge option.
	//
	// Mergeable is a required field
	Mergeable *bool `locationName:"mergeable" type:"boolean" required:"true"`

	// The commit ID of the source commit specifier that was used in the merge evaluation.
	//
	// SourceCommitId is a required field
	SourceCommitId *string `locationName:"sourceCommitId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMergeConflictsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMergeConflicts = "GetMergeConflicts"

// GetMergeConflictsRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Returns information about merge conflicts between the before and after commit
// IDs for a pull request in a repository.
//
//    // Example sending a request using GetMergeConflictsRequest.
//    req := client.GetMergeConflictsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts
func (c *Client) GetMergeConflictsRequest(input *GetMergeConflictsInput) GetMergeConflictsRequest {
	op := &aws.Operation{
		Name:       opGetMergeConflicts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMergeConflictsInput{}
	}

	req := c.newRequest(op, input, &GetMergeConflictsOutput{})
	return GetMergeConflictsRequest{Request: req, Input: input, Copy: c.GetMergeConflictsRequest}
}

// GetMergeConflictsRequest is the request type for the
// GetMergeConflicts API operation.
type GetMergeConflictsRequest struct {
	*aws.Request
	Input *GetMergeConflictsInput
	Copy  func(*GetMergeConflictsInput) GetMergeConflictsRequest
}

// Send marshals and sends the GetMergeConflicts API request.
func (r GetMergeConflictsRequest) Send(ctx context.Context) (*GetMergeConflictsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMergeConflictsResponse{
		GetMergeConflictsOutput: r.Request.Data.(*GetMergeConflictsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMergeConflictsResponse is the response type for the
// GetMergeConflicts API operation.
type GetMergeConflictsResponse struct {
	*GetMergeConflictsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMergeConflicts request.
func (r *GetMergeConflictsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
