// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to UnsubscribeFromDataset.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UnsubscribeFromDatasetRequest
type UnsubscribeFromDatasetInput struct {
	_ struct{} `type:"structure"`

	// The name of the dataset from which to unsubcribe.
	//
	// DatasetName is a required field
	DatasetName *string `location:"uri" locationName:"DatasetName" min:"1" type:"string" required:"true"`

	// The unique ID generated for this device by Cognito.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// Unique ID for this identity.
	//
	// IdentityId is a required field
	IdentityId *string `location:"uri" locationName:"IdentityId" min:"1" type:"string" required:"true"`

	// A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE)
	// created by Amazon Cognito. The ID of the pool to which this identity belongs.
	//
	// IdentityPoolId is a required field
	IdentityPoolId *string `location:"uri" locationName:"IdentityPoolId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UnsubscribeFromDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnsubscribeFromDatasetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnsubscribeFromDatasetInput"}

	if s.DatasetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatasetName", 1))
	}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeviceId", 1))
	}

	if s.IdentityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityId", 1))
	}

	if s.IdentityPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityPoolId"))
	}
	if s.IdentityPoolId != nil && len(*s.IdentityPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnsubscribeFromDatasetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DatasetName != nil {
		v := *s.DatasetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DatasetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DeviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityId != nil {
		v := *s.IdentityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "IdentityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentityPoolId != nil {
		v := *s.IdentityPoolId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "IdentityPoolId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Response to an UnsubscribeFromDataset request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UnsubscribeFromDatasetResponse
type UnsubscribeFromDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeFromDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnsubscribeFromDatasetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUnsubscribeFromDataset = "UnsubscribeFromDataset"

// UnsubscribeFromDatasetRequest returns a request value for making API operation for
// Amazon Cognito Sync.
//
// Unsubscribes from receiving notifications when a dataset is modified by another
// device.
//
// This API can only be called with temporary credentials provided by Cognito
// Identity. You cannot call this API with developer credentials.
//
//    // Example sending a request using UnsubscribeFromDatasetRequest.
//    req := client.UnsubscribeFromDatasetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/UnsubscribeFromDataset
func (c *Client) UnsubscribeFromDatasetRequest(input *UnsubscribeFromDatasetInput) UnsubscribeFromDatasetRequest {
	op := &aws.Operation{
		Name:       opUnsubscribeFromDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}",
	}

	if input == nil {
		input = &UnsubscribeFromDatasetInput{}
	}

	req := c.newRequest(op, input, &UnsubscribeFromDatasetOutput{})
	return UnsubscribeFromDatasetRequest{Request: req, Input: input, Copy: c.UnsubscribeFromDatasetRequest}
}

// UnsubscribeFromDatasetRequest is the request type for the
// UnsubscribeFromDataset API operation.
type UnsubscribeFromDatasetRequest struct {
	*aws.Request
	Input *UnsubscribeFromDatasetInput
	Copy  func(*UnsubscribeFromDatasetInput) UnsubscribeFromDatasetRequest
}

// Send marshals and sends the UnsubscribeFromDataset API request.
func (r UnsubscribeFromDatasetRequest) Send(ctx context.Context) (*UnsubscribeFromDatasetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnsubscribeFromDatasetResponse{
		UnsubscribeFromDatasetOutput: r.Request.Data.(*UnsubscribeFromDatasetOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnsubscribeFromDatasetResponse is the response type for the
// UnsubscribeFromDataset API operation.
type UnsubscribeFromDatasetResponse struct {
	*UnsubscribeFromDatasetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnsubscribeFromDataset request.
func (r *UnsubscribeFromDatasetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
