// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataRequest
type GetMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The timestamp, in UNIX Epoch time format, at which to end the reporting interval
	// for the retrieval of historical metrics data. The time must be specified
	// using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be
	// later than the StartTime timestamp.
	//
	// The time range between StartTime and EndTime must be less than 24 hours.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// A Filters object that contains a list of queue IDs or queue ARNs, up to 100,
	// or a list of Channels to use to filter the metrics returned in the response.
	// Metric data is retrieved only for the resources associated with the IDs,
	// ARNs, or Channels included in the filter. You can use both IDs and ARNs together
	// in a request. Only VOICE is supported for Channel.
	//
	// To find the ARN for a queue, open the queue you want to use in the Amazon
	// Connect Queue editor. The ARN for the queue is displayed in the address bar
	// as part of the URL. For example, the queue ARN is the set of characters at
	// the end of the URL, after 'id=' such as arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61.
	// The queue ID is also included in the URL, and is the string after 'queue/'.
	//
	// Filters is a required field
	Filters *Filters `type:"structure" required:"true"`

	// The grouping applied to the metrics returned. For example, when results are
	// grouped by queueId, the metrics returned are grouped by queue. The values
	// returned apply to the metrics for each queue rather than aggregated for all
	// queues.
	//
	// The current version supports grouping by Queue
	//
	// If no Grouping is included in the request, a summary of HistoricalMetrics
	// for all queues is returned.
	Groupings []Grouping `type:"list"`

	// A list of HistoricalMetric objects that contain the metrics to retrieve with
	// the request.
	//
	// A HistoricalMetric object contains: HistoricalMetricName, Statistic, Threshold,
	// and Unit.
	//
	// You must list each metric to retrieve data for in the request. For each historical
	// metric you include in the request, you must include a Unit and a Statistic.
	//
	// The following historical metrics are available:
	//
	// CONTACTS_QUEUED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_ABANDONED
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_CONSULTED
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_AGENT_HUNG_UP_FIRST
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_HANDLED_INCOMING
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_HANDLED_OUTBOUND
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_HOLD_ABANDONS
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_IN
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_OUT
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_IN_FROM_QUEUE
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CALLBACK_CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CALLBACK_CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// API_CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// CONTACTS_MISSED
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// OCCUPANCY
	//
	// Unit: PERCENT
	//
	// Statistics: AVG
	//
	// HANDLE_TIME
	//
	// Unit: SECONDS
	//
	// Statistics: AVG
	//
	// AFTER_CONTACT_WORK_TIME
	//
	// Unit: SECONDS
	//
	// Statistics: AVG
	//
	// QUEUED_TIME
	//
	// Unit: SECONDS
	//
	// Statistics: MAX
	//
	// ABANDON_TIME
	//
	// Unit: COUNT
	//
	// Statistics: SUM
	//
	// QUEUE_ANSWER_TIME
	//
	// Unit: SECONDS
	//
	// Statistics: AVG
	//
	// HOLD_TIME
	//
	// Unit: SECONDS
	//
	// Statistics: AVG
	//
	// INTERACTION_TIME
	//
	// Unit: SECONDS
	//
	// Statistics: AVG
	//
	// INTERACTION_AND_HOLD_TIME
	//
	// Unit: SECONDS
	//
	// Statistics: AVG
	//
	// SERVICE_LEVEL
	//
	// Unit: PERCENT
	//
	// Statistics: AVG
	//
	// Threshold: Only "Less than" comparisons are supported, with the following
	// service level thresholds: 15, 20, 25, 30, 45, 60, 90, 120, 180, 240, 300,
	// 600
	//
	// HistoricalMetrics is a required field
	HistoricalMetrics []HistoricalMetric `type:"list" required:"true"`

	// The identifier for your Amazon Connect instance. To find the ID of your instance,
	// open the AWS console and select Amazon Connect. Select the alias of the instance
	// in the Instance alias column. The instance ID is displayed in the Overview
	// section of your instance settings. For example, the instance ID is the set
	// of characters at the end of the instance ARN, after instance/, such as 10a4c4eb-f57e-4d4c-b602-bf39176ced07.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Indicates the maximum number of results to return per page in the response,
	// between 1-100.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The timestamp, in UNIX Epoch time format, at which to start the reporting
	// interval for the retrieval of historical metrics data. The time must be specified
	// using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
	//
	// StartTime cannot be earlier than 24 hours before the time of the request.
	// Historical metrics are available in Amazon Connect only for 24 hours.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s GetMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMetricDataInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}

	if s.HistoricalMetrics == nil {
		invalidParams.Add(aws.NewErrParamRequired("HistoricalMetrics"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMetricDataInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filters", v, metadata)
	}
	if len(s.Groupings) > 0 {
		v := s.Groupings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Groupings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.HistoricalMetrics) > 0 {
		v := s.HistoricalMetrics

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "HistoricalMetrics", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataResponse
type GetMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// A list of HistoricalMetricResult objects, organized by Dimensions, which
	// is the ID of the resource specified in the Filters used for the request.
	// The metrics are combined with the metrics included in Collections, which
	// is a list of HisotricalMetricData objects.
	//
	// If no Grouping is specified in the request, Collections includes summary
	// data for the HistoricalMetrics.
	MetricResults []HistoricalMetricResult `type:"list"`

	// A string returned in the response. Use the value returned in the response
	// as the value of the NextToken in a subsequent request to retrieve the next
	// set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the NextToken must use the same request parameters as the
	// request that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMetricDataOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.MetricResults) > 0 {
		v := s.MetricResults

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MetricResults", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// The GetMetricData operation retrieves historical metrics data from your Amazon
// Connect instance.
//
// If you are using an IAM account, it must have permission to the connect:GetMetricData
// action.
//
//    // Example sending a request using GetMetricDataRequest.
//    req := client.GetMetricDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Client) GetMetricDataRequest(input *GetMetricDataInput) GetMetricDataRequest {
	op := &aws.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/historical/{InstanceId}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	req := c.newRequest(op, input, &GetMetricDataOutput{})
	return GetMetricDataRequest{Request: req, Input: input, Copy: c.GetMetricDataRequest}
}

// GetMetricDataRequest is the request type for the
// GetMetricData API operation.
type GetMetricDataRequest struct {
	*aws.Request
	Input *GetMetricDataInput
	Copy  func(*GetMetricDataInput) GetMetricDataRequest
}

// Send marshals and sends the GetMetricData API request.
func (r GetMetricDataRequest) Send(ctx context.Context) (*GetMetricDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMetricDataResponse{
		GetMetricDataOutput: r.Request.Data.(*GetMetricDataOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetMetricDataRequestPaginator returns a paginator for GetMetricData.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetMetricDataRequest(input)
//   p := connect.NewGetMetricDataRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetMetricDataPaginator(req GetMetricDataRequest) GetMetricDataPaginator {
	return GetMetricDataPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetMetricDataInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetMetricDataPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetMetricDataPaginator struct {
	aws.Pager
}

func (p *GetMetricDataPaginator) CurrentPage() *GetMetricDataOutput {
	return p.Pager.CurrentPage().(*GetMetricDataOutput)
}

// GetMetricDataResponse is the response type for the
// GetMetricData API operation.
type GetMetricDataResponse struct {
	*GetMetricDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMetricData request.
func (r *GetMetricDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
