// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroupMessage
type DeleteReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The subnet group name of the replication instance.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationSubnetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteReplicationSubnetGroupInput"}

	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroupResponse
type DeleteReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteReplicationSubnetGroup = "DeleteReplicationSubnetGroup"

// DeleteReplicationSubnetGroupRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Deletes a subnet group.
//
//    // Example sending a request using DeleteReplicationSubnetGroupRequest.
//    req := client.DeleteReplicationSubnetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup
func (c *Client) DeleteReplicationSubnetGroupRequest(input *DeleteReplicationSubnetGroupInput) DeleteReplicationSubnetGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationSubnetGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteReplicationSubnetGroupOutput{})
	return DeleteReplicationSubnetGroupRequest{Request: req, Input: input, Copy: c.DeleteReplicationSubnetGroupRequest}
}

// DeleteReplicationSubnetGroupRequest is the request type for the
// DeleteReplicationSubnetGroup API operation.
type DeleteReplicationSubnetGroupRequest struct {
	*aws.Request
	Input *DeleteReplicationSubnetGroupInput
	Copy  func(*DeleteReplicationSubnetGroupInput) DeleteReplicationSubnetGroupRequest
}

// Send marshals and sends the DeleteReplicationSubnetGroup API request.
func (r DeleteReplicationSubnetGroupRequest) Send(ctx context.Context) (*DeleteReplicationSubnetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteReplicationSubnetGroupResponse{
		DeleteReplicationSubnetGroupOutput: r.Request.Data.(*DeleteReplicationSubnetGroupOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteReplicationSubnetGroupResponse is the response type for the
// DeleteReplicationSubnetGroup API operation.
type DeleteReplicationSubnetGroupResponse struct {
	*DeleteReplicationSubnetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteReplicationSubnetGroup request.
func (r *DeleteReplicationSubnetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
