// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datapipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribePipelines.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribePipelinesInput
type DescribePipelinesInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the pipelines to describe. You can pass as many as 25 identifiers
	// in a single call. To obtain pipeline IDs, call ListPipelines.
	//
	// PipelineIds is a required field
	PipelineIds []string `locationName:"pipelineIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribePipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePipelinesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePipelinesInput"}

	if s.PipelineIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("PipelineIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribePipelines.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribePipelinesOutput
type DescribePipelinesOutput struct {
	_ struct{} `type:"structure"`

	// An array of descriptions for the specified pipelines.
	//
	// PipelineDescriptionList is a required field
	PipelineDescriptionList []PipelineDescription `locationName:"pipelineDescriptionList" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribePipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePipelines = "DescribePipelines"

// DescribePipelinesRequest returns a request value for making API operation for
// AWS Data Pipeline.
//
// Retrieves metadata about one or more pipelines. The information retrieved
// includes the name of the pipeline, the pipeline identifier, its current state,
// and the user account that owns the pipeline. Using account credentials, you
// can retrieve metadata about pipelines that you or your IAM users have created.
// If you are using an IAM user account, you can retrieve metadata about only
// those pipelines for which you have read permissions.
//
// To retrieve the full pipeline definition instead of metadata about the pipeline,
// call GetPipelineDefinition.
//
//    // Example sending a request using DescribePipelinesRequest.
//    req := client.DescribePipelinesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datapipeline-2012-10-29/DescribePipelines
func (c *Client) DescribePipelinesRequest(input *DescribePipelinesInput) DescribePipelinesRequest {
	op := &aws.Operation{
		Name:       opDescribePipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePipelinesInput{}
	}

	req := c.newRequest(op, input, &DescribePipelinesOutput{})
	return DescribePipelinesRequest{Request: req, Input: input, Copy: c.DescribePipelinesRequest}
}

// DescribePipelinesRequest is the request type for the
// DescribePipelines API operation.
type DescribePipelinesRequest struct {
	*aws.Request
	Input *DescribePipelinesInput
	Copy  func(*DescribePipelinesInput) DescribePipelinesRequest
}

// Send marshals and sends the DescribePipelines API request.
func (r DescribePipelinesRequest) Send(ctx context.Context) (*DescribePipelinesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePipelinesResponse{
		DescribePipelinesOutput: r.Request.Data.(*DescribePipelinesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribePipelinesResponse is the response type for the
// DescribePipelines API operation.
type DescribePipelinesResponse struct {
	*DescribePipelinesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePipelines request.
func (r *DescribePipelinesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
