// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the inputs for the UpdateRadius operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadiusRequest
type UpdateRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to update the RADIUS server information.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	//
	// RadiusSettings is a required field
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRadiusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateRadiusInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.RadiusSettings == nil {
		invalidParams.Add(aws.NewErrParamRequired("RadiusSettings"))
	}
	if s.RadiusSettings != nil {
		if err := s.RadiusSettings.Validate(); err != nil {
			invalidParams.AddNested("RadiusSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the UpdateRadius operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadiusResult
type UpdateRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateRadius = "UpdateRadius"

// UpdateRadiusRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Updates the Remote Authentication Dial In User Service (RADIUS) server information
// for an AD Connector or Microsoft AD directory.
//
//    // Example sending a request using UpdateRadiusRequest.
//    req := client.UpdateRadiusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadius
func (c *Client) UpdateRadiusRequest(input *UpdateRadiusInput) UpdateRadiusRequest {
	op := &aws.Operation{
		Name:       opUpdateRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRadiusInput{}
	}

	req := c.newRequest(op, input, &UpdateRadiusOutput{})
	return UpdateRadiusRequest{Request: req, Input: input, Copy: c.UpdateRadiusRequest}
}

// UpdateRadiusRequest is the request type for the
// UpdateRadius API operation.
type UpdateRadiusRequest struct {
	*aws.Request
	Input *UpdateRadiusInput
	Copy  func(*UpdateRadiusInput) UpdateRadiusRequest
}

// Send marshals and sends the UpdateRadius API request.
func (r UpdateRadiusRequest) Send(ctx context.Context) (*UpdateRadiusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateRadiusResponse{
		UpdateRadiusOutput: r.Request.Data.(*UpdateRadiusOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateRadiusResponse is the response type for the
// UpdateRadius API operation.
type UpdateRadiusResponse struct {
	*UpdateRadiusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateRadius request.
func (r *UpdateRadiusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
