// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplatesRequest
type DescribeLaunchTemplatesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//    * create-time - The time the launch template was created.
	//
	//    * launch-template-name - The name of the launch template.
	//
	//    * tag:<key> - The key/value combination of a tag assigned to the resource.
	//    Use the tag key in the filter name and the tag value as the filter value.
	//    For example, to find all resources that have a tag with the key Owner
	//    and the value TeamA, specify tag:Owner for the filter name and TeamA for
	//    the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. Use this filter
	//    to find all resources assigned a tag with a specific key, regardless of
	//    the tag value.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// One or more launch template IDs.
	LaunchTemplateIds []string `locationName:"LaunchTemplateId" locationNameList:"item" type:"list"`

	// One or more launch template names.
	LaunchTemplateNames []string `locationName:"LaunchTemplateName" locationNameList:"item" type:"list"`

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned NextToken value. This
	// value can be between 1 and 200.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLaunchTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLaunchTemplatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeLaunchTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplatesResult
type DescribeLaunchTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the launch templates.
	LaunchTemplates []LaunchTemplate `locationName:"launchTemplates" locationNameList:"item" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeLaunchTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeLaunchTemplates = "DescribeLaunchTemplates"

// DescribeLaunchTemplatesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes one or more launch templates.
//
//    // Example sending a request using DescribeLaunchTemplatesRequest.
//    req := client.DescribeLaunchTemplatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeLaunchTemplates
func (c *Client) DescribeLaunchTemplatesRequest(input *DescribeLaunchTemplatesInput) DescribeLaunchTemplatesRequest {
	op := &aws.Operation{
		Name:       opDescribeLaunchTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLaunchTemplatesInput{}
	}

	req := c.newRequest(op, input, &DescribeLaunchTemplatesOutput{})
	return DescribeLaunchTemplatesRequest{Request: req, Input: input, Copy: c.DescribeLaunchTemplatesRequest}
}

// DescribeLaunchTemplatesRequest is the request type for the
// DescribeLaunchTemplates API operation.
type DescribeLaunchTemplatesRequest struct {
	*aws.Request
	Input *DescribeLaunchTemplatesInput
	Copy  func(*DescribeLaunchTemplatesInput) DescribeLaunchTemplatesRequest
}

// Send marshals and sends the DescribeLaunchTemplates API request.
func (r DescribeLaunchTemplatesRequest) Send(ctx context.Context) (*DescribeLaunchTemplatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeLaunchTemplatesResponse{
		DescribeLaunchTemplatesOutput: r.Request.Data.(*DescribeLaunchTemplatesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeLaunchTemplatesRequestPaginator returns a paginator for DescribeLaunchTemplates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeLaunchTemplatesRequest(input)
//   p := ec2.NewDescribeLaunchTemplatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeLaunchTemplatesPaginator(req DescribeLaunchTemplatesRequest) DescribeLaunchTemplatesPaginator {
	return DescribeLaunchTemplatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeLaunchTemplatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeLaunchTemplatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeLaunchTemplatesPaginator struct {
	aws.Pager
}

func (p *DescribeLaunchTemplatesPaginator) CurrentPage() *DescribeLaunchTemplatesOutput {
	return p.Pager.CurrentPage().(*DescribeLaunchTemplatesOutput)
}

// DescribeLaunchTemplatesResponse is the response type for the
// DescribeLaunchTemplates API operation.
type DescribeLaunchTemplatesResponse struct {
	*DescribeLaunchTemplatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeLaunchTemplates request.
func (r *DescribeLaunchTemplatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
