// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitContainerStateChangeRequest
type SubmitContainerStateChangeInput struct {
	_ struct{} `type:"structure"`

	// The short name or full ARN of the cluster that hosts the container.
	Cluster *string `locationName:"cluster" type:"string"`

	// The name of the container.
	ContainerName *string `locationName:"containerName" type:"string"`

	// The exit code returned for the state change request.
	ExitCode *int64 `locationName:"exitCode" type:"integer"`

	// The network bindings of the container.
	NetworkBindings []NetworkBinding `locationName:"networkBindings" type:"list"`

	// The reason for the state change request.
	Reason *string `locationName:"reason" type:"string"`

	// The status of the state change request.
	Status *string `locationName:"status" type:"string"`

	// The task ID or full Amazon Resource Name (ARN) of the task that hosts the
	// container.
	Task *string `locationName:"task" type:"string"`
}

// String returns the string representation
func (s SubmitContainerStateChangeInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitContainerStateChangeResponse
type SubmitContainerStateChangeOutput struct {
	_ struct{} `type:"structure"`

	// Acknowledgement of the state change.
	Acknowledgment *string `locationName:"acknowledgment" type:"string"`
}

// String returns the string representation
func (s SubmitContainerStateChangeOutput) String() string {
	return awsutil.Prettify(s)
}

const opSubmitContainerStateChange = "SubmitContainerStateChange"

// SubmitContainerStateChangeRequest returns a request value for making API operation for
// Amazon EC2 Container Service.
//
//
// This action is only used by the Amazon ECS agent, and it is not intended
// for use outside of the agent.
//
// Sent to acknowledge that a container changed states.
//
//    // Example sending a request using SubmitContainerStateChangeRequest.
//    req := client.SubmitContainerStateChangeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/SubmitContainerStateChange
func (c *Client) SubmitContainerStateChangeRequest(input *SubmitContainerStateChangeInput) SubmitContainerStateChangeRequest {
	op := &aws.Operation{
		Name:       opSubmitContainerStateChange,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubmitContainerStateChangeInput{}
	}

	req := c.newRequest(op, input, &SubmitContainerStateChangeOutput{})
	return SubmitContainerStateChangeRequest{Request: req, Input: input, Copy: c.SubmitContainerStateChangeRequest}
}

// SubmitContainerStateChangeRequest is the request type for the
// SubmitContainerStateChange API operation.
type SubmitContainerStateChangeRequest struct {
	*aws.Request
	Input *SubmitContainerStateChangeInput
	Copy  func(*SubmitContainerStateChangeInput) SubmitContainerStateChangeRequest
}

// Send marshals and sends the SubmitContainerStateChange API request.
func (r SubmitContainerStateChangeRequest) Send(ctx context.Context) (*SubmitContainerStateChangeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SubmitContainerStateChangeResponse{
		SubmitContainerStateChangeOutput: r.Request.Data.(*SubmitContainerStateChangeOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SubmitContainerStateChangeResponse is the response type for the
// SubmitContainerStateChange API operation.
type SubmitContainerStateChangeResponse struct {
	*SubmitContainerStateChangeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SubmitContainerStateChange request.
func (r *SubmitContainerStateChangeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
