// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DeleteLoadBalancerPolicy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteLoadBalancerPolicyInput
type DeleteLoadBalancerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLoadBalancerPolicyInput"}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeleteLoadBalancerPolicy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteLoadBalancerPolicyOutput
type DeleteLoadBalancerPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoadBalancerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteLoadBalancerPolicy = "DeleteLoadBalancerPolicy"

// DeleteLoadBalancerPolicyRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Deletes the specified policy from the specified load balancer. This policy
// must not be enabled for any listeners.
//
//    // Example sending a request using DeleteLoadBalancerPolicyRequest.
//    req := client.DeleteLoadBalancerPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/DeleteLoadBalancerPolicy
func (c *Client) DeleteLoadBalancerPolicyRequest(input *DeleteLoadBalancerPolicyInput) DeleteLoadBalancerPolicyRequest {
	op := &aws.Operation{
		Name:       opDeleteLoadBalancerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerPolicyInput{}
	}

	req := c.newRequest(op, input, &DeleteLoadBalancerPolicyOutput{})
	return DeleteLoadBalancerPolicyRequest{Request: req, Input: input, Copy: c.DeleteLoadBalancerPolicyRequest}
}

// DeleteLoadBalancerPolicyRequest is the request type for the
// DeleteLoadBalancerPolicy API operation.
type DeleteLoadBalancerPolicyRequest struct {
	*aws.Request
	Input *DeleteLoadBalancerPolicyInput
	Copy  func(*DeleteLoadBalancerPolicyInput) DeleteLoadBalancerPolicyRequest
}

// Send marshals and sends the DeleteLoadBalancerPolicy API request.
func (r DeleteLoadBalancerPolicyRequest) Send(ctx context.Context) (*DeleteLoadBalancerPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLoadBalancerPolicyResponse{
		DeleteLoadBalancerPolicyOutput: r.Request.Data.(*DeleteLoadBalancerPolicyOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLoadBalancerPolicyResponse is the response type for the
// DeleteLoadBalancerPolicy API operation.
type DeleteLoadBalancerPolicyResponse struct {
	*DeleteLoadBalancerPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLoadBalancerPolicy request.
func (r *DeleteLoadBalancerPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
