// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for EnableAvailabilityZonesForLoadBalancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AddAvailabilityZonesInput
type EnableAvailabilityZonesForLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zones. These must be in the same region as the load balancer.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []string `type:"list" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnableAvailabilityZonesForLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableAvailabilityZonesForLoadBalancerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnableAvailabilityZonesForLoadBalancerInput"}

	if s.AvailabilityZones == nil {
		invalidParams.Add(aws.NewErrParamRequired("AvailabilityZones"))
	}

	if s.LoadBalancerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of EnableAvailabilityZonesForLoadBalancer.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/AddAvailabilityZonesOutput
type EnableAvailabilityZonesForLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// The updated list of Availability Zones for the load balancer.
	AvailabilityZones []string `type:"list"`
}

// String returns the string representation
func (s EnableAvailabilityZonesForLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

const opEnableAvailabilityZonesForLoadBalancer = "EnableAvailabilityZonesForLoadBalancer"

// EnableAvailabilityZonesForLoadBalancerRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Adds the specified Availability Zones to the set of Availability Zones for
// the specified load balancer in EC2-Classic or a default VPC.
//
// For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets.
//
// The load balancer evenly distributes requests across all its registered Availability
// Zones that contain instances. For more information, see Add or Remove Availability
// Zones (http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html)
// in the Classic Load Balancers Guide.
//
//    // Example sending a request using EnableAvailabilityZonesForLoadBalancerRequest.
//    req := client.EnableAvailabilityZonesForLoadBalancerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/EnableAvailabilityZonesForLoadBalancer
func (c *Client) EnableAvailabilityZonesForLoadBalancerRequest(input *EnableAvailabilityZonesForLoadBalancerInput) EnableAvailabilityZonesForLoadBalancerRequest {
	op := &aws.Operation{
		Name:       opEnableAvailabilityZonesForLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableAvailabilityZonesForLoadBalancerInput{}
	}

	req := c.newRequest(op, input, &EnableAvailabilityZonesForLoadBalancerOutput{})
	return EnableAvailabilityZonesForLoadBalancerRequest{Request: req, Input: input, Copy: c.EnableAvailabilityZonesForLoadBalancerRequest}
}

// EnableAvailabilityZonesForLoadBalancerRequest is the request type for the
// EnableAvailabilityZonesForLoadBalancer API operation.
type EnableAvailabilityZonesForLoadBalancerRequest struct {
	*aws.Request
	Input *EnableAvailabilityZonesForLoadBalancerInput
	Copy  func(*EnableAvailabilityZonesForLoadBalancerInput) EnableAvailabilityZonesForLoadBalancerRequest
}

// Send marshals and sends the EnableAvailabilityZonesForLoadBalancer API request.
func (r EnableAvailabilityZonesForLoadBalancerRequest) Send(ctx context.Context) (*EnableAvailabilityZonesForLoadBalancerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EnableAvailabilityZonesForLoadBalancerResponse{
		EnableAvailabilityZonesForLoadBalancerOutput: r.Request.Data.(*EnableAvailabilityZonesForLoadBalancerOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EnableAvailabilityZonesForLoadBalancerResponse is the response type for the
// EnableAvailabilityZonesForLoadBalancer API operation.
type EnableAvailabilityZonesForLoadBalancerResponse struct {
	*EnableAvailabilityZonesForLoadBalancerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// EnableAvailabilityZonesForLoadBalancer request.
func (r *EnableAvailabilityZonesForLoadBalancerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
