// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The ReadPipelineRequest structure.
type ReadPipelineInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the pipeline to read.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s ReadPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReadPipelineInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReadPipelineInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReadPipelineInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The ReadPipelineResponse structure.
type ReadPipelineOutput struct {
	_ struct{} `type:"structure"`

	// A section of the response body that provides information about the pipeline.
	Pipeline *Pipeline `type:"structure"`

	// Elastic Transcoder returns a warning if the resources used by your pipeline
	// are not in the same region as the pipeline.
	//
	// Using resources in the same region, such as your Amazon S3 buckets, Amazon
	// SNS notification topics, and AWS KMS key, reduces processing time and prevents
	// cross-regional charges.
	Warnings []Warning `type:"list"`
}

// String returns the string representation
func (s ReadPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReadPipelineOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Pipeline != nil {
		v := s.Pipeline

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Pipeline", v, metadata)
	}
	if len(s.Warnings) > 0 {
		v := s.Warnings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Warnings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opReadPipeline = "ReadPipeline"

// ReadPipelineRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The ReadPipeline operation gets detailed information about a pipeline.
//
//    // Example sending a request using ReadPipelineRequest.
//    req := client.ReadPipelineRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ReadPipelineRequest(input *ReadPipelineInput) ReadPipelineRequest {
	op := &aws.Operation{
		Name:       opReadPipeline,
		HTTPMethod: "GET",
		HTTPPath:   "/2012-09-25/pipelines/{Id}",
	}

	if input == nil {
		input = &ReadPipelineInput{}
	}

	req := c.newRequest(op, input, &ReadPipelineOutput{})
	return ReadPipelineRequest{Request: req, Input: input, Copy: c.ReadPipelineRequest}
}

// ReadPipelineRequest is the request type for the
// ReadPipeline API operation.
type ReadPipelineRequest struct {
	*aws.Request
	Input *ReadPipelineInput
	Copy  func(*ReadPipelineInput) ReadPipelineRequest
}

// Send marshals and sends the ReadPipeline API request.
func (r ReadPipelineRequest) Send(ctx context.Context) (*ReadPipelineResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ReadPipelineResponse{
		ReadPipelineOutput: r.Request.Data.(*ReadPipelineOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ReadPipelineResponse is the response type for the
// ReadPipeline API operation.
type ReadPipelineResponse struct {
	*ReadPipelineOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ReadPipeline request.
func (r *ReadPipelineResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
