// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package fms

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Details of the resource that is not protected by the policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ComplianceViolator
type ComplianceViolator struct {
	_ struct{} `type:"structure"`

	// The resource ID.
	ResourceId *string `min:"1" type:"string"`

	// The resource type. This is in the format shown in AWS Resource Types Reference
	// (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For example: AWS::ElasticLoadBalancingV2::LoadBalancer or AWS::CloudFront::Distribution.
	ResourceType *string `min:"1" type:"string"`

	// The reason that the resource is not protected by the policy.
	ViolationReason ViolationReason `type:"string" enum:"true"`
}

// String returns the string representation
func (s ComplianceViolator) String() string {
	return awsutil.Prettify(s)
}

// Describes the compliance status for the account. An account is considered
// non-compliant if it includes resources that are not protected by the specified
// policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/EvaluationResult
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Describes an AWS account's compliance with the AWS Firewall Manager policy.
	ComplianceStatus PolicyComplianceStatusType `type:"string" enum:"true"`

	// Indicates that over 100 resources are non-compliant with the AWS Firewall
	// Manager policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// Number of resources that are non-compliant with the specified policy. A resource
	// is considered non-compliant if it is not associated with the specified policy.
	ViolatorCount *int64 `type:"long"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// An AWS Firewall Manager policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/Policy
type Policy struct {
	_ struct{} `type:"structure"`

	// Specifies the AWS account IDs to exclude from the policy. The IncludeMap
	// values are evaluated first, with all the appropriate account IDs added to
	// the policy. Then the accounts listed in ExcludeMap are removed, resulting
	// in the final list of accounts to add to the policy.
	//
	// The key to the map is ACCOUNT. For example, a valid ExcludeMap would be {“ACCOUNT”
	// : [“accountID1”, “accountID2”]}.
	ExcludeMap map[string][]string `type:"map"`

	// If set to True, resources with the tags that are specified in the ResourceTag
	// array are not protected by the policy. If set to False, and the ResourceTag
	// array is not null, only resources with the specified tags are associated
	// with the policy.
	//
	// ExcludeResourceTags is a required field
	ExcludeResourceTags *bool `type:"boolean" required:"true"`

	// Specifies the AWS account IDs to include in the policy. If IncludeMap is
	// null, all accounts in the organization in AWS Organizations are included
	// in the policy. If IncludeMap is not null, only values listed in IncludeMap
	// are included in the policy.
	//
	// The key to the map is ACCOUNT. For example, a valid IncludeMap would be {“ACCOUNT”
	// : [“accountID1”, “accountID2”]}.
	IncludeMap map[string][]string `type:"map"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The friendly name of the AWS Firewall Manager policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// A unique identifier for each update to the policy. When issuing a PutPolicy
	// request, the PolicyUpdateToken in the request must match the PolicyUpdateToken
	// of the current policy version. To get the PolicyUpdateToken of the current
	// policy version, use a GetPolicy request.
	PolicyUpdateToken *string `min:"1" type:"string"`

	// Indicates if the policy should be automatically applied to new resources.
	//
	// RemediationEnabled is a required field
	RemediationEnabled *bool `type:"boolean" required:"true"`

	// An array of ResourceTag objects.
	ResourceTags []ResourceTag `type:"list"`

	// The type of resource to protect with the policy. This is in the format shown
	// in AWS Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For example: AWS::ElasticLoadBalancingV2::LoadBalancer or AWS::CloudFront::Distribution.
	//
	// ResourceType is a required field
	ResourceType *string `min:"1" type:"string" required:"true"`

	// An array of ResourceType.
	ResourceTypeList []string `type:"list"`

	// Details about the security service that is being used to protect the resources.
	//
	// SecurityServicePolicyData is a required field
	SecurityServicePolicyData *SecurityServicePolicyData `type:"structure" required:"true"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Policy) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Policy"}

	if s.ExcludeResourceTags == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExcludeResourceTags"))
	}
	if s.PolicyId != nil && len(*s.PolicyId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyId", 36))
	}

	if s.PolicyName == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyUpdateToken != nil && len(*s.PolicyUpdateToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyUpdateToken", 1))
	}

	if s.RemediationEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("RemediationEnabled"))
	}

	if s.ResourceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceType", 1))
	}

	if s.SecurityServicePolicyData == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityServicePolicyData"))
	}
	if s.ResourceTags != nil {
		for i, v := range s.ResourceTags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceTags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SecurityServicePolicyData != nil {
		if err := s.SecurityServicePolicyData.Validate(); err != nil {
			invalidParams.AddNested("SecurityServicePolicyData", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the non-compliant resources in a member account for a specific
// AWS Firewall Manager policy. A maximum of 100 entries are displayed. If more
// than 100 resources are non-compliant, EvaluationLimitExceeded is set to True.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PolicyComplianceDetail
type PolicyComplianceDetail struct {
	_ struct{} `type:"structure"`

	// Indicates if over 100 resources are non-compliant with the AWS Firewall Manager
	// policy.
	EvaluationLimitExceeded *bool `type:"boolean"`

	// A time stamp that indicates when the returned information should be considered
	// out-of-date.
	ExpiredAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Details about problems with dependent services, such as AWS WAF or AWS Config,
	// that are causing a resource to be non-compliant. The details include the
	// name of the dependent service and the error message received that indicates
	// the problem with the service.
	IssueInfoMap map[string]string `type:"map"`

	// The AWS account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The AWS account that created the AWS Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`

	// An array of resources that are not protected by the policy.
	Violators []ComplianceViolator `type:"list"`
}

// String returns the string representation
func (s PolicyComplianceDetail) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether the account is compliant with the specified policy. An
// account is considered non-compliant if it includes resources that are not
// protected by the policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PolicyComplianceStatus
type PolicyComplianceStatus struct {
	_ struct{} `type:"structure"`

	// An array of EvaluationResult objects.
	EvaluationResults []EvaluationResult `type:"list"`

	// Details about problems with dependent services, such as AWS WAF or AWS Config,
	// that are causing a resource to be non-compliant. The details include the
	// name of the dependent service and the error message received that indicates
	// the problem with the service.
	IssueInfoMap map[string]string `type:"map"`

	// Time stamp of the last update to the EvaluationResult objects.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The member account ID.
	MemberAccount *string `min:"1" type:"string"`

	// The ID of the AWS Firewall Manager policy.
	PolicyId *string `min:"36" type:"string"`

	// The friendly name of the AWS Firewall Manager policy.
	PolicyName *string `min:"1" type:"string"`

	// The AWS account that created the AWS Firewall Manager policy.
	PolicyOwner *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyComplianceStatus) String() string {
	return awsutil.Prettify(s)
}

// Details of the AWS Firewall Manager policy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/PolicySummary
type PolicySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the specified policy.
	PolicyArn *string `min:"1" type:"string"`

	// The ID of the specified policy.
	PolicyId *string `min:"36" type:"string"`

	// The friendly name of the specified policy.
	PolicyName *string `min:"1" type:"string"`

	// Indicates if the policy should be automatically applied to new resources.
	RemediationEnabled *bool `type:"boolean"`

	// The type of resource to protect with the policy. This is in the format shown
	// in AWS Resource Types Reference (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
	// For example: AWS::ElasticLoadBalancingV2::LoadBalancer or AWS::CloudFront::Distribution.
	ResourceType *string `min:"1" type:"string"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either a WAF policy or Shield Advanced
	// policy.
	SecurityServiceType SecurityServiceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s PolicySummary) String() string {
	return awsutil.Prettify(s)
}

// The resource tags that AWS Firewall Manager uses to determine if a particular
// resource should be included or excluded from protection by the AWS Firewall
// Manager policy. Tags enable you to categorize your AWS resources in different
// ways, for example, by purpose, owner, or environment. Each tag consists of
// a key and an optional value, both of which you define. Tags are combined
// with an "OR." That is, if you add more than one tag, if any of the tags matches,
// the resource is considered a match for the include or exclude. Working with
// Tag Editor (https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/ResourceTag
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The resource tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The resource tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceTag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Details about the security service that is being used to protect the resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/SecurityServicePolicyData
type SecurityServicePolicyData struct {
	_ struct{} `type:"structure"`

	// Details about the service. This contains WAF data in JSON format, as shown
	// in the following example:
	//
	// ManagedServiceData": "{\"type\": \"WAF\", \"ruleGroups\": [{\"id\": \"12345678-1bcd-9012-efga-0987654321ab\",
	// \"overrideAction\" : {\"type\": \"COUNT\"}}], \"defaultAction\": {\"type\":
	// \"BLOCK\"}}
	//
	// If this is a Shield Advanced policy, this string will be empty.
	ManagedServiceData *string `min:"1" type:"string"`

	// The service that the policy is using to protect the resources. This specifies
	// the type of policy that is created, either a WAF policy or Shield Advanced
	// policy.
	//
	// Type is a required field
	Type SecurityServiceType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SecurityServicePolicyData) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SecurityServicePolicyData) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SecurityServicePolicyData"}
	if s.ManagedServiceData != nil && len(*s.ManagedServiceData) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ManagedServiceData", 1))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
