// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package glacieriface provides an interface to enable mocking the Amazon Glacier service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package glacieriface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/glacier"
)

// ClientAPI provides an interface to enable mocking the
// glacier.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Glacier.
//    func myFunc(svc glacieriface.ClientAPI) bool {
//        // Make svc.AbortMultipartUpload request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := glacier.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        glacieriface.ClientPI
//    }
//    func (m *mockClientClient) AbortMultipartUpload(input *glacier.AbortMultipartUploadInput) (*glacier.AbortMultipartUploadOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AbortMultipartUploadRequest(*glacier.AbortMultipartUploadInput) glacier.AbortMultipartUploadRequest

	AbortVaultLockRequest(*glacier.AbortVaultLockInput) glacier.AbortVaultLockRequest

	AddTagsToVaultRequest(*glacier.AddTagsToVaultInput) glacier.AddTagsToVaultRequest

	CompleteMultipartUploadRequest(*glacier.CompleteMultipartUploadInput) glacier.CompleteMultipartUploadRequest

	CompleteVaultLockRequest(*glacier.CompleteVaultLockInput) glacier.CompleteVaultLockRequest

	CreateVaultRequest(*glacier.CreateVaultInput) glacier.CreateVaultRequest

	DeleteArchiveRequest(*glacier.DeleteArchiveInput) glacier.DeleteArchiveRequest

	DeleteVaultRequest(*glacier.DeleteVaultInput) glacier.DeleteVaultRequest

	DeleteVaultAccessPolicyRequest(*glacier.DeleteVaultAccessPolicyInput) glacier.DeleteVaultAccessPolicyRequest

	DeleteVaultNotificationsRequest(*glacier.DeleteVaultNotificationsInput) glacier.DeleteVaultNotificationsRequest

	DescribeJobRequest(*glacier.DescribeJobInput) glacier.DescribeJobRequest

	DescribeVaultRequest(*glacier.DescribeVaultInput) glacier.DescribeVaultRequest

	GetDataRetrievalPolicyRequest(*glacier.GetDataRetrievalPolicyInput) glacier.GetDataRetrievalPolicyRequest

	GetJobOutputRequest(*glacier.GetJobOutputInput) glacier.GetJobOutputRequest

	GetVaultAccessPolicyRequest(*glacier.GetVaultAccessPolicyInput) glacier.GetVaultAccessPolicyRequest

	GetVaultLockRequest(*glacier.GetVaultLockInput) glacier.GetVaultLockRequest

	GetVaultNotificationsRequest(*glacier.GetVaultNotificationsInput) glacier.GetVaultNotificationsRequest

	InitiateJobRequest(*glacier.InitiateJobInput) glacier.InitiateJobRequest

	InitiateMultipartUploadRequest(*glacier.InitiateMultipartUploadInput) glacier.InitiateMultipartUploadRequest

	InitiateVaultLockRequest(*glacier.InitiateVaultLockInput) glacier.InitiateVaultLockRequest

	ListJobsRequest(*glacier.ListJobsInput) glacier.ListJobsRequest

	ListMultipartUploadsRequest(*glacier.ListMultipartUploadsInput) glacier.ListMultipartUploadsRequest

	ListPartsRequest(*glacier.ListPartsInput) glacier.ListPartsRequest

	ListProvisionedCapacityRequest(*glacier.ListProvisionedCapacityInput) glacier.ListProvisionedCapacityRequest

	ListTagsForVaultRequest(*glacier.ListTagsForVaultInput) glacier.ListTagsForVaultRequest

	ListVaultsRequest(*glacier.ListVaultsInput) glacier.ListVaultsRequest

	PurchaseProvisionedCapacityRequest(*glacier.PurchaseProvisionedCapacityInput) glacier.PurchaseProvisionedCapacityRequest

	RemoveTagsFromVaultRequest(*glacier.RemoveTagsFromVaultInput) glacier.RemoveTagsFromVaultRequest

	SetDataRetrievalPolicyRequest(*glacier.SetDataRetrievalPolicyInput) glacier.SetDataRetrievalPolicyRequest

	SetVaultAccessPolicyRequest(*glacier.SetVaultAccessPolicyInput) glacier.SetVaultAccessPolicyRequest

	SetVaultNotificationsRequest(*glacier.SetVaultNotificationsInput) glacier.SetVaultNotificationsRequest

	UploadArchiveRequest(*glacier.UploadArchiveInput) glacier.UploadArchiveRequest

	UploadMultipartPartRequest(*glacier.UploadMultipartPartInput) glacier.UploadMultipartPartRequest

	WaitUntilVaultExists(context.Context, *glacier.DescribeVaultInput, ...aws.WaiterOption) error

	WaitUntilVaultNotExists(context.Context, *glacier.DescribeVaultInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*glacier.Client)(nil)
