// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiersRequest
type GetClassifiersInput struct {
	_ struct{} `type:"structure"`

	// The size of the list to return (optional).
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional continuation token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetClassifiersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClassifiersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetClassifiersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiersResponse
type GetClassifiersOutput struct {
	_ struct{} `type:"structure"`

	// The requested list of classifier objects.
	Classifiers []Classifier `type:"list"`

	// A continuation token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetClassifiersOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetClassifiers = "GetClassifiers"

// GetClassifiersRequest returns a request value for making API operation for
// AWS Glue.
//
// Lists all classifier objects in the Data Catalog.
//
//    // Example sending a request using GetClassifiersRequest.
//    req := client.GetClassifiersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers
func (c *Client) GetClassifiersRequest(input *GetClassifiersInput) GetClassifiersRequest {
	op := &aws.Operation{
		Name:       opGetClassifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetClassifiersInput{}
	}

	req := c.newRequest(op, input, &GetClassifiersOutput{})
	return GetClassifiersRequest{Request: req, Input: input, Copy: c.GetClassifiersRequest}
}

// GetClassifiersRequest is the request type for the
// GetClassifiers API operation.
type GetClassifiersRequest struct {
	*aws.Request
	Input *GetClassifiersInput
	Copy  func(*GetClassifiersInput) GetClassifiersRequest
}

// Send marshals and sends the GetClassifiers API request.
func (r GetClassifiersRequest) Send(ctx context.Context) (*GetClassifiersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetClassifiersResponse{
		GetClassifiersOutput: r.Request.Data.(*GetClassifiersOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetClassifiersRequestPaginator returns a paginator for GetClassifiers.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetClassifiersRequest(input)
//   p := glue.NewGetClassifiersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetClassifiersPaginator(req GetClassifiersRequest) GetClassifiersPaginator {
	return GetClassifiersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetClassifiersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetClassifiersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetClassifiersPaginator struct {
	aws.Pager
}

func (p *GetClassifiersPaginator) CurrentPage() *GetClassifiersOutput {
	return p.Pager.CurrentPage().(*GetClassifiersOutput)
}

// GetClassifiersResponse is the response type for the
// GetClassifiers API operation.
type GetClassifiersResponse struct {
	*GetClassifiersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetClassifiers request.
func (r *GetClassifiersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
