// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinitionRequest
type DeleteLoggerDefinitionInput struct {
	_ struct{} `type:"structure"`

	// LoggerDefinitionId is a required field
	LoggerDefinitionId *string `location:"uri" locationName:"LoggerDefinitionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoggerDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoggerDefinitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteLoggerDefinitionInput"}

	if s.LoggerDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LoggerDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteLoggerDefinitionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.LoggerDefinitionId != nil {
		v := *s.LoggerDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "LoggerDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinitionResponse
type DeleteLoggerDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoggerDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteLoggerDefinitionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteLoggerDefinition = "DeleteLoggerDefinition"

// DeleteLoggerDefinitionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Deletes a logger definition.
//
//    // Example sending a request using DeleteLoggerDefinitionRequest.
//    req := client.DeleteLoggerDefinitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition
func (c *Client) DeleteLoggerDefinitionRequest(input *DeleteLoggerDefinitionInput) DeleteLoggerDefinitionRequest {
	op := &aws.Operation{
		Name:       opDeleteLoggerDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/greengrass/definition/loggers/{LoggerDefinitionId}",
	}

	if input == nil {
		input = &DeleteLoggerDefinitionInput{}
	}

	req := c.newRequest(op, input, &DeleteLoggerDefinitionOutput{})
	return DeleteLoggerDefinitionRequest{Request: req, Input: input, Copy: c.DeleteLoggerDefinitionRequest}
}

// DeleteLoggerDefinitionRequest is the request type for the
// DeleteLoggerDefinition API operation.
type DeleteLoggerDefinitionRequest struct {
	*aws.Request
	Input *DeleteLoggerDefinitionInput
	Copy  func(*DeleteLoggerDefinitionInput) DeleteLoggerDefinitionRequest
}

// Send marshals and sends the DeleteLoggerDefinition API request.
func (r DeleteLoggerDefinitionRequest) Send(ctx context.Context) (*DeleteLoggerDefinitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteLoggerDefinitionResponse{
		DeleteLoggerDefinitionOutput: r.Request.Data.(*DeleteLoggerDefinitionOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteLoggerDefinitionResponse is the response type for the
// DeleteLoggerDefinition API operation.
type DeleteLoggerDefinitionResponse struct {
	*DeleteLoggerDefinitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteLoggerDefinition request.
func (r *DeleteLoggerDefinitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
